/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/mail/cmd/RCS/decodeid.c,v 1.13 1994/06/09 21:18:04 rr2b Exp $";
#endif

#include <stdio.h>
#include <mailconf.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef hpux
extern char *inet_ntoa();
#else /* hpux */
#include <arpa/inet.h>
#endif /* hpux */
#include <netdb.h>
#include <andrewos.h> /* sys/time.h */

main(argc, argv)
int argc;
unsigned char **argv;
{
    int i, j;
    unsigned int foo, bar, baz;
    struct in_addr A;
    unsigned char *cp;
    unsigned char Addr[5];
    unsigned char ArgCopy[20];
    struct hostent *Host;
    
    if (argc > 1) {
	for (i=1; i<argc; ++i) {
	    bzero(ArgCopy, sizeof(ArgCopy));
	    strncpy((char *) ArgCopy, (char *) argv[i], sizeof(ArgCopy));
	    ArgCopy[sizeof(ArgCopy)-1] = '\0';
	    cp=ArgCopy;
	    if (*cp == '+') ++cp;
	    foo = conv64toint(cp);
	    bar = conv64toint(cp+6);
	    bar = htonl(bar);
	    baz = conv64toint(cp+12);
	    printf("``%s'': generated %s from ", cp, NiceTime(foo));
	    strncpy((char *) Addr, (char *) &bar, 4);
	    Addr[4] = '\0';
	    Host = NULL;
	    if (Addr[0] != '\0') Host = gethostbyaddr(Addr, 4, AF_INET);
	    if (Host != NULL) {
		fputs(Host->h_name, stdout);
		fputs(" (", stdout);
	    };
	    fputc('[', stdout);
	    A.s_addr = bar;
	    fputs(inet_ntoa(A), stdout);
	    fputc(']', stdout);
	    if (Host != NULL) fputc(')', stdout);
	    j=strlen((char *) cp);
	    if (j <= 13) {
		printf(", ctr (mod 64) of %d.\n", baz);
	    } else {
		printf(", pid %d, ctr (mod 256) of %d.\n",
		       (baz >> 16) & 0xFFFF, (baz >> 8) & 0xFF);
	    }
	}
	exit(0);
    }
    else {
	printf("usage: %s id [id] [id]...\n", argv[0]);
	exit(2);
    }
}
