/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/eli/lib/RCS/ht.c,v 2.6 1992/12/15 21:01:25 rr2b R6tape $";
#endif

#include  <ht.h>

/* Default hashing function */

int             eliHT_Hash(key)
char           *key;
{
    int             result = 0;
    char           *p = key;

    do
	result += *p;
    while (*(p++));
    return (result % NUMBUCKETS);
}

/* Initialize a hash table */

void            eliHT_Init(h)
eliHashTable_t *h;
{
    int             i;

    h->hash = eliHT_Hash;
    for (i = 0; i < NUMBUCKETS; ++i)
	eliBucket_Init(&(h->buckets[i]));
}

/*
 * Create a bucketnode to hold datum, and insert into the hash table with the
 * given key 
 */

void            eliHT_Insert(st, h, datum, key)
EliState_t     *st;
eliHashTable_t *h;
EliSexp_t      *datum;
char           *key;
{
    eliBucketNode_t *tmp;

    if (!(tmp = eliBucketNode_GetNew_trace(st, EliTraceStk(st), datum, key)))
	return;
    eliBucket_Insert(&(h->buckets[(*(h->hash)) (key)]), tmp);
}

/* Return the datum within the proper bucketnode whose key is key */

EliSexp_t      *eliHT_Find(h, key)
eliHashTable_t *h;
char           *key;
{
    return (eliBucket_Find(&(h->buckets[(*(h->hash)) (key)]), key));
}

/* Remove the bucketnode whose key is key */

void            eliHT_Delete(st, h, key)
EliState_t     *st;
eliHashTable_t *h;
char           *key;
{
    eliBucket_Delete(st, &(h->buckets[(*(h->hash)) (key)]), key);
}

/* Some may never wish to use this */

void            eliHT_SetHashFn(h, fn)
eliHashTable_t *h;
int             (*fn) ();

{
    h->hash = fn;
}
