/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/eli/lib/RCS/errops.c,v 2.8 1992/12/15 21:01:25 rr2b R6tape $";
#endif

#include <errops.h>

/* These are front-end routines to errnode operations */

int             EliErr_ErrP(st)	/* Has an error occurred? */
EliState_t     *st;
{
    return (st->g_errflag);
}

int             EliErr_ErrCode(st)
EliState_t     *st;
{
    return (eliErr_GetCode(EliErrNode(st)));
}

int EliErr_UnixErr(st)
EliState_t *st;
{
    return (eliErr_GetUnixErr(EliErrNode(st)));
}

EliSexp_t      *EliErr_BadSexp(st)
EliState_t     *st;
{
    return (eliErr_GetNode(EliErrNode(st)));
}

int             EliErr_BadSexpP(st)
EliState_t     *st;
{
    return (eliErr_GetNode(EliErrNode(st)) != NULL);
}

char           *EliErr_ErrLoc(st)
EliState_t     *st;
{
    return (eliErr_GetLoc(EliErrNode(st)));
}

int EliErr_BacktraceP(st)
EliState_t *st;
{
    return (eliErr_GetBacktrace(EliErrNode(st)) != NULL);
}

EliCons_t *EliErr_Backtrace(st)
EliState_t *st;
{
    return (eliErr_GetBacktrace(EliErrNode(st)));
}
