/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/overhead/eli/lib/RCS/eerror.c,v 2.10 1992/12/15 21:01:25 rr2b R6tape $";
#endif

#include  <eerror.h>

static char    *eliErrStrs[] =
{
    "Error from ELI client",
    "Out of Memory",
    "Bad Syntax",
    "Unbound Atom",
    "Undefined Function",
    "Bad Function Parameter",
    "Bad Argument",
    "Symbol Does Not Exist",
    "Wrong Number of Arguments to Function",
    "System Error",
    "User Error"
};

/* Definition of EliError, the all-purpose error-handler */

void            EliError(st, errtype, node, loc, unixerr)
EliState_t     *st;
int             errtype;
EliSexp_t      *node;
char           *loc;
int unixerr;
{
    void (*fn)();

    eliErr_Set(st, EliErrNode(st), errtype, node, loc, unixerr);
    st->g_errflag = TRUE;
    if (errtype & EliCatchMask(st)) {
        fn = EliCatchFn(st);
        (*fn)(st);
    }
}

char           *EliErrStr(code)        /* If code is a power of two <= 128,
                                        * this will return a string from
                                        * eliErrStrs. */
int             code;
{
    int             i, j;

    for (i = code, j = 0; i; (i = (i >> 1)), ++j);
    return (eliErrStrs[j]);
}

void            eliyyerror(s)
char           *s;
{
}

int             eliyywrap()
{
    EliProcessInfo.u_wrap = TRUE;
    return (1);
}
