/* Copyright 1994 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

 // ATKDynImpl: the system specific code to adapt the link line for a dynamic object.

#include <ATKOLinkI.H>
#include <fstream.h>

#include <ATKDoLoad.H>

ATKOLinkI::ATKOLinkI() {
}

ATKOLinkI::~ATKOLinkI() {
}

void ATKOLinkI::ProcessArgument(char *arg) {
    InsertArguments(arg);
   
}

void ATKOLinkI::ArgumentsDone() {
}

int ATKOLinkI::Test() {
    char *p, *base;
    long len;
    char buf[MAXPATHLEN+1];
    ResetIterator();
    while(p=NextArgument()) {
	if(p[0]=='-' && p[1]=='o' && p[2]=='\0') {
	    p=NextArgument();
	    break;
	}
    }
    if(p==NULL) {
	cerr<<"ATKOLinkI: couldn't find object filename on the link line."<<endl;
	return 1;
    }
    int (*entry)(int argc, char **argv)=ATKDoLoad(p,0);
    if(entry==NULL) {
	cerr<<"ATKOLinkI: couldn't dynamically load file "<<p<<"."<<endl;
	return 3;
    }
    return 0;
}

