/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


/* These routines are in an include file instead of a libary because they
 * depend on the internal structure of the doload_environment which may or
 * may not be the same between various machine types. In short, it would
 * have required rewriting more code than I have time to in order to do
 * this right. This solution gets source code sharing if nothing else...
 * Also this way, the safe routines are not exposedas externals in doload.
 */

static void doload_punt(struct doload_environment *e, char *message)
{
    fprintf(stderr, "doload:  %s\n", message);
    fflush(stderr);
    longjmp(e->errorJump, 1);
    /*NOTREACHED*/
}

static char *safe_malloc(struct doload_environment *e, int size)
{
    char *result;
    
    result = (char *)malloc((unsigned)size);
    if (result == NULL)
	doload_punt(e, "insufficient memory");
    return result;
}

static char *safe_realloc(struct doload_environment *e, char *ptr, int size)
{
    char *result;

    if (ptr == NULL)
	result = (char *)malloc((unsigned)size);
    else
	result = (char *)realloc(ptr, (unsigned)size);
    if (result == NULL)
	doload_punt(e, "insufficient memory");
    return result;
}

/* Not static since this is used by dofix. */
static void safe_free(char *thing)
{
    if (thing != NULL)
	free(thing);
    return ;
}

static safe_read(struct doload_environment *e, char *thing, int size)
{	
    if ((unsigned)read(e->fd, thing, (int)size) < size)
	doload_punt(e, "incomplete load file");
}

/* Not static since this is used by dofix. */
static void safe_write(struct doload_environment *e, int fd, char *thing, int size)
{
    int n;

    n = write(fd, thing, (int)size);
    if (n < size) {
	perror("dofix");
	doload_punt(e, "problems writing .do file");
    }
    return;
}

static safe_lseek(struct doload_environment *e, int offset, int how)
{	
    if (lseek(e->fd, offset, how) == -1)
	doload_punt(e, "seek failed");
}
