/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

#define	ZRTOOLS_NUM	(17)
#define	ZRCMDS_NUM	(6)
#define ZRPASTEMODES_NUM (4)
#define	ZRPATTERNS_NUM	(16)
#define	ZRBRUSHES_NUM	(14)

#define	RASTOOL_PAN	(1)
#define	RASTOOL_SELECT	(2)
#define RASTOOL_TOUCHUP (3)

#define	PASTEMODE_COPY	(1)
#define	PASTEMODE_OR	(2)
#define	PASTEMODE_XOR	(3)

struct span {
    long x, y;
    struct span *next;
};

class rastoolview [rastoolv] : lpair {
    classprocedures:
      InitializeClass() returns boolean; 
      InitializeObject(struct rastoolview *self) returns boolean;
      FinalizeObject(struct rastoolview *self);
    overrides:
      ObservedChanged(struct observable *observed, long status);
      UnlinkTree();
      PostMenus(struct menulist *ml);
      PostKeyState(struct keystate *ks);
    methods:
      SetPrimaryView(struct rasterview *zrview) returns boolean;
      WantSelectionHighlighted() returns boolean;
    macromethods:
      GetPrimaryView() ((self)->primaryview)
      GetToolnum() ((self)->toolnum)
      GetPasteMode() ((self)->pastemode)
      GetToolProc() ((self)->toolproc)
      SetMoribund(val) ((self)->moribund = (val))
    data:
      short moribund;
      struct menulist *Menus;
      struct keystate *Keystate;
      struct stringtbl *patterntbl;
      struct strtblview *vpatterntbl;
      short patternacc[ZRPATTERNS_NUM];
      struct stringtbl *brushtbl;
      struct strtblview *vbrushtbl;
      short brushacc[ZRBRUSHES_NUM];
      struct stringtbl *commandtbl;
      struct strtblview *vcommandtbl;
      short commandacc[ZRCMDS_NUM];
      struct stringtbl *pastemodetbl;
      struct strtblview *vpastemodetbl;
      short pastemodeacc[ZRPASTEMODES_NUM];
      struct stringtbl *tooltbl;
      struct strtblview *vtooltbl;
      short toolacc[ZRTOOLS_NUM];
      struct lpair *lpair1, *lpair2, *lpair3;
      int patternnum;
      unsigned char *pattern;
      int brushnum;
      unsigned char *brush;
      long pastemode;
      int pastemodenum;

      int toolnum;
      void (*toolproc)();
      struct rasterview *primaryview;
      long rockx, rocky, rockw, rockh, rock;
      double lastvx, lastvy;
      long lastx, lasty;
      int sprayradius;
      double springconst;
      int color;
      int fillbit;
      struct span *fillstack;
      struct rasterimage *fillpix;
      struct raster *pasteraster, *unpasteraster;
      boolean unpaste;
      struct dataobject *primaryobj;
};
