/* Copyright 1992 by the Andrew Toolkit Consortium and Carnegie Mellon University All rights Reserved. */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/



#include <list.ih>
#include <prefval.ih>
#include <mark.ih>
#include <style.ih>
#include <atom.ih>

struct prefdesc {
    char *name;
    char *app;
    char *group;
    char *seps;
    char *cond;
    char *val;
    struct prefval *obj;
    struct list *defviews;
    struct list *prevlines;
    enum prefval_Type type;
    long low, high;
    long listsize;
    boolean writetype;
    boolean writeviews;
    char *views;
    struct mark *mark;
    boolean shadow;
    boolean indefs;
    int order;
    boolean expert;
    long helppos;
    boolean freehelp;
    boolean freeobject;
    struct mark *pm;
};

struct prefline {
    struct list *prevlines;
    char *type;
    struct list *vl;
    char *app;
    char *name;
    char *group;
    char *cond;
    char *val;
    char *views;
    boolean shadow;
    long low, high;
    long helppos;
    int expert;
};

struct prefgroup {
    long grouphelp;
    char *name;
};

enum style_type {
    PrefsSubsection,
    PrefsGroupname
};

struct hstyles {
    long pos;
    long len;
    enum style_type type;
};

enum prefs_SortType {
    prefs_Name,
    prefs_App,
    prefs_Group,
    prefs_Order,
    prefs_MaxSortType
};

#define prefs_DS_VERSION 1

class prefs : text {
classprocedures:
    InitializeObject(struct prefval *self) returns boolean;
    FinalizeObject(struct prefval *self);
    TranslateViewName(char *name) returns char *;
methods:
    ReadDataPart() returns long;
    Sort(enum pref_SortType sortby, boolean perm);
    DuplicatePref(struct prefdesc *pd, char *newapp, char *newcond) returns struct prefdesc *;
    DeletePref(struct prefdesc *pd);
    WritePlain(FILE *fp, long id, long level) returns long;
    UpdateText();
    UpdateOneInText(struct prefdesc *pd);
    ReScan() returns long;
overrides:
    ObservedChanged(struct observable *changed, long val);
    ViewName() returns char *;
    Write(FILE *fp, long writeID, int level) returns long;
    Read(FILE *fp, long id) returns long;
macros:
macromethods:
    SetReadingDefaults(boolean rdefaults) (self->readingdefaults=(rdefaults))
data:
    struct list *prefs;
    boolean readingdefaults;
    struct prefline lastline;
    enum prefs_SortType sortby;
    char *lastheader;
    struct style *hstyle;
    struct style *pstyle;
    char *lastgroup;
    struct list *categories;
    boolean sane;
    struct text *help;
    long version;
    struct hstyles *llist;
    long llistsize, llistcnt;
    long maxorder;
    boolean selfmod;
};
