/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

/*
lookz.H

	lookz data object

	This inset provides for editing the styles of its parent text

	The file format for a lookz has a single line between
	\begindata and \enddata.  The only text on this line is one of the 
	words "visible" or "hidden", determining whether the 
	style editor is exposed or hidden in the text.

*/

#define  lookz_PROGRAMMERVERSION    1

/* status values for NotifyObservers */
#define lookz_VISIBILITYCHANGED 1
#define lookz_CANCLOSECHANGED 2
#define lookz_TEXTOBJECTCHANGED 4

class lookz : dataobject[dataobj]  {

overrides:

	Read( /* struct lookz *self, */ FILE *file, long id ) returns long;
	Write( /* struct lookz *self, */ FILE *file, long id, long level )
			returns long;
	ObservedChanged(/* struct lookzview *self, */ struct dataobject *dobj, long status);

methods:
	
	SetVisibility( /* struct lookz *self, */ boolean visible );
	SetTextObject(struct text *text);
	SetCanClose(boolean canClose);

macromethods:
	GetVisibility( /* struct lookz *self */ ) (((struct lookz *)self)->visible + 0)

        GetCanClose() (self->canClose)
        GetTextObject() (self->text)
classprocedures:

	InitializeObject(/* struct classhdr *ClassID;*/ struct lookz *self) returns boolean;
	FinalizeObject(/* struct classhdr *ClassID;*/ struct lookz *self);

data:

	boolean visible;		/* if FALSE, only an icon is displayed
						if TRUE, the editor is displayed 
						this field is constrained to be 
						TRUE or FALSE  */

	boolean canClose;
	struct text *text;
};

