/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

#define keyrec_VERSION 1

#include <view.ih>

enum keyrec_EventType {
    keyrec_Keystroke,
    keyrec_Menu,
    keyrec_MouseHit
};

union keyrec_KeyValue {
    enum view_MouseAction action;
    long val;
    char *unknown;
};

struct keyitem {
    struct keyitem *next;
    enum keyrec_EventType type;
    struct view *view;
    union keyrec_KeyValue parm[3];
};

class keyrec {
methods:
    Clear();
    StartRecording() returns boolean;	/* Returns FALSE if already recording */
    StopRecording() returns boolean;	/* Returns FALSE if not recording */
    Recording() returns boolean;	/* Returns TRUE if currently recording */
    Copy() returns struct thisobject *;
    RecordEvent(enum keyrec_EventType type, struct view *view, union keyrec_KeyValue value1, union keyrec_KeyValue value2, union keyrec_KeyValue value3);
    StartPlaying() returns boolean;
    NextKey(enum keyrec_EventType *type, struct view **view, union keyrec_KeyValue *value1, union keyrec_KeyValue *value2, union keyrec_KeyValue *value3) returns boolean;
    StopPlaying();
classprocedures:
    InitializeObject(struct keyrec *self) returns boolean;
    FinalizeObject(struct keyrec *self);
data:
    boolean recording;
    struct keyitem *head;
    struct keyitem *tail;
    boolean playing;
    struct keyitem *current;
};
