/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


 

/* List object
 * for Graph Editor
 */

struct glistelt {
    char * this;
    struct glistelt *next;
};

class glist {

classprocedures:
    Create(procedure Destroy) returns struct glist *;
    FinalizeObject(struct glist *self);
    InitializeObject(struct glist *self) returns boolean;    
    Copy(struct glist *dest, struct glist *source);
methods:
    Insert(char * element) returns boolean;
    Push(char *element) returns boolean;
    Pop() returns char *;
    InsertSorted(char *element, procedure greater) returns boolean;
    Sort(procedure greater) returns boolean;
    InsertUnique(char * element) returns boolean;
    Delete(char * element, boolean destroy) returns boolean;
    Find(procedure filter, char * rock) returns char *; /* filter is called: filter(char * element) */
    Enumerate(void (*proc)(), unsigned long rock);
    Contains(char * element) returns boolean;
    Clear(boolean destroy);
macromethods:
    First() ((self)->head->this)
    Last() ((self)->tail->this)
    Size() ((self)->size)
data:
    struct glistelt *head;
    struct glistelt *tail;
    long size;
    procedure DestroyProc;
};
