/* figogrp.ch - fig element object: group */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $

  $Header: /usr/user/auis-7.2/overhead/c++conv/chfiles/RCS/figogrp.ch,v 1.1 1993/10/13 15:52:18 rr2b Exp $
*/

#include <rect.h>

#define figogrp_Range (2048)

class figogrp : figobj {

    classprocedures:
      InitializeObject(struct figogrp *self) returns boolean;
      FinalizeObject(struct figogrp *self);
      InitializeClass() returns boolean;
      
    overrides:
      WriteBody(FILE *fp);
      ReadBody(FILE *file, boolean recompute) returns long;
      ToolName(struct figtoolview *v, long rock) returns char *;
      Draw(struct figview *v); 
      Sketch(struct figview *v);
      Select(struct figview *v); 
      Build(enum view_MouseAction action, struct figview *v, long x, long y, long clicks) returns enum figobj_Status;
      Reshape(enum view_MouseAction action, struct figview *v, long x, long y, boolean handle, long ptref) returns boolean;
      MoveHandle(x, y, ptref);
      GetHandleType(long num) returns enum figobj_HandleType;
      GetCanonicalHandles() returns long *;
      StabilizeAttachments(boolean keepproport);

      Reposition(long xd, long yd);
      RecomputeBounds();
      GetBounds(struct figview *vv) returns struct rectangle *;
      GetSelectedBounds(struct figview *vv) returns struct rectangle *;
      InheritVAttributes(struct figattr *attr, unsigned long mask);
      UpdateVAttributes(struct figattr *attr, unsigned long mask) returns unsigned long;
      SetParent(long parentref, struct *fig ancestor);

    methods:
      SetConstraintsActive(boolean val);
      Reconfigure();
      
    macromethods:
      GetRoot()       ((self)->root)
      GetRootPtr()  (&((self)->root))
      SetChildBoundMod()  ((self)->bboxdirty = TRUE)

    data:
      long root;
      boolean bboxdirty;
      boolean doconstraints;
      struct rectangle handlebox;
};
