\begindata{text,537982208}
\textdsversion{12}
\template{default}
\define{keyword
}
-- Functions to help scan C code skipping strings, character constants, and 
comments.


-- if the Ness you are running has syntax level 2, the following three 
"forward" declarations should be uncommented. If it's syntax level 1, they 
should be commented out. If this script is failing, try uncommenting or 
commenting them.


--marker function ParseExpression(marker r, boolean commaok, boolean 
newlineok, boolean replaceself) forward

--marker function ParseDeclEnd(marker b) forward

--void function FixCalls(marker b) forward


marker andrewdir:="$ANDREWDIR"

marker identstart:="[a-zA-Z_]"

marker identcont:="[a-zA-Z0-9_]*"

marker notidentcont:="[^a-zA-Z0-9_]"

marker ident:=identstart~identcont

marker convchars:="\\020\\021\\022\\023\\024\\025\\026\\027\\030\\031"

marker spacechars:="\\n\\f 	\\001\\003\\004"~convchars

marker reqspace:="["~spacechars~"]"

marker optspace:=reqspace~"*"

marker reqmspace:=reqspace~optspace

marker currentclass:=""

marker currentsuper:=""

marker currentchfile:=""

marker firstfuncdecl:=""

marker classname:=""

marker prototypes:=""

boolean dothisobject:=false

boolean auxmodule:=false

boolean hadandrewos:=false

marker firstinclude:=""

boolean hadinitializeclass:=false

marker cplusplusmagic:="/* C++ified by magic !@#%&@#$ */"

marker members:=""

marker keepconst:=newbase()

marker keepcomments:=newbase()

boolean fatal:=false


void function FixAndrewOS(marker file)

marker p

marker q

	q:=regsearch(file, "[ 	]*#[ 	]*include")

	p:=regsearch(file, "[ 	]*#[ 	]*include[ 	][ 	]*[\\"<]andrewos.h[\\">]")

	if(q/="" and p/="" and extent(start(q), start(p))/="") then

		replace(p, "")

		replace(first(q), "#include <andrewos.h>\\n"~first(q))

	end if

end function


marker function RawPosition(marker p)

marker file:=copy(extent(start(base(p)), start(p)))

integer line:=1

marker q

	while file/="" do

		q:=anyof(file, "\\n")

		if q/="" then

			line:=line+1

		else

			exit while

		end if

		file:=extent(finish(q), file)

	end while

	return "Line "~textimage(line)~", Column "~textimage(1+length(file))

end function


void function ScanForNonASCII(marker b)

	marker p

	integer badc:=0

	marker k

	while(b/="") do

		p:=regsearch(b, "[^ -~\\n\\t\\f]")

		if p/="" then

			printline("WARNING: Bad character at "~RawPosition(p))

			badc:=badc+1

		else

			if badc>0 then

				printline("Non-ASCII characters encountered, remove or replace with 
octal notation and try again.")

				printline(k)

			end if

			exit function

		end if

		b:=extent(finish(p),b)

	end while

	if badc>0 then

		printline("Non-ASCII characters encountered, remove or replace with octal 
notation and try again.")

		printline(k)

	end if

end function


marker  function ParseBackSlash(marker b)

	marker p

	marker q

	q:=extent(finish(first(b)), b)

	p:=first(q)

	if p>="0" and p<="7" then

		q:=extent(finish(p), b)

		p:=first(q)

		if p>="0" and p<="7" then

			q:=extent(finish(p), b)

			p:=first(q)

			if p>="0" and p<="7" then

				q:=extent(finish(p), b)

			end if

		end if				\


	else \


		q:=extent(finish(p), b)

	end if

	return extent(start(b), start(q))

end function


marker function ParseString(marker b)

	marker q:=first(b);

	while q/="" do

		q:=anyof(extent(finish(q), b), "\\"\\\\")

		if q="" then

			printline("Unterminated string:\\n"~extent(start(b), b)~"\\n")

			return "\\"WARNING:\\\\"~extent(start(b), b)~"\\"\\n"

		elif q="\\"" then

			return extent(start(b), finish(q))

		elif q="\\\\" then

			q:=ParseBackSlash(extent(start(q), b))

		end if

	end while

	return ""

end function


marker function ParseCharacter(marker b)

	marker q

	marker r:=b

	q:=first(extent(finish(first(b)), b))

	if q="\\\\" then

		q:=ParseBackSlash(extent(start(q), b))

	end if

	q:=first(extent(finish(q), b))

	if q/="'" then

		printline("Malformed character constant:\\n"~extent(start(b), 
finish(q))~"\\n")

	end if

	return extent(start(b), finish(q))

end function

	\


marker function SkipNewLinesAndJunk(marker r)

	marker b:=r

	marker p

	while b/="" do

		p:=ParseJunk(b, true, true)

		if p="" then

			if first(b)/="\\n" then

				exit while

			else

				p:=first(b)

			end if

		end if

		b:=extent(finish(p), b)

	end while

	return b

end function


marker function ParseArgumentExpressions(marker r, boolean newlineok, 
boolean replaceself)

	marker b:=r

	marker p

	while b/="" do

		p:=ParseExpression(b, false, newlineok, replaceself)

		p:=ParseJunk(extent(finish(p),b), true, newlineok)

		b:=extent(finish(p), b)

		p:=first(b)

		if  p=")" then

			b:=extent(finish(p), b)

			return extent(start(r), start(b))

		elif p="," then

			b:=extent(finish(p), b)

		else

			printline("Expected ',' or ')' after argument in function call.")

		end if

	end while

	return extent(start(r), start(b))

end function


marker globalreturntype:=""

marker globalexprtype:=""

 \


boolean function IdentifierStartp(marker p)

	return (p>="a" and p<="z") or (p>="A" and p<="Z" or (p="_"))

end function


marker lastid:=""


marker function ParseExpression(marker r, boolean commaok, boolean 
newlineok, boolean replaceself)

	marker b:=r

	marker p

	integer level:=0

	boolean ok:=commaok

	boolean selfpending:=false

	marker returntype:=""

	marker exprtype:="MISSING_RETURN_TYPE"

	while b/="" do

		p:=ParseJunk(b, true, newlineok)

		b:=extent(finish(p), b)

		p:=first(b)

		if IdentifierStartp(p) then

			exprtype:="MISSING_RETURN_TYPE"

			lastid:=ParseID(b)

			if lastid="self" then

				if replaceself then

					replace(lastid, "this")

				end if

				selfpending:=true

			end if

			p:=ParseJunk(extent(finish(lastid), b), true, newlineok)

			b:=extent(finish(p), b)

			if first(b)="(" then

				selfpending:=false

				p:=ParseArgumentExpressions(extent(finish(first(b)), b), newlineok, 
replaceself)

				b:=extent(finish(p), b)

			end if

		elif p>="0" and p<="9" then

			exprtype:="MISSING_RETURN_TYPE"

			b:=extent(finish(p), b)

			selfpending:=false

		elif p="(" then

			selfpending:=false

			b:=extent(finish(p), b)

			level:=level+1

			ok:=true

		elif p=")" and level>0 then

			b:=extent(finish(p), b)

			level:=level-1

			if level=0 then

				ok:=commaok

			end if

		elif p="-" then

			exprtype:="MISSING_RETURN_TYPE"

			b:=extent(finish(p), b)

			p:=first(b)

			if p=">" then

				p:=ParseJunk(extent(finish(p), b), true, newlineok)

				b:=extent(finish(p), b)

				p:=first(b)

				if IdentifierStartp(p) then

					p:=ParseId(b)

					b:=extent(finish(p), b)

				else \


					printline("Expected identifier at :"~b)

				end if

				if selfpending then

					exprtype:="MISSING_RETURN_TYPE_SELF_"~p

				end if

			end if

			selfpending:=false

		elif commaok and p="," then

			selfpending:=false

			b:=extent(finish(p), b)

		elif p="=" then

			selfpending:=false

			b:=extent(finish(p), b)

			p:=first(b)

			if p="=" then

				b:=extent(finish(p), b)

			else

				returntype:="void"

			end if

		elif p="[" then

			selfpending:=false;

			exprtype:="MISSING_RETURN_TYPE"

			b:=extent(finish(p), b)

			p:=ParseExpression(b, true, newlineok, replaceself)

			b:=extent(finish(p), b)

			p:=ParseJunk(b, true, newlineok)

			b:=extent(finish(p), b)

			p:=first(b)

			if p/="]" then

				printline("expected ']' at "~b)

			else \


				b:=extent(finish(p), b)

			end if

		elif p="\\"" then

			p:=ParseString(b)

			b:=extent(finish(p), b)

		elif p="\\002" then

			b:=extent(finish(p), b)

			b:=extent(finish(ParseJunk(b, true, true)), b)

		elif p="'" then

			p:=ParseCharacter(b)

			b:=extent(finish(p), b)

		elif anyof(p, ".*+/^&!~%><:?|")/="" then

			exprtype:="MISSING_RETURN_TYPE"

			selfpending:=false

			b:=extent(finish(p), b)

		else \


			globalreturntype:=returntype

			globalexprtype:=exprtype

			return extent(start(r), start(b))

		end if

	end while

	globalreturntype:=returntype

	globalexprtype:=exprtype

	return extent(start(r), start(b))	\


end function


marker classinfo:=""

marker typeinfo:=""


void function FixFilename(marker f)

	marker p:=search(f, ".")

	marker q

	marker r

	marker s

	marker classkey

	r:=extent(finish(p), f)

	if r/="eh" and r/="ih" then

		exit function

	end if

	p:=extent(start(f), start(p))

	classkey:=p

	q:=search(classinfo, "Declaredin:"~p~".ch")

	if q="" then

			printline("WARNING: Unknown class: "~classkey)

			printline("WARNING: this class cannot be properly converted!")

			fatal:=true

		exit function

	end if

	q:=search(extent(start(q), finish(classinfo)), "Class:")

	if q="" then

			printline("WARNING: Unknown class: "~classkey)

			printline("WARNING: this class cannot be properly converted!")

			fatal:=true

		exit function

	end if

	p:=search(extent(start(q), finish(classinfo)), "\\n")

	if p="" then

			printline("WARNING: Unknown class: "~classkey)

			printline("WARNING: this class cannot be properly converted!")

			fatal:=true

		exit function

	end if

	if r="eh" then

		replace(r, "ch")

		currentchfile:=copy(f)

		currentclass:=extent(finish(q), start(p))

		r:=GetClassInfo(currentclass)

		if r/="" then

			currentsuper:=GetSuperClass(r)

			r:=GetClassProcedures(r)

			if r/="" then

				r:=search(r, "InitializeClass\\n")

				if r/="" then

					hadinitializeclass:=true

				else

					hadinitializeclass:=false

				end if

			end if

		else

			printline("WARNING: Unknown class: "~currentclass)

			printline("WARNING: this class cannot be properly converted!")

			fatal:=true

			currentsuper:="ATK"

			exit function

		end if

	end if

	replace(f, extent(finish(q), start(p))~".H")

end function


marker lastjunkstring:=""

boolean keepifs:=false


marker function ParseDirective(marker b)

	marker p

	marker q:=extent(finish(first(b)), b)

	marker r

	marker f

	marker bodystart:=""

	boolean isdef:=false

	boolean hasself:=false

	r:=ParseId(q)

	if r="include" then

		if firstinclude="" then

			firstinclude:=first(b)

		end if

		q:=extent(finish(r), q)

		lastjunkstring:=""

		r:=ParseJunk(q, false, false)

		q:=extent(finish(r), q)

		r:=first(q)

		if lastjunkstring/="" then

			q:=extent(finish(lastjunkstring), q)

			f:=extent(rest(lastjunkstring), start(last(lastjunkstring)))

			if f="class.h" or f="class_c.h" then

				replace(extent(start(b), finish(lastjunkstring)), "")

				return finish(lastjunkstring)

			elif f="andrewos.h" then

				hadandrewos:=true

			else

				FixFilename(f)

			end if

			lastjunkstring:=""

			return  extent(start(b), start(q))

		elif r="<" then

			q:=extent(finish(r), q)

			p:=search(q, ">")

			f:=extent( finish(r), start(p))

			if f="class.h" or f="class_c.h" then

				replace(extent(start(b), finish(p)), "")

				return finish(p)

			elif f="andrewos.h" then

				hadandrewos:=true

			else

				FixFilename(f)

			end if

			return  extent(start(b), finish(p))

		end if

	elif r="define" then

		isdef:=true

		q:=extent(finish(r), q)

		r:=ParseJunk(q, false, false)

		q:=extent(finish(r), q)

		r:=ParseId(q)

		if r="AUXMODULE" then

			auxmodule:=true

		end if

		q:=extent(finish(r), q)

		r:=first(q)

		if r="(" then

			q:=rest(q)

			while q/="" do

				r:=first(q)

				if r=")" then

					q:=rest(q)

					exit while

				elif r="," then

					q:=rest(q)

				else

					r:=ParseId(q)

					if r/="" then

						if r="self" then

							hasself:=true

						end if

						q:=extent(finish(r), q)

						q:=extent(finish(ParseJunk(q, true, true)), q)

					else

						q:=rest(q)

					end if

				end if

			end while

		end if

	end if

	f:=r

	if isdef then

		bodystart:=start(q)

	end if

	while q/="" do

		r:=ParseJunk(q, true, false)

		q:=extent(finish(r), q)

		p:= first(q)

		if  p="\\n" then

			if isdef then

				if hasself then

					FixIdentifiers(extent(bodystart, finish(p)), "", "")

				else

					FixIdentifiers(extent(bodystart, finish(p)), "", "")

				end if

			end if

			if keepifs and (f="if" or f="ifdef" or f="else" or f="endif" or 
f="ifndef") then

				prototypes:=prototypes~extent(start(b), finish(p))

			end if

			return extent(start(b), start(p))

		else \


			if r="" then

				q:=extent(finish(first(q)), q)

			end if

		end if

	end while

	return b

end function


-- ParseJunk  returns whatever junk is present at

-- the beginning of b. Junk is space,tab, comments, \\c \\nnn, and strings

marker function ParseJunk(marker b, boolean pjunk, boolean njunk)

	marker p

	marker q

	marker r:=b

	marker s

	boolean in

	while b/="" do

		p:=first(b)

		if p="/" then

			q:=first(extent(finish(p), b))

			if q="*" then

				q:=search(extent(finish(q), b), "*/")

				if q="" then

					printline("Unterminated comment:\\n"~extent(start(p), b)~"\\n")

					return r

				end if

				b:=extent(finish(q), b)

			else \


				b:=extent(finish(p), b)

			end if

		elif p="\\001"  then

			p:=search(extent(finish(p), b), "\\004")

			b:=extent(finish(p), b)

		elif p="\\003" then

			b:=extent(finish(p), b)

		elif p="\\n" and njunk then

			b:=extent(finish(p), b)

		elif p="\\"" then

			q:=ParseString(extent(start(p), b))

			lastjunkstring:=q

			b:=extent(finish(q), b)

		elif p="\\002" then

			q:=search(extent(finish(p), b), "\\004")

			q:=extent(start(p), finish(q))

			replace(first(q), "\\001")

			p:=search(keepcomments, q)

			s:=search(extent(finish(p), keepcomments), "\\002")

			replace(q, extent(finish(p), start(s)))

			lastjunkstring:=q

			b:=extent(finish(q), b)

		elif p="\\\\" then \


			q:=ParseBackSlash(extent(start(p), b))

			b:=extent(finish(q), b)

		elif p="'" then

			q:=ParseCharacter(extent(start(p), b))

			b:=extent(finish(q), b)

		elif p="#" and pjunk then

			q:=ParseDirective(extent(start(p), b))

			b:=extent(finish(q), b)

		elif p=" " or p="\\t" then

			q:=span(b, " \\t")

			if q="" then

				b:=extent(finish(p), b)

			else

				b:=extent(finish(q), b)

			end if

		else

			return extent(first(r), start(p))

		end if

	end while

	return b

end function


marker function ParseNewline(marker b)

	marker p:=match(b, "\\n")

	return p

end function



marker 
convlist:="|asm|catch|class|const|delete|friend|inline|new|operator|private|\
protected|public|template|this|throw|try|virtual|"


boolean function Lookup(marker l, marker b)

	return search(l, "|"~b~"|")/=""

end function


function FixReserved(marker b)

	marker p:=search(convlist, "|"~b~"|")

	if p/="" then

		replace(b, b~"_c")

	end if

end function


marker function ParseID(marker b)

	marker p

	marker q:=b

	p:=first(b)

	if  IdentifierStartp(p) then

		while q/="" do

			q:=extent(finish(p), q)	\


			p:=first(q)

			if (p>="a" and p<="z") or (p>="A" and p<="Z") or (p>="0" and p<="9") or 
p="_" then

			else

				q:=extent(b, start(p))

				if dothisobject and currentclass/="" and q="thisobject" then

					replace(q, currentclass)

				end if

				return q

			end if

		end while

	end if

	return start(b)

end function


marker 
storagewords:="|auto|extern|register|static|volatile|typedef|EXTERN|PRIVATE|\
STATIC|GLOBAL|CONST|LOCAL|GVAR|LVAR|METHODDEF|FAR|"


marker modifierwords:="|signed|unsigned|short|long|"

marker modifiedtypes:="|float|double|int|short|long|char|"

marker aggwords:="|struct|enum|union|class|"


marker function ParseOpenBrace(marker b)

	integer level:=0

	marker p

	marker q:=b

	while b/="" do

		p:=anyof(b, "\{\}")

		if p="" then

			exit while

		end if

		b:=extent(finish(p), b)

		if p="\{" then

			level:=level+1

		elif p="\}" then

			level:=level-1

			if level=0 then

				exit while

			end if

		end if

	end while

	return extent(start(q), start(b))

end function


marker declstart:=""

marker declstartm:=""

boolean waitmodified:=false

marker globalbasetype:=""

marker function ParseDeclStart(marker b)

	marker p

	marker q

	marker s:=""

	marker r:=b

	marker agg:=""

	marker storage:=""

	marker basetype:=start(b)

	marker modifier:=""

	b:=extent(finish(ParseJunk(b, true, true)), b)

	waitmodified:=false

	while b/="" do

		if IdentifierStartp(first(b)) then

			p:=ParseId(b)

			if Lookup(storagewords, p) then

				storage:=storage~" "~p

			elif Lookup(modifierwords, p) then

				waitmodified:=true

				basetype:=p

			elif Lookup(aggwords, p) then

				b:=extent(finish(p), b)

				agg:=p

				b:=extent(finish(parseJunk(b, true, true)), b)

				s:=ParseID(b)

				b:=extent(finish(s), b)

				b:=extent(finish(parseJunk(b, true, true)), b)

				basetype:=extent(start(agg), finish(s))

				if first(b)="\{" then

					s:=ParseOpenBrace(b)

					b:=extent(finish(s), b)

					b:=extent(finish(parseJunk(b, true, true)), b)

				end if

				declstartm:=extent(start(r), start(b))

				declstart:=copy(declstartm)

				globalbasetype:=basetype

				return declstartm

			else \


				if waitmodified then

					if not Lookup(modifiedtypes, p) then

						declstartm:=extent(start(r), start(b))

						declstart:=copy(declstartm)

						globalbasetype:=basetype

						return declstartm

					else

						declstartm:=extent(start(r), finish(p))

						declstart:=copy(declstartm)

						globalbasetype:=p

						return declstartm

					end if

				end if

				if basetype/="" then

					declstartm:=extent(start(r), start(b))

					declstart:=copy(declstartm)

					globalbasetype:=basetype

					return declstartm

				else

					basetype:=p

				end if

			end if

			b:=extent(finish(p), b)

		else

			declstartm:=extent(start(r), start(b))

			declstart:=copy(declstartm)

			globalbasetype:=basetype

			return declstartm

		end if

		b:=extent(finish(ParseJunk(b, true, true)), b)

	end while

	declstartm:=start(r)

	declstart:=""

	globalbasetype:=basetype

	return start(r)

end function


marker function GetTypeInfo(marker member)

	marker p

	marker q

	p:=search(typeinfo, "@"~currentclass~"#"~member~"#\\n")

	if p="" then

		return ""

	end if

	q:=search(extent(finish(p), typeinfo), "@")

	if q="" then

		q:=finish(typeinfo)

	end if

	return extent(finish(p), start(q))

end function


marker function GetReturnType(marker ginfo)

	marker p

	p:=search(ginfo, "#")

	return extent(start(ginfo), start(p))

end function


marker function GetArgTypes(marker ginfo)

	marker p

	p:=search(ginfo, "#")

	p:=search(extent(finish(p), ginfo), "#")

	return extent(start(p), ginfo)

end function


boolean function LookForClassInfo(marker class)

-- marker class can be either a class name or a namekey

	marker p

	p:=search(classinfo, "Class:"~class~"\\n")

	if p/="" then

		return true

	end if

	p:=search(classinfo, "Declaredin:"~class~".ch\\n")

	if p/="" then

		return true

	end if

	return false

end function


marker function GetClassInfo(marker class)

	marker p

	marker q

	p:=search(classinfo, "\\nClass:"~class~"\\n")

	if p="" then

		return ""

	end if

	q:=search(extent(start(last(p)), finish(classinfo)), "\\nDeclaredin:")

	if q="" then

		q:=finish(classinfo)

	end if

	return extent(start(last(p)), start(q))~"\\n"

end function


marker function GetSuperClasses(marker cinfo)

	marker p

	marker q

	p:=search(cinfo, "\\nSubclassof:")

	if p="" then

		return ""

	end if

	q:=regsearch(extent(finish(p), finish(cinfo)), "[a-zA-Z]*:")

	if q="" then

		q:=finish(cinfo)

	end if

	return extent(finish(p), start(q))~"\\n"

end function


boolean function IsTraced(marker cinfo)

marker p

	p:=GetSuperClasses(cinfo)

	if p/="" then

		return search(p, "traced\\n")/=""

	else

		return false

	end if

end function


marker function GetSuperClass(marker cinfo)

	marker p:=GetSuperClasses(cinfo)

	marker q:=search(p, "\\n")

	if p/="" and q/="" then

		return extent(start(p), start(q))

	else

		return ""

	end if

end function


marker function GetMethods(marker cinfo)

	marker p

	marker q

	p:=search(cinfo, "\\nMethod:")

	if p="" then

		return ""

	end if

	q:=regsearch(extent(finish(p), finish(cinfo)), "[a-zA-Z]*:")

	if q="" then

		q:=finish(cinfo)

	end if

	return "\\n"~extent(finish(p), start(q))~"\\n"

end function


marker function GetClassProcedures(marker cinfo)

	marker p

	marker q

	p:=search(cinfo, "\\nClassProcedure:")

	if p="" then

		return ""

	end if

	q:=regsearch(extent(finish(p), finish(cinfo)), "[a-zA-Z]*:")

	if q="" then

		q:=finish(cinfo)

	end if

	return "\\n"~extent(finish(p), start(q))~"\\n"

end function


marker function GetMacroMethods(marker cinfo)

	marker p

	marker q

	p:=search(cinfo, "\\nMacroMethod:")

	if p="" then

		return ""

	end if

	q:=regsearch(extent(finish(p), finish(cinfo)), "\\n[a-zA-Z]*:")

	if q="" then

		q:=finish(cinfo)

	end if

	return "\\n"~extent(finish(p), start(q))~"\\n"

end function


marker function GetMacros(marker cinfo)

	marker p

	marker q

	p:=search(cinfo, "\\nMacro:")

	if p="" then

		return ""

	end if

	q:=regsearch(extent(finish(p), finish(cinfo)), "[a-zA-Z]*:")

	if q="" then

		q:=finish(cinfo)

	end if

	return "\\n"~extent(finish(p), start(q))~"\\n"

end function


boolean function IsMethod(marker name)

	marker p

	marker q

	marker r

	marker s

	p:=search(name, "__")

	if p="" then

		return false

	end if

	q:=extent(start(name), start(p))

	r:=GetClassInfo(q)

	if r="" then

		return false

	end if

	s:=GetMethods(r)

	if s="" then

		return false

	end if

	s:=search(s, "\\n"~extent(finish(p), name)~"\\n")

	return s/=""

end function


boolean isCTORorDTOR:=false


boolean function IsClassProcedure(marker name)

	marker p

	marker q

	marker r

	marker s

	p:=search(name, "__")

	if p="" then

		return false

	end if

	q:=extent(start(name), start(p))

	r:=GetClassInfo(q)

	if r="" then

		return false

	end if

	s:=GetClassProcedures(r)

	p:=extent(finish(p), name)

	q:=search(s, "\\n"~p~"\\n")

	isCTORorDTOR:=false

	if q/="" then

		isCTORorDTOR:=(q="\\nInitializeObject\\n" or q="\\nFinalizeObject\\n")

		return true

	else \


		if p="InitializeObject" or p="FinalizeObject" then

			isCTORorDTOR:=(p="InitializeObject" or p="FinalizeObject")

			return true

		else

			return false

		end if

	end if

end function



boolean function IsMacroMethod(marker name)

	marker p

	marker q

	marker r

	marker s

	p:=search(name, "__")

	if p="" then

		return false

	end if

	q:=extent(start(name), start(p))

	r:=GetClassInfo(q)

	if r="" then

		return false

	end if

	s:=GetMacroMethods(r)

	if s="" then

		return false

	end if

	q:=search(s, "\\n"~extent(finish(p), name)~"\\n")

	return q/=""

end function


boolean function IsMacro(marker name)

	marker p

	marker q

	marker r

	marker s

	p:=search(name, "__")

	if p="" then

		return false

	end if

	q:=extent(start(name), start(p))

	r:=GetClassInfo(q)

	if r="" then

		return false

	end if

	s:=GetMacros(r)

	if s="" then

		return false

	end if

	q:=search(s, "\\n"~extent(finish(p), name)~"\\n")

	return q/=""

end function


boolean funcdef:=false


marker selfid:=""

boolean sawtypeinfo:=true


marker function FindLastID(marker b)

marker p

marker s:=start(b)

	while b/="" do

		p:=regsearch(b, ident)

		if p="" then

			exit while

		end if

		s:=p

		b:=extent(finish(p), b)

	end while

	return s

end function


marker function ParseDeclEndRetry(marker st,  marker b)

	marker q

	marker s	\


	marker t

	marker e

	sawtypeinfo:=true

	funcdef:=false

	e:=ParseDeclEnd(b)

	if st/="" and e=""  then

		-- failed to parse it as a decl end, assume the last word

		-- of the decl start was the variable/function name...

		t:=st

		s:=finish(st)

		while t/="" do

			q:=regsearch(t, ident)

			if q="" then

				exit while

			end if

			s:=q

			t:=extent(finish(q), t)

		end while

		st:=extent(start(st), start(s))

		declstart:=copy(st)

		declstartm:=st

		b:=extent(start(s), finish(b))

		if st="" then

			sawtypeinfo:=false

		end if

		funcdef:=false

		e:=ParseDeclEnd(b)

		if e/=""  then

			return e

		else

			return start(b)

		end if

	else

		return e

	end if

end function


marker function ParseDeclEnd(marker b)

	marker r:=b

	marker p:=""

	marker q:=""

	integer level:=0

	integer idlevel:=0

	marker name:=""

	b:=SkipNewLinesAndJunk(b)

	r:=b

	lastid:=""

	while b/="" do

		b:=SkipNewLinesAndJunk(b)

		p:=first(b)

		if IdentifierStartp(p) then

			if name="" then

				idlevel:=level

				name:=ParseID(b)

				b:=extent(finish(name), b)

				b:=SkipNewLinesAndJunk(b)

				if first(b)="(" then

					funcdef:=true

					b:=rest(b)

					b:=SkipNewLinesAndJunk(b)

					if first(b)=")" then

						lastid:=name

						return extent(start(r), finish(first(b)))

					end if

					if IsMethod(name) then

						p:=ParseArgs(b, 1, "")

					elif IsClassProcedure(name) then

						if isCTORorDTOR then

							p:=ParseArgs(b, 2, "")

						else

							p:=ParseArgs(b, 1, "")

						end if

					else

						p:=ParseArgs(b, 0, "")

					end if

					funcdef:=true

					b:=extent(finish(p), b)

					b:=extent(finish(ParseJunk(b, true, true)), b)

					if first(b)=")" then

						b:=rest(b)

						if level=0 then

							return extent(start(r), start(b))

						end if

					end if

				end if

			else

				return start(r)

			end if

		elif p="*" then

			if name/="" then

				exit while

			end if

			b:=extent(finish(p), b)

		elif p="(" then

			if name/="" then

				exit while

			end if

			level:=level+1

			b:=extent(finish(p), b)		\


		elif p=")" then

			if level>0 then

				level:=level-1

				b:=extent(finish(p), b)	\


				if level<1 then

					exit while

				end if

			else

				exit while

			end if

		elif p="[" then

			b:=rest(b)	\


			b:=SkipNewLinesAndJunk(b)

			p:=ParseExpression(b, true, false, false)

			b:=extent(ParseJunk(finish(p), true, true), b)

			p:=first(b)

			if p="]" then

				b:=rest(b)

			else

				printline("WARNING: expected ']' after array size specification.")

				return start(r)

			end if		\


		else

			if level>0 then

				return start(r)

			end if

			exit while

		end if

	end while

	if name="" then

		return start(r)

	end if

	b:=SkipNewLinesAndJunk(b)

	p:=first(b)

	if p="(" then

		level:=0

		while b/="" do

			p:=first(b)

			if p="(" then

				level:=level+1

			elif p=")" then

				level:=level-1

				if level<1 then

					b:=rest(b)

					exit while

				end if

			end if

			b:=rest(b)

			b:=SkipNewLinesAndJunk(b)

		end while

	end if

	lastid:=name

	return extent(start(r), start(b))

end function


void function FixArgName(marker b, marker iname, marker aname)

	marker p

	marker q

	marker s

	marker u:=declstart

	marker v:=declstartm

	p:=ParseDeclStart(b)

	b:=extent(finish(p), b)

	b:=extent(finish(ParseJunk(b, true, true)), b)

	q:=ParseDeclEndRetry(p, b)

	s:=FirstID(q)

	if s/="" then

		replace(s, aname)

	end if

	declstart:=u

	declstartm:=v

end function


marker function ParseArgs(marker b, integer ncuts, marker tinfo)

	marker r:=b

	marker p

	marker q

	marker s

	marker t

	marker argname

	integer cuts:=ncuts

	while r/="" do

		p:=first(r)

		if not(IdentifierStartp(p)) then

			return start(r)

		end if

		s:=declstart

		t:=declstartm

		p:=ParseDeclStart(r)

		r:=extent(finish(p), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		q:=ParseDeclEndRetry(p, r)

		if cuts=1 then

			if q/="" then

				selfid:=copy(regsearch(q, ident))

			else

				selfid:=copy(p)

			end if

		end if

		declstart:=s

		declstartm:=t

		if not(sawtypeinfo) then

			if tinfo/="" then

				while first(tinfo)="\\n" or first(tinfo)="#" do

					tinfo:=rest(tinfo)

				end while

				t:=search(tinfo, "#")

				if extent(start(tinfo), start(t))=FirstID(q) then

					tinfo:=extent(finish(t), tinfo)

					t:=search(tinfo, "#")

					replace(q, extent(start(tinfo), start(t)))

					tinfo:=extent(finish(t), tinfo)

				else

					printline("WARNING: type index information does not match in class 
"~currentclass~".")

					argname:=extent(start(tinfo), start(t))

					printline("index arg:"~extent(start(tinfo), start(t))~"\\theader file 
arg:"~FirstID(q))

					tinfo:=extent(finish(t), tinfo)

					t:=search(tinfo, "#")

					FixArgName(extent(start(tinfo), start(t)), argname, FirstID(q))

					replace(q, "/* MAYBE MISSING */ "~extent(start(tinfo), start(t)))

					tinfo:=extent(finish(t), tinfo)

				end if

			else

				replace(first(p), "MISSING_ARGUMENT_TYPE "~first(p))

			end if

		else

			if tinfo/="" then

				while first(tinfo)="\\n" or first(tinfo)="#" do

					tinfo:=rest(tinfo)

				end while

				t:=search(tinfo, "#")

				tinfo:=extent(finish(t), tinfo)

				t:=search(tinfo, "#")

				tinfo:=extent(finish(t), tinfo)

			end if

		end if

		r:=extent(finish(q), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		if first(r)/="," then

			if cuts>0 then

				replace(extent(start(p), start(r)), "")

				cuts:=cuts-1

			end if

			exit while

		else

			r:=rest(r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

			if cuts>0 then

				replace(extent(start(p), start(r)), "")

				cuts:=cuts-1

			end if

		end if

		r:=extent(finish(ParseJunk(r, true, true)), r)

	end while

	return extent(start(b), finish(q))

end function


marker function ParseBody(marker b)

	marker p

	marker q

	marker r

	marker s

	integer level:=1

	r:=b

	while b/="" do

		p:=anyof(b, "\{\}")

		b:=extent(finish(p), b)

		if p="\{" then

			level:=level+1

		elif p="\}" then

			level:=level-1

			if level=0 then

				return extent(start(r), start(p))

			end if

		else \


			return ""

		end if

	end while

end function


void function FixReservedIdentifiers(marker b)

	marker p

	while b/="" do

		p:=regsearch(b, ident)

		if p="" then

			exit function

		end if

		if Lookup(convlist, p) then

			replace(p, p~"_c")

		end if

		b:=extent(finish(p), b)

	end while

end function


marker function LookForDereference(marker b)

marker p

marker q

marker r

boolean gotgreater:=false

	while true do

		p:=previous(b)

		if p="" then

			exit while

		end if

		if anyof(b, spacechars)="" then

			if p="." then

				return p

			elif p=">" then

				gotgreater:=true

			elif p="-" and gotgreater then

				return p

			elif p="t" then

				return p

			else

				return ""

			end if

		end if

		b:=p

	end while

end function


marker curcinfo:=""


void function FixIdentifiers(marker b, marker selfid, marker args)

	marker p

	marker q

	marker r

	while b/="" do

		p:=regsearch(b, ident)

		if p="" then

			exit function

		end if

		if p="struct" or p="class" then

			b:=extent(finish(p), b)

			p:=regsearch(b, ident)

			if p="" then

				exit function

			end if

		else

			q:=LookForDereference(p)

			if q="" and currentclass/="" then

				if p=selfid then

					replace(p, "this")

				end if

				q:=search(members, "\\n"~p~"\\n")

				if q/="" and search(args, "\\n"~p~"\\n")="" then

					replace(p, "::"~p)

				end if

			end if

		end if

		b:=extent(finish(p), b)

	end while

end function


void function CollectPrototype(marker proto)

	marker p

	marker q

	q:=proto

	while q/="" do

		p:=search(q, "\\n")

		if p="" then

			exit while

		end if

		q:=extent(finish(p), q)

		replace(p, " ")

	end while

	prototypes:=prototypes~proto~";\\n"

end function


marker function FindClassProcedure(marker b, marker type, marker name)

marker p

marker q

marker r:=b

marker s:="__"~name

	while b/="" do

		p:=regsearch(b, type~reqmspace~ident~s~optspace~"(")

		q:=regsearch(p, ident)

		if q=type then

			q:=regsearch(extent(finish(q), p), s~"[^a-zA-Z0-9_]")

			q:=extent(start(q), start(last(q)))

			if q=s then

				return p

			end if

		end if

		b:=extent(finish(p), b)

	end while

	return start(r)

end function

		\


marker function FindArgument(marker b, marker arg)

marker p

marker q

marker r:=b

	while b/="" do

		p:=regsearch(b, "MISSING_ARGUMENT_TYPE" ~ reqspace ~ arg ~ notidentcont)

		p:=extent(start(p), start(last(p)))

		q:=regsearch(p, ident)

		if q="MISSING_ARGUMENT_TYPE" then

			q:=regsearch(extent(finish(q), p), ident)

			if q=arg then

				return p

			end if

		end if

		b:=extent(finish(p), b)

	end while

	return start(r)

end function


boolean doingbackup:=false

boolean sawdeclterm:=false

marker lastdecl:=""

marker lastfuncdecl:=""

marker starttemp:=""

boolean forceinitializeclass:=false


void function RemoveStatic(marker b)

	marker p

	while b/="" do

		p:=regsearch(b, ident)

		if p="static" then

			replace(p, "")

			exit function

		end if

		b:=extent(finish(p), b)		\


	end while

end function


marker argnames:=""


marker funcbasetype:=""


void function Prototype(marker b)

	marker p

	marker q

	marker r

	marker s

	marker t

	marker lastcomma:=""

	boolean doingfuncargs:=false

	boolean goon:=false

	boolean allcut:=false

	curcinfo:=""

	lastdecl:=start(b)

	sawdeclterm:=true

	while b/="" do \


		\


		if fatal then

			exit function

		end if

		p:=ParseJunk(b,  true, true)

		b:=extent(finish(p), b)

		p:=first(b)

		funcdef:=false

		goon:=false

		if IdentifierStartp(p) then

			if  (not doingbackup) and (not sawdeclterm) and not(doingfuncargs) then

				doingbackup:=true

				r:=extent(start(lastdecl), start(p))

				if r/="" then

					p:=ParseDeclStart(r)

					if p="" then

						printline("WARNING: couldn't parse start decl from: "~r)

					end if

					q:=FindLastId(p)

					p:=extent(start(p), start(q))

					declstart:=copy(p)

					declstartm:=p

					starttemp:=declstartm

					b:=extent(start(q), b)

					p:=first(p)

				end if

			else

				doingbackup:=false

				p:=ParseDeclStart(b)

				starttemp:=p

				b:=extent(finish(p), b)

				b:=extent(finish(ParseJunk(b, true, true)), b)

			end if

			sawdeclterm:=false

			lastdecl:=first(p)

			allcut:=true

			lastcomma:=start(b)

			while b/="" do

				q:=ParseDeclEndRetry(starttemp, b)

				if q="" then

					printline("WARNING: bad decl end... restarting at next semicolon (or 
function body) after:"~p)

					q:=anyof(b, ";\{")

					if q=";" then

						b:=extent(finish(q), b)

					elif q="\{" then

						q:=ParseOpenBrace(extent(start(q), b))

						b:=extent(finish(q), b)

					else

						b:=rest(b)

					end if

					b:=extent(finish(ParseJunk(b, false, true)), b)

					exit while

				end if

				b:=extent(finish(q), b)

				b:=extent(finish(ParseJunk(b, false, true)), b)

				while b/="" and first(b)="#" do

					sawdeclterm:=true

					t:=ParseId(extent(rest(b), b))

					if t="else" then

						funcdef:=false

					end if

					t:=ParseDirective(b)

					b:=extent(finish(t), b)

					b:=extent(finish(ParseJunk(b, false, true)), b)	\


				end while

				if not doingfuncargs and funcdef then

					lastfuncdecl:=extent(start(p), finish(q))

					if firstfuncdecl="" then

						firstfuncdecl:=lastfuncdecl

					end if

				end if

				if first(b)="=" then

					sawdeclterm:=true

					b:=rest(b)

					b:=extent(finish(ParseJunk(b, true, true)), b)	\


					if first(b)/="\{" then

						s:=ParseExpression(b, true, true, false)

					else

						s:=ParseOpenBrace(b)

					end if

					b:=extent(finish(s), b)

					b:=extent(finish(ParseJunk(b, true, true)), b)

				end if

				t:=first(b)

				if t=";" or t="," then

					sawdeclterm:=true

					if t=";" then

						goon:=false

					else

						goon:=true

					end if

					b:=rest(b)

					if doingfuncargs then

						r:=regsearch(q, ident)

						argnames:=argnames~r~"\\n"

						r:=FindArgument(lastfuncdecl, r)

						s:=ParseJunk(b, false, false)

						b:=extent(finish(s), b)

						if r/="" then

							replace(r, declstart~" "~q~s)

						end if

						if first(b)="\\n" then

							s:=extent(start(s), finish(first(b)))

						end if

						replace(extent(start(p), finish(s)), "")

						allcut:=false

					else

						if funcdef then

							if t="," or allcut then

								replace(extent(start(q), finish(t)), "")

							else \


								replace(extent(start(q), start(t)), "")

							end if

							replace(lastcomma, "")

						else

							allcut:=false

						end if

					end if

					if goon then

						lastcomma:=t

					end if

					funcdef:=false

				else

					allcut:=false

					goon:=false

					if funcdef and lastfuncdecl/="" and not(doingfuncargs) then

						printline("processing function: "~regsearch(q, ident))

						ParseDeclStart(declstart)

						if globalbasetype="" then

printline("WARNING: assuming void return type for typeless function.")

							t:=first(q)

							replace(t, "void "~first(q))

						end if

						 doingfuncargs:=true

						argnames:="\\n"

					end if

				end if

				if not(goon) and first(b)/="," then

					exit while

				end if

				starttemp:=finish(b)

			end while

			if allcut then

				replace(declstartm, "")

			end if

		elif p="\{" then

			sawdeclterm:=true

			doingfuncargs:=false

			b:=rest(b)

			p:=ParseBody(b)

			q:=regsearch(lastfuncdecl, ident~"__"~identcont)

			if q/="" and IsMethod(q) then

				RemoveStatic(extent(start(lastfuncdecl), start(q)))

				FixIdentifiers(p, selfid, argnames)

			elif (q/="" and IsClassProcedure(q)) then

				RemoveStatic(extent(start(lastfuncdecl), start(q)))

				if hadinitializeclass and q/=currentclass~"__InitializeClass" then

					replace(start(p), "\\n\\tATKinit;\\n")

				end if

				if isCTORorDTOR then

					FixIdentifiers(p, selfid, argnames)

				else

					FixIdentifiers(p, "", argnames)

				end if

			else

				if lastfuncdecl/="" then

					CollectPrototype(copy(lastfuncdecl))

				end if

				FixIdentifiers(p, "", argnames)

			end if

			lastfuncdecl:=""

			b:=extent(finish(p), b)

		else

			b:=rest(b)

		end if

	end while

end function


marker therest:=""

marker type:=""

marker comment:=""

marker string:=""

marker character:=""


marker function NextChunk()

	marker b:=therest

	marker p

	marker q

	marker r

	q:=therest

	while q/="" do

		p:=anyof(q, "/'\\"")

		q:=extent(finish(p), finish(therest))

		if p="/" and first(q)="*" then

			q:=extent(finish(first(q)), finish(therest))

			while q/="" do

				r:=search(q, "*")

				q:=extent(finish(r), finish(therest))

				if r="*" and first(q)="/" then

					r:=first(q)

					therest:=extent(finish(r), finish(therest))

					exit while

				end if

			end while

			comment:=extent(start(p), finish(r))

			type:="<comment>"	\


			return extent(start(b), start(p));

		elif p="'" then

			q:=extent(start(p), finish(therest))

			p:=ParseCharacter(q)

			therest:=extent(finish(p), finish(therest))

			character:=p

			type:="<character constant>"

			return extent(start(b), start(p))

		elif p="\\"" then

			q:=extent(start(p), finish(therest))

			p:=ParseString(q)

			string:=p

			therest:=extent(finish(p), finish(therest))

			type:="<string>"

			return extent(start(b), start(p))

		end if

	end while

	type:=""

	therest:=finish(therest)

	return extent(start(b), finish(therest))

end function


void function FixCTORBody(marker b)

	marker p:=search(b, "\{")

	marker q

	marker r

	marker s

	integer level:=1

	if p="" then

		exit function

	end if

	b:=extent(finish(p), finish(b))

	r:=b

	while b/="" do

		p:=anyof(b, "\{\}")

		if p="\}" then

			level:=level-1

			if level=0 then

				exit while

			end if

		elif p="\{" then

			level:=level+1

		end if

		b:=extent(finish(p), finish(b))

	end while

	q:=extent(start(r), start(p))

   	 r:=q

	while q/="" do

		p:=regsearch(q, notidentcont~"return[^a-zA-Z0-9_][^;]*;")

		if p="" then

			exit while

		end if

		p:=extent(finish(first(p)), p) \


		s:=regsearch(p, "[^a-zA-Z0-9_]")

		if extent(start(p), start(s))="return" then

			replace(extent(start(p), start(s)), "THROWONFAILURE")

			s:=extent(start(s), start(last(p)))

			replace(s, "("~s~")");

		end if

		q:=extent(finish(p), finish(q))

	end while	\


	\


end function


boolean forcector:=false

boolean forcedtor:=false


void function FixCTOR(marker b)

	marker p

	marker q

	marker r

	marker cinfo

	marker type

	forcector:=false

	while b/="" do

		p:=FindClassProcedure(b, "boolean", "InitializeObject")

		if p/="" then

--			forcector:=true

			q:=regsearch(p, reqmspace)

			type:=extent(start(p), finish(q))

			replace(type, "")

			b:=extent(finish(p), finish(b))

		else

			exit while

		end if

	end while

end function


void function FixDTOR(marker b)

	marker p

	marker q

	marker r

	marker cinfo

	marker type

	forcedtor:=false

	while b/="" do

		p:=FindClassProcedure(b, "void", "FinalizeObject")

		if p/="" then

--			forcedtor:=true

			q:=regsearch(p, reqmspace)

			type:=extent(start(p), finish(q))

			replace(type, "")

			b:=extent(finish(p), finish(b))

		else

			exit while

		end if

	end while

end function


void function FixMethodsAndProcs(marker b)

	marker p

	marker q

	marker r

	marker cinfo

	marker methods

	marker classprocedures

	marker classname

	while b/="" do

		p:=regsearch(b, ident~"__"~identcont)

		if p="" then

			exit while

		end if

		q:=search(p, "__")

		r:=extent(start(p), start(q))

		cinfo:=GetClassInfo(r)

		classname:=r

		if cinfo/="" then

			r:="\\n"~extent(finish(q), finish(p))~"\\n"

			methods:=GetMethods(cinfo)

			classprocedures:=GetClassProcedures(cinfo)

			if (methods/="" and search(methods, r)/="")  then

				r:=extent(finish(q), finish(p))

				replace(q, "::")

			elif r="\\nInitializeObject\\n" or r="\\nFinalizeObject\\n" or 
(classprocedures/="" and search(classprocedures, r)/="") then

				r:=extent(finish(q), finish(p))

				replace(q, "::")

				if r="InitializeObject" then

					FixCTORBody(extent(finish(p), finish(b)));

					replace(r, classname)

				elif r="FinalizeObject" then

					replace(r, "~"~classname)

				end if

			end if			\


		end if

		b:=extent(finish(p), finish(b))

	end while

end function



marker function FindStruct(marker b, marker name)

marker p

marker q

marker r:=b

	while b/="" do

		p:=regsearch(b, "struct"~reqmspace~name~notidentcont)

		p:=extent(start(p), start(last(p)))

		q:=regsearch(p, ident)

		if q="struct" then

			q:=regsearch(extent(finish(q), p), ident)

			if q=name then

				return p

			end if

		end if

		b:=extent(finish(p), b)

	end while

	return start(r)

end function


void function FixClassStructs(marker b)

	marker p

	marker q

	marker r

	marker s:=b

	while b/="" do

		p:=FindStruct(b, "basicobject")

		if p/="" then

			q:=regsearch(p, reqmspace)

			replace(p, "ATK"~q)

			b:=extent(finish(p), b)

		else

			exit while

		end if		\


	end while

	b:=s

	while b/="" do

		p:=FindStruct(b, "classinfo")

		if p/="" then

			q:=regsearch(p, reqmspace)

			replace(p, "struct"~q~"ATKregistryEntry ")

			b:=extent(finish(p), b)

		else

			exit while

		end if		\


	end while

	b:=s

	while b/="" do

		p:=regsearch(b, ident~"_classinfo"~notidentcont)

		if p/="" then

			p:=extent(start(p), start(last(p)))

			b:=extent(start(p), b)

			r:=ParseId(b)

			b:=extent(finish(r), b)

			q:=search(r, "_classinfo")

			if extent(finish(q), r)="" then

				r:=extent(start(p), start(q))

				q:=GetClassInfo(r)

				if q/="" then

					replace(p, r~"_ATKregistry_ ")

				end if

			end if

			b:=extent(finish(p), b)

		else

			exit while

		end if		\


	end while

	b:=s

	while b/="" do

		p:=regsearch(b, "struct"~reqmspace~ident)

		if p/="" then

			b:=extent(start(p), b)

			r:=ParseId(b)

			if r="struct" then

				q:=regsearch(p, reqmspace)

				p:=extent(finish(q), p)

				q:=GetClassInfo(p)

				if q/="" then

					replace(r, "class")

				end if

			end if

		else

			exit while

		end if

		b:=extent(finish(p), b)	\


	end while

end function


boolean issuper:=false

boolean isclass:=false


void function FixCalls(marker b)

	marker p

	marker q

	marker r

	marker s

	marker cinfo

	marker methods

	marker macromethods

	marker classprocedures

	marker macros

	while b/="" do

		issuper:=false

		isclass:=false

		p:=regsearch(b, ident~"_"~identcont~optspace~"(")

		if p="" then

			exit while

		end if

		b:=extent(finish(p), b)

		b:=extent(finish(ParseJunk(b, true, true)), b)

		s:=regsearch(p, optspace~"(")

		p:=extent(start(p), start(s))

		q:=search(p, "_")

		s:=extent(start(p), start(q))

		if s="super" then

			issuper:=true

			cinfo:=GetClassInfo(currentclass)

		elif s="class" then

			isclass:=true

			replace(s, "ATK")

			cinfo:="\\nMethod:IsType\\nGetType\\nGetTypeName\\nGetSuperType\\nGetSupe\
rTypeName\\nClassProcedure:IsTypeByName\\nLoad\\nLoadByKey\\nIsLoaded\\nNewO\
bject\\n"

		else

			cinfo:=GetClassInfo(s)

		end if

		if cinfo/="" then

			r:="\\n"~extent(finish(q), finish(p))~"\\n"

			if r="\\nNew\\n" then

				if first(b)=")" then

					b:=rest(b)

					p:=extent(start(p), start(b))

					replace(p, "new class "~s)

				else

					printline("expected close paren after:"~p)

				end if

			elif r="\\nDestroy\\n" then

				s:=ParseExpression(b, false, true, false)

				b:=extent(finish(s), b)

				b:=extent(finish(ParseJunk(b, true, true)), b)

				r:=first(b)

				if r=")" then

						b:=rest(b)

					if IsTraced(cinfo) then

						replace(extent(first(p), finish(r)), "("~s~")->Destroy()")

					else

						replace(extent(first(p), finish(r)), "delete "~s)

					end if

				end if

			else

			methods:=GetMethods(cinfo)

			macromethods:=GetMacroMethods(cinfo)

			classprocedures:=GetClassProcedures(cinfo)

			macros:=GetMacros(cinfo)

			if (methods/="" and search(methods, r)/="")  or (macromethods/="" and 
search(macromethods, r)/="") then

				if isclass then

					r:=extent(finish(q), finish(p));

					if r="GetType" then

						replace(r, "ATKregistry")

					end if

				end if

				b:=extent(finish(ParseJunk(b, true, true)), b)

				s:=ParseExpression(b, false, true, false)

				b:=extent(finish(s), b)

				b:=extent(finish(ParseJunk(b, true, true)), b)

				if issuper then

					FixCalls(s)

					replace(extent(start(p), finish(q)), "("~s~")->"~currentsuper~"::")

				else

					FixCalls(s)

					replace(extent(start(p), finish(q)), "("~s~")->")

				end if

				if first(b)="," then

					b:=rest(b)

					replace(extent(start(s), start(b)), "")

				else

					replace(extent(start(s), start(b)), "")

				end if			\


			elif (classprocedures/="" and search(classprocedures, r)/="") or 
(macros/="" and search(macros, r)/="") then

				if isclass then

					r:=extent(finish(q), finish(p));

					if r="Load" or r="LoadByKey" then

						replace(r, "LoadClass")

					end if

				end if

				replace(q, "::")

			end if

			end if			\


		end if

	end while

end function


void function FixHeaderReferences(marker b)

	marker p

	marker q

	marker r

	marker s

	marker cinfo

	marker methods

	marker macromethods

	marker classprocedures

	while b/="" do

		p:=regsearch(b, 
"header"~optspace~"\\\\."~optspace~ident~optspace~"\\\\."~optspace~ident~not\
identcont)

		if p="" then

			exit while

		end if

		b:=extent(finish(p), b)

		p:=extent(start(p), start(last(p)))

		q:=regsearch(p, ident)

		if q="header" then \


			q:=search(p, ".")

			r:=search(extent(finish(q), p), ".")

			s:=extent(finish(q), start(r))

			s:=regsearch(s, ident)

			cinfo:=GetClassInfo(s)

			if cinfo/="" then

				replace(extent(start(p), finish(r)), s~"::")

			end if

		end if

	end while

end function



void function ReplaceStuff(marker file)

	marker p

	marker q

	marker r

	while file/="" do

		p:=anyof(file, "\\001\\003\\002")

		if p="\\001" then

			q:=search(extent(finish(p), file), "\\004")

			p:=extent(start(p), finish(q))

			q:=search(keepcomments, p)

			r:=search(extent(finish(q), keepcomments), "\\002")

			q:=extent(finish(q), start(r))

			replace(p, q)

		elif p="\\002" then

			q:=search(extent(finish(p), file), "\\004")

			p:=extent(start(p), finish(q))

			replace(first(p), "\\001")

			q:=search(keepcomments, p)

			r:=search(extent(finish(q), keepcomments), "\\002")

			q:=extent(finish(q), start(r))

			replace(p, q)

		elif p="\\003" then

			replace(p, "")

		else

			exit while

		end if

		file:=extent(finish(p), finish(file))

	end while

end function


integer ccount:=0

marker function GenCountString()

	marker r:=newbase()

	integer k:=ccount

	integer d

	while k/=0 do

		d:=k-(k/10)*10

		r~:=nextn(start(convchars), d+1)

		k:=k/10

	end while

	ccount:=ccount+1

	return r

end function


void function RemoveStuff(marker file)

	marker p

	marker id

	therest:=file

	while therest/="" do

		p:=NextChunk()

		id:=GenCountString()

		if type="<string>" then

			keepcomments~:="\\n\\001"~id~"\\004"~string~"\\002"

			replace(string, "\\002"~id~"\\004")

		elif type="<character constant>" then

			keepcomments~:="\\n\\001"~id~"\\004"~character~"\\002"

			replace(character, "\\002"~id~"\\004")

		elif type="<comment>" then

			keepcomments~:="\\n\\001"~id~"\\004"~comment~"\\002"

			replace(comment, "\\001"~id~"\\004")

		end if

	end while

end function


void function FlagAssignmentsToThis(marker file)

marker r

	while file/="" do

		r:=regsearch(file, "this"~optspace~"="~optspace~"[^=]")

		if r="" then

			exit while

		end if

		file:=extent(finish(r), file)

		replace(r, "ASSIGNMENT_TO_THIS_ERROR:::"~r)

	end while

end function


void function FixDSattributes(marker q)

	marker r

	while q/="" do

		r:=regsearch(q, "[^a-z0-9_]enum"~optspace~"view_DSattributes[^a-z0-9_]")

		if r="" then

			exit while

		end if

		q:=extent(finish(r), q)

		r:=extent(finish(first(r)), start(last(r)))

		replace(r, "view_DSattributes")

	end while

end function


marker sourcecomments:=""

marker sourceconstants:=""

marker initfunc:=""

marker regdest:=""


void function ProcessSourceFile(marker filename, marker file)

	marker p

	marker q

	marker f

	marker r

	marker whole

	firstinclude:=""

	hadinitializeclass:=false

	hadandrewos:=false

	printline("Checking for header file to convert.")

	p:=search(file, "AUXMODULE")

	if p="" then

		p:=regsearch(file, "#include"~optspace~"<[a-zA-Z0-9_]*\\\\.eh>")

		if p="" then

			p:=regsearch(file, "#include"~optspace~"\\"[a-zA-Z0-9_]*\\\\.eh\\"")

		end if

		if p/="" then

			f:=FirstID(p)

			p:=FirstID(extent(finish(f), p))

			f:=copy(filename)

			q:=regsearch(f, "[^./]*\\\\.c")

			if extent(finish(q), f)="" then

				replace(q, p~".ch")

				printline("\\n*** "~f~" ***")

				whole:=copy(readfile(f))

				if isreadonly(whole) then

					printline("!!! READONLY !!!")

				else

					forceinitializeclass:=false

					forcector:=false

					forcedtor:=false

					q:=FindClassProcedure(file, "boolean", "InitializeClass")

					if q/="" then

						forceinitializeclass:=true

						printline("Source has InitializeClass")

					end if

					q:=FindClassProcedure(file, "boolean", "InitializeObject")

					if q/="" then

						forcector:=true

						printline("Source has InitializeObject")

					end if

					q:=FindClassProcedure(file, "void", "FinalizeObject")

					if q/="" then

						forcedtor:=true

						printline("Source has FinalizeObject")

					end if

					sourcecomments:=keepcomments

					sourceconstants:=keepconst

					ProcessCHFile(f, whole)

					keepcomments:=sourcecomments

					keepconst:=sourceconstants

				end if

			end if

		end if

	end if

	fatal:=false

	firstinclude:=""

	printline("\\n--- "~filename~" ---")

	printline("Collapsing comments, strings and character constants.")

	keepifs:=false

	RemoveStuff(file)

	printline("Checking \{\}[]() balancing")

	Balance(file)

	printline("Renaming C++ reserved words.")

	FixReservedIdentifiers(file)

	printline("Moving #include <andrewos.h> to the front.")

	FixAndrewOS(file)

	initfunc:=FindClassProcedure(file, "boolean", "InitializeClass")

	if initfunc/="" then

		initfunc:=regsearch(initfunc, ident~"__InitializeClass")

	end if

	printline("Fixing class structs.")

	FixClassStructs(file)

	printline("Prototyping.")

	keepifs:=true

	Prototype(file)

		if fatal then

			printline("WARNING: Fatal error recognized. skipping "~filename)

			exit function

		end if

	keepifs:=false

	if currentclass/="" then

		printline("Converting InitializeObject.")

		FixCTOR(file)

		printline("Converting FinalizeObject.")

		FixDTOR(file)

		printline("Fixing methods and classprocedures.")

		FixMethodsAndProcs(file)

		if not(auxmodule) then

			if currentclass/="" then

				printline("Adding ATKdefineRegistry macro.")

				if currentsuper="" then

					currentsuper:="ATK"

				end if

				regdest:=firstfuncdecl

				if regdest="" then

					file~:="\\n"

					regdest:=last(file)

				end if

				if initfunc/="" then

					replace(start(regdest),"\\nATKdefineRegistry("~currentclass~", 
"~currentsuper~", "~initfunc~");\\n")

				else

					replace(start(regdest),"\\nATKdefineRegistry("~currentclass~", 
"~currentsuper~", NULL);\\n")

				end if

			end if

		end if

	end if

	printline("Fixing method and classprocedure calls.")

	FixCalls(file)

	printline("Fixing foo->header.classname.eek references.")

	FixHeaderReferences(file)

	if firstfuncdecl/="" then

		printline("Adding forward declaration prototypes.")

		replace(start(firstfuncdecl), prototypes~"\\n\\n")

	end if

	printline("Flagging assignments to 'this'.")

	FlagAssignmentsToThis(file)

	printline("Fixing view_DSattributes.")

	FixDSattributes(file)

	printline("Re-expanding comments, strings and character constants.")

	ReplaceStuff(file)

end function


boolean isvoid:=False


marker specialprocs:="|InitializeObject|FinalizeObject|InitializeClass|"


marker returntypemarker:=""


marker macrotypes:=""


marker function FirstId(marker a)

marker p

marker b

	while a/="" do

		p:=first(a)	\


		if IdentifierStartp(p) then

			b:=start(a)

			while a/="" and ((p>="a"and p<="z") or (p>="A" and p<="Z") or (p>="0" 
and p<="9") or (p="_")) do

				a:=rest(a)

				p:=first(a)

			end while

			return extent(b, start(p))

		end if

		a:=rest(a)

	end while

	return ""

end function


void function CollectMacroTypes(marker proc, marker rettype, marker args)

	marker p

	marker q

	marker r

	macrotypes:=macrotypes~"@"~currentclass~"#"~proc~"#\\n"~rettype~"#\\n"

	printline("#"~currentclass~"#"~proc~"\\n&"~rettype~"&\\n")

	printline("args:"~args)

	r:=args

	while r/="" do

		p:=ParseDeclStart(r)

		r:=extent(finish(p), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		q:=ParseDeclEndRetry(p, r)

		r:=extent(finish(q), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		macrotypes:=macrotypes~"#"~FirstId(q)~"#"~extent(start(p), 
finish(q))~"#\\n"

		printline("name:"~FirstId(q))

		printline("full:"~extent(start(p), finish(q)))

		if first(r)/="," then

			exit while

		end if

		r:=rest(r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

	end while

end function


marker ginfo:=""

boolean sawinitializeclassproc:=false

boolean sawinitializeobject:=false

boolean sawfinalizeobject:=false


marker function DoFuncs(marker b, marker prefix, boolean macro)

	marker p

	marker q

	marker r:=b

	marker proc

	boolean special

	marker args

	p:=first(r)

	proc:=ParseID(r)

	if macro then

		ginfo:=GetTypeInfo(proc)

	else

		ginfo:=""

	end if

printline("proc: "~proc)

	if Lookup(specialprocs, proc) then

		special:=true

	else

		special:=false

	end if

	r:=extent(finish(proc), r)

	r:=extent(finish(ParseJunk(r, true, true)), r)

	p:=first(r)

	if p=":" then

		return start(b)

	elif p="(" then

		members:=members~proc~"\\n"

		r:=extent(finish(p), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		args:=ParseArgs(r, 0, GetArgTypes(ginfo))

		r:=extent(finish(args), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		if first(r)/=")" then

			printline("WARNING: expected close paren after "~proc~".\\n")

			replace(start(args), "SYNTAX_ERROR")

			while first(r)/=";"and first(r)/="\\n" do

				r:=rest(r)

			end while

			return extent(start(b), start(rest(r)))

		end if

		r:=extent(finish(first(r)), r)

		r:=SkipNewLinesAndJunk(r)

		p:=first(r)

		if IdentifierStartp(p) then

			isvoid:=False

			p:=ParseID(r)

			if p="returns" then

				r:=extent(finish(p), r)

				r:=extent(finish(ParseJunk(r, true, true)), r)

				if not(special) then

					replace(p, "")

				end if

				p:=ParseDeclStart(r)

				r:=extent(finish(p), r)

				r:=extent(finish(ParseJunk(r, true, true)), r)

				q:=anyof(r, ";=")

				p:=extent(start(p), start(q))

				if not(special) then

					replace(proc, prefix~" "~p~" "~proc)

					replace(p, "")

				end if

			else

				if macro then

					replace(start(proc), prefix~" ")

					returntypemarker:=start(proc)

				else

					printline("Syntax error at: "~r)

				end if

			end if

		elif p=";" then

			isvoid:=true

			if not(special) then

				replace(start(proc), prefix~" void ")

			end if

		else

			if macro then

				replace(start(proc), prefix~" ")

				returntypemarker:=start(proc)

			else

				printline("Syntax error at: "~r)

			end if

		end if

	else

		printline("WARNING: expected paren after "~proc~".\\n")

		return b

	end if

	if special then

		p:=start(b)

		q:=first(r)

		if proc="InitializeObject" then

			replace(extent(finish(p), start(q)), "")

			sawinitializeobject:=true

			replace(q, "\\n\\t"~currentclass~"();")

		elif proc = "FinalizeObject" then

			replace(extent(finish(p), start(q)), "")

			sawfinalizeobject:=true

			replace(q, "\\n\\tvirtual ~"~currentclass~"();")

		elif proc = "InitializeClass" then

			sawinitializeclassproc:=true

			replace(extent(finish(p), start(q)), "")

			replace(q, "\\n\\tstatic boolean InitializeClass();\\n")

		end if

		return extent(start(p), finish(q))

	end if

	return extent(start(b), start(r))

end function


marker function ParseMethods(marker b, boolean overrides)

	marker p

	marker q

	marker r:=b

	marker proc

	while r/="" do

		p:=first(r)

		if IdentifierStartp(p) then

			if not(overrides) then

				p:=DoFuncs(r, "virtual", false)

			else

				p:=DoFuncs(r, "", false)

			end if

			if p="" then

				exit while

			end if

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		else

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		end if	\


	end while

	return extent(start(b), start(r))

end function


marker function ParseMacroMethods(marker b)

	marker p

	marker q

	marker r:=b

	marker s

	marker t

	marker proc

	while r/="" do

		p:=first(r)

		if IdentifierStartp(p) then

			proc:=ParseId(r)

			p:=DoFuncs(r, "inline", true)

			if p="" then

				exit while

			end if

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, false)), r)

			s:=start(first(r))

			p:=ParseExpression(r, true, false, true)

			ginfo:=GetTypeInfo(proc)

			t:=GetReturnType(ginfo)

			if ginfo/="" and t/="" then

				replace(returntypemarker, t~" ")

				t:=search(t, "void")

				if t="void" then

					replace(s, "\{ ")

				else

					replace(s, "\{ return ")

				end if

			else \


				if globalreturntype="void" then

					replace(s, "\{ ")

					replace(returntypemarker, "void ")

				else \


					replace(s, "\{ return ")

					replace(returntypemarker, globalexprtype~" ")

				end if

			end if

			r:=extent(finish(p), r)

			while first(r)=";" do

				r:=rest(r)

				p:=ParseExpression(r, true, false, true)

				r:=extent(finish(p), r)

			end while

			p:=start(r)

			replace(p, "; \}")

			FixIdentifiers(extent(start(s), start(p)), "self", "")

			r:=extent(finish(ParseJunk(extent(finish(p), r), true, true)), r)

		else

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		end if	\


	end while

	return extent(start(b), start(r))

end function



marker function ParseClassProcedures(marker b)

	marker p

	marker q

	marker r:=b

	marker proc

	while r/="" do

		p:=first(r)

		if IdentifierStartp(p) then

			p:=DoFuncs(r, "static", false)

			if p="" then

				exit while

			end if

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		else

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		end if	\


	end while

	if forceinitializeclass and not(sawinitializeclassproc) then

		forceinitializeclass:=false

		replace(first(b), "\\tstatic boolean InitializeClass();\\n"~first(b))

	end if

	if forcector and not(sawinitializeobject) then

		forcector:=false

		replace(first(b), currentclass~"();\\n\\t"~first(b))

	end if

	if forcedtor and not(sawfinalizeobject) then

		forcedtor:=false

		replace(first(b), "~"~currentclass~"();\\n\\t"~first(b))

	end if

	return extent(start(b), start(r))

end function


marker function ParseMacros(marker b)

	marker p

	marker q

	marker r:=b

	marker proc

	marker t

	while r/="" do

		p:=first(r)

		if IdentifierStartp(p) then

			proc:=ParseID(r)

			p:=DoFuncs(r, "static inline", true)

			if p="" then

				exit while

			end if

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, false)), r)

			q:=start(first(r))

			p:=ParseExpression(r, true, false, false)

			ginfo:=GetTypeInfo(proc)

			t:=GetReturnType(ginfo)

			if ginfo/="" and t/="" then

				replace(returntypemarker, t~" ")

				t:=search(t, "void")

				if t="void" then

					replace(q, "\{ ")

				else

					replace(p, "\{ return ")

				end if

			else \


				if globalreturntype="void" then

					replace(returntypemarker, "void ")

					replace(q, "\{ ")

				else

					replace(returntypemarker, globalexprtype~" ")

					replace(q, "\{ return ")

				end if

			end if

			r:=extent(finish(p), r)

			while first(r)=";" do

				r:=rest(r)

				p:=ParseExpression(r, true, false, true)

				r:=extent(finish(p), r)

			end while

			p:=start(r)

			replace(p, "; \}")

			r:=extent(finish(ParseJunk(extent(finish(p), r), true, true)), r)

		else

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		end if	\


	end while

	return extent(start(b), start(r))

end function


marker wholefile:=""

marker function ParseData(marker b)

	marker r:=b

	marker p

	marker q

	marker s

	marker t

	marker u

	while r/="" do

		p:=first(r)

		if IdentifierStartp(p) then

			p:=ParseDeclStart(r)

			r:=extent(finish(p), r)

			r:=extent(start(ParseJunk(r, true, true)), r)

			while r/="" do

				q:=ParseDeclEndRetry(p, r)

				if search(declstart, "\{")/="" then

					printline("WARNING: definition of aggregate within class, should be 
moved outside of the class.\\n"~declstart~" "~q~"\\n\\n")

				end if

				s:=FirstId(q);

				members:=members~s~"\\n"

				t:=search(wholefile, "MISSING_RETURN_TYPE_SELF_"~s)

				if  t/="" then

					replace(t, declstart~" "~extent(start(q), start(s)))

					t:=extent(finish(t), wholefile)

					u:=ParseJunk(t, true, false)

					t:=extent(finish(u), finish(t))

					u:=ParseId(t)

					t:=extent(finish(u), finish(t))

					u:=ParseJunk(t, true, false)

					t:=extent(finish(u), finish(t))

					u:=first(t)

					t:=extent(finish(u), finish(t))

					u:=ParseArgs(t, 0, "")

					t:=extent(finish(u), finish(t))

					u:=ParseJunk(t, true, false)

					t:=extent(finish(u), finish(t))

					u:=first(t)

					t:=extent(finish(u), finish(t))

					replace(start(t), extent(finish(s), finish(q)))

				end if

				r:=extent(finish(q), r)

				r:=extent(finish(ParseJunk(r, true, true)), r)

				if first(r)/="," then

					exit while

				end if

				r:=extent(finish(first(r)), r)

				r:=extent(finish(ParseJunk(r, true, true)), r)

			end while

		else

			if p="\}" then

				return extent(start(b), finish(r))

			end if

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

		end if

	end while

	return extent(start(b), start(r))

end function


marker function ParseNameKey(marker b)

	marker p:=anyof(extent(finish(first(b)), b), "]")

	if p="" then

		printline("WARNING: couldn't find end of class name key.")

		return b

	else

	return extent(start(b), finish(p))

	end if

end function


void function CheckDuplication()

	marker p

	marker q:=members

	marker r

	printline("Checking for duplication.")

	while q/="" do

		p:=ParseID(extent(finish(ParseJunk(q, true, true)), q))

		if p="" then

			exit while

		end if

		if p=currentclass then

			printline("WARNING: constructor may be shadowed by member function or 
data "~p~".")

		end if

		q:=extent(finish(p), q)

		r:=search(q, "\\n"~p~"\\n")

		if r/="" then

			printline("WARNING: member function "~p~" shadowed by data member.")

		end if

	end while

end function


marker function ParseClassHeader(marker b)

	marker r:=b

	marker p

	marker q

	r:=SkipNewLinesAndJunk(r)

	currentclass:=ParseID(r)

	printline("class:"~currentclass)

	r:=extent(finish(currentclass), r)

	r:=SkipNewLinesAndJunk(r)

	if first(r)="[" then

		p:=ParseNameKey(r)

		replace(p, "")

		r:=extent(finish(p), r)

		r:=SkipNewLinesAndJunk(r)

	end if

	if first(r)=":" then

		q:=first(r)

		replace(q, ": public ")

		r:=extent(finish(q), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		currentsuper:=ParseID(r)

		printline("super:"~currentsuper)

		r:=extent(finish(currentsuper), r)

		r:=SkipNewLinesAndJunk(r)

		if first(r)="[" then

			p:=ParseNameKey(r)

			replace(p, "")

			r:=extent(finish(p), r)

			r:=SkipNewLinesAndJunk(r)

		end if

	else \


		replace(finish(currentclass), " : public ATK ")

		currentsuper:="ATK"

		printline("super:"~currentsuper)

	end if

	if first(r)/="\{" then

		printline("WARNING: class header malformed.")

		return b

	end if

	q:=first(r);

	replace(q, "\{\\n"~"public:\\n\\tvirtual ATKregistryEntry 
*ATKregistry();\\n")

	return extent(start(b), finish(q))

end function


marker function ParseClass(marker b)

	marker r:=b

	marker p

	marker q

	marker s

	marker t:=ParseClassHeader(b)

	r:=extent(finish(t), r)

	p:=first(r)

	sawinitializeclassproc:=false

	sawinitializeobject:=false

	sawfinalizeobject:=false

	members:="\\n"

	while r/="" and p/="\}" do

		if IdentifierStartp(p) then

			p:=ParseID(r)

			r:=extent(finish(p), r)

			r:=extent(finish(ParseJunk(r, true, true)), r)

			s:=first(r);

			if s=":" then

				r:=extent(finish(first(r)), r)

				r:=extent(finish(ParseJunk(r, true, true)), r)

				if p="methods" or p="overrides" then

					q:=ParseMethods(r, p="overrides")

				elif p="macros" then

					q:=ParseMacros(r)

				elif p="macromethods" then

					q:=ParseMacroMethods(r)

				elif p="classprocedures" then

					q:=ParseClassProcedures(r)

				elif p="data" then

					q:=ParseData(r)

				else

					printline("WARNING: unrecognized section "~p~"\\n")

					return r

				end if

				replace(extent(start(p), finish(s)), "")

				p:=q

			end if

		else

			p:=first(r)

		end if

		r:=extent(finish(p), r)

		r:=extent(finish(ParseJunk(r, true, true)), r)

		p:=first(r)

	end while

	if forceinitializeclass and not(sawinitializeclassproc) then

		replace(last(t), last(t)~"\\tstatic boolean InitializeClass();\\n")

		forceinitializeclass:=false

	end if

	if forcector and not(sawinitializeobject) then

		replace(last(t), last(t)~"\\t"~currentclass~"();\\n")

		forcector:=false

	end if

	if forcedtor and not(sawfinalizeobject) then

		replace(last(t), last(t)~"\\t~"~currentclass~"();\\n")

		forcedtor:=false

	end if

	CheckDuplication()

	return p

end function


-- promote short and char to int, and float to double

marker function PromoteTypes(marker decl)

	marker res

	marker p

	marker q

	res := copy(decl)

	p := search(res, "(")

	if (p="") then

		return res

	end if


	p := regsearch(finish(p), ident)

	while (p/="") do

		if p="char" or p="short" or p="float" then

			q := regsearch(finish(p), "[a-zA-Z_*&(]")

			if q/="*" and q/="&" and q/="(" then

				if p="char" or p="short" then

					replace(p, "int")

				else

					replace(p, "double")

				end if

			end if

		end if

		p := regsearch(finish(p), ident)

	end while


	return res

end function


marker function FindPrototype(marker name)

marker p

marker q

marker s

marker b:=prototypes

	while b/="" do

		s := regsearch(b, "[^a-zA-Z0-9_]" ~ name ~ optspace~"(")

		p:=regsearch(s, ident)

		if p=name then

			return s

		end if

		b:=extent(finish(s), b)

	end while

	return start(prototypes)

end function


marker function Position(marker p)

marker file:=copy(extent(start(base(p)), start(p)))

integer line:=1

marker q

	ReplaceStuff(file)

	while file/="" do

		q:=anyof(file, "\\n")

		if q/="" then

			line:=line+1

		else

			exit while

		end if

		file:=extent(finish(q), file)

	end while

	return "Line "~textimage(line)~", Column "~textimage(1+length(file))

end function


void function Balance(marker file)

marker b:=file

marker p

integer brace:=0

integer bracket:=0

integer paren:=0

marker lastbracezero:=start(file)

marker lastbracketzero:=start(file)

marker lastparenzero:=start(file)

	while b/="" do

		p:=anyof(b, "\{\}[]()")

		if  p="\{" then

			brace:=brace+1

		elif p="\}" then

			brace:=brace-1

			if brace=0 then

				lastbracezero:=p

			elif brace<0 then

				printline("WARNING: Too many '\}'s  at line "~Position(p)~".")

			end if

		elif p="[" then

			bracket:=bracket+1

		elif p="]" then

			bracket:=bracket-1

			if bracket=0 then

				lastbracketzero:=p

			elif bracket<0 then

				printline("WARNING: Too many ']'s at line "~Position(p)~".")

			end if

		elif p="(" then

			paren:=paren+1

		elif p=")" then

			paren:=paren-1

			if paren=0 then

				lastparenzero:=p

			elif paren<0 then

				printline("WARNING: Too many ')'s at line "~Position(p)~".")

			end if

		else

			exit while

		end if

		b:=extent(finish(p), b)

	end while

	if brace>0 then

		printline("WARNING: Not enough '\}'s last known good position: 
"~Position(lastbracezero)~".")

	end if

	if bracket>0 then

		printline("WARNING: Not enough ']'s last known good position: 
"~Position(lastbracketzero)~".")

	end if

	if paren>0 then

		printline("WARNING: Not enough ')'s last known good position: 
"~Position(lastparenzero)~".")

	end if

end function


void function ProcessHFile(marker filename, marker file)

	marker p

	marker q

	marker r

	marker s

	marker endjunk

	marker replacement

	marker nonfuncstuff

	boolean isextern

	keepconst:=newbase()

	keepcomments:=newbase()

	printline("Collapsing comments, strings and character constants.")

	RemoveStuff(file)

	printline("Checking \{\}[]() balancing")

	Balance(file)

	printline("Renaming C++ reserved words.")

	FixReservedIdentifiers(file)

	printline("Converting header.")

	wholefile:=file

	endjunk:=file

	r:=file

	while file/="" and endjunk/="" do

		endjunk:=ParseJunk(file, false, true)

		file:=extent(finish(endjunk), file)

	end while

	while file/="" do

		file:=extent(finish(ParseJunk(file, true, true)), file)

		p:=first(file)

		if p="\\n" then

			file:=extent(finish(p), file)

		elif IdentifierStartp(p) then

			p:=ParseID(file)


			if p="class_c" or p="package" then

				replace(p, "class")

				printline("here:"~p)

				q:=ParseClass(extent(finish(p), file))

				replace(start(p), "#include <"~currentsuper~".H>\\n")

				file:=extent(finish(q), file)

			else

				funcdef:=false

				replacement:=newbase()

				nonfuncstuff:=newbase()

				p:=ParseDeclStart(extent(start(p), file))

				starttemp:=p

				file:=extent(finish(p), file)

				while file/="" do

					funcdef:=false

					q:=ParseDeclEndRetry(starttemp, file)

					if funcdef then

						printline("Func "~declstart~" :: "~q)

						isextern := (regsearch(declstart, ident) = "extern")

						if (replacement/="") then

							replacement ~:= "\\n"

						end if

						r:=FindPrototype(regsearch(q, ident))

						if (r="") then

							replacement ~:= "/* MISSING DEFINITION "~q~" */\\n"~declstart~" 
"~q~";"

						else

							r := extent(r, search(start(r), ";"))

							s := first(r)

							while (s/="" and s/="\\n") do

								s := previous(s)

							end while

printline("extent:"~extent(finish(s), r))

							r := PromoteTypes(extent(finish(s), r))

							if (isextern) then

								replacement ~:= "extern "~r

							else

								replacement ~:= r

							end if

						end if

					else

						printline("Var  "~declstart~" :: "~q)

						if nonfuncstuff="" then

							nonfuncstuff ~:= declstart~" "~q

						else

							nonfuncstuff ~:= ", "~q

						end if

					end if

					file:=extent(finish(q), file)

					file:=extent(finish(ParseJunk(file, true, true)), file)

					if first(file) /= "," then

						exit while

					end if

					file:=extent(finish(first(file)), file)

					starttemp:=start(file)

				end while

				if replacement /= "" then

					if nonfuncstuff/="" then

						 replacement := nonfuncstuff ~ ";\\n" ~ replacement

					end if \


-- remove all comments from replacement

					r := anyof(replacement, "\\001\\003")

					while r/="" do

						replace(r, "")

						r := anyof(replacement, "\\001\\003")

					end while

-- extent(p,q) is entire declaration statment up to (but not including) 
semicolon

-- p is type phrase

					replace(extent(p,q),replacement)

					replace(regsearch(start(p), ";"), "")

				end if

			end if

		\


		else

			file:=extent(finish(p), file)

		end if

	end while

	printline("Re-expanding comments, strings and character constants.")

	ReplaceStuff(wholefile)

	printline("Adding extern \\"C\\"")

	replace(first(wholefile), cplusplusmagic~"\\n#include 
<atkproto.h>\\nBEGINCPLUSPLUSPROTOS\\n"~first(wholefile))

	replace(last(wholefile), last(wholefile)~"\\nENDCPLUSPLUSPROTOS\\n ")

	printline("Writing file:"~filename~"\\n")

	system("/bin/rm -f "~filename)

	if writefile(filename, wholefile)="" then

		printline("WARNING: write failed!")

	end if

end function


void function ProcessCHFile(marker filename, marker file)

	marker p

	marker q

	marker r

	marker s

	marker endjunk

	p:=search(filename, ".")

	if p/="" and not LookForClassInfo(extent(start(filename), start(p))) then

			printline("WARNING: Unknown class: "~currentclass)

			printline("WARNING: this class cannot be properly converted!")

			fatal:=true

			exit function

	end if

	dothisobject:=true

	members:=""

	keepconst:=newbase()

	keepcomments:=newbase()

	printline("Collapsing comments, strings and character constants.")

	RemoveStuff(file)

	printline("Checking \{\}[]() balancing")

	Balance(file)

	printline("Renaming C++ reserved words.")

	FixReservedIdentifiers(file)

	printline("Converting class.")

	wholefile:=file

	endjunk:=file

	r:=file

	while file/="" and endjunk/="" do

		endjunk:=ParseJunk(file, false, true)

		file:=extent(finish(endjunk), file)

	end while

	while file/="" do

		file:=extent(finish(ParseJunk(file, true, true)), file)

		p:=first(file)

		if p="\\n" then

			file:=extent(finish(p), file)

		elif IdentifierStartp(p) then

			p:=ParseID(file)


			if p="class_c" or p="package" then

				replace(p, "class")

				q:=ParseClass(extent(finish(p), file))

				replace(start(p), "#include <"~currentsuper~".H>\\n")

				file:=extent(finish(q), file)

			else

				p:=ParseDeclStart(extent(start(p), file))


				file:=extent(finish(p), file)

				file:=extent(finish(ParseJunk(file, true, true)), file)

				while first(file)/=";" and file/="" do

					q:=ParseDeclEndRetry(p, file)

					if q="" then

						printline("WARNING: bad decl end... restarting at next semicolon (or 
function body) after:"~p)

						q:=anyof(file, ";\{")

						if q=";" then

							file:=extent(finish(q), file)

						elif q="\{" then

							q:=ParseOpenBrace(extent(start(q), file))

							file:=extent(finish(q), file)

						else

							file:=rest(file)

						end if

						file:=extent(finish(ParseJunk(file, false, true)), file)

						exit while

					end if

					file:=extent(finish(q), file)

					file:=extent(finish(ParseJunk(file, true, true)), file)

					if first(file) /= "," then

						exit while

					end if

					p:=declstartm

					file:=extent(finish(first(file)), file)

					file:=extent(finish(ParseJunk(file, true, true)), file)

				end while

			end if

		\


		else

			file:=extent(finish(p), file)

		end if

	end while

	printline("Fixing method and classprocedure calls.")

	FixCalls(wholefile)

	printline("Fixing class structs.")

	FixClassStructs(wholefile)

	printline("Fixing foo->header.classname.eek references.")

	FixHeaderReferences(wholefile)

	printline("Flagging assignments to 'this'.")

	FlagAssignmentsToThis(wholefile)

	printline("Fixing view_DSattributes.")

	FixDSattributes(wholefile)

	printline("Re-expanding comments, strings and character constants.")

	ReplaceStuff(wholefile)

	p:=regsearch(filename, "[a-z0-9_]*\\\\.ch")

	replace(p,currentclass~".H")

	printline("filename:"~filename)

	printline("Writing file.")

	system("/bin/rm -f "~filename)

	if writefile(filename, "#ifndef _"~currentclass~"_H_\\n#define 
"~"_"~currentclass~"_H_\\n"~wholefile~"\\n#endif /* _"~currentclass~"_H_ 
*/\\n")	="" then

		printline("WARNING: couldn't write file!")

	end if

	dothisobject:=false

end function



function main3(args)

	marker files:=args

	marker file

	marker filename

	marker p

	marker q

	marker r


	while files/="" do

		r:=anyof(files, " ")

		filename:=extent(files, start(r))

		files:=extent(finish(r), files)

		file:=readfile(filename)

		printline("\\n### "~filename~" ###")

		RemoveStuff(file)

		writefile("nocomments", file)

		ReplaceStuff(file)

		writefile("comments", file)

	end while

end function


function main(args)

	marker files:=args

	marker file

	marker filename

	marker p

	marker q

	marker r


	andrewdir:=system("andrewdirs andrewdir")

	p:=search(andrewdir, "\\n")

	replace(p, "")

	classinfo:=newbase()

 	typeinfo:=readfile(andrewdir~"lib/c++conv/safemacrotypes")

	p:=search(files, " --- ")

	if p/="" then

		q:=extent(finish(p), files)

		files:=extent(start(files), start(p))

		while q/="" do

			p:=anyof(q, " ")

			filename:=extent(q, start(p))

			q:=extent(finish(p), q)

			r:=readfile(filename)

			if r/="" then

				classinfo~:=r

			end if

		end while

	end if

	classinfo~:=readfile(andrewdir~"lib/c++conv/classinfo")


	while files/="" do

		forcector:=false

		forcedtor:=false

		forceinitializeclass:=false

		r:=anyof(files, " ")

		filename:=extent(files, start(r))

		files:=extent(finish(r), files)

		file:=copy(readfile(filename))

		printline("\\n### "~filename~" ###")

		if isreadonly(file) then

			printline("!!! READONLY !!!")

		else

		printline("Scanning for binary characters.")

		ScanForNonASCII(file)

		p:=search(filename, ".c")

		if p/="" and extent(finish(p), filename)="" then

			currentclass:=""

			currentsuper:=newbase()

			keepcomments:=newbase()

			keepconst:=""

			prototypes:=""

			auxmodule:=false

			firstfuncdecl:=""

			ProcessSourceFile(filename, file)

			if not fatal then

				if currentclass/="" and not(auxmodule) then

					p:=regsearch(filename, "[a-zA-Z_0-9]*\\\\.c")

					replace(p, currentclass~".C")

				else

					p:=search(filename, ".c")

					replace(p, ".C")

				end if

				if not hadandrewos and not(isreadonly(firstinclude)) then

					printline("Forcing #include of <andrewos.h>")

					replace(first(firstinclude), "#include 
<andrewos.h>\\n"~first(firstinclude))

				end if

				printline("Writing file: "~filename)

				system("/bin/rm -f "~filename)

				if writefile(filename, file)="" then

					printline("WARNING: couldn't write file.")

				end if

			end if

		else

			p:=search(filename, ".ch")

			if p/="" and extent(finish(p), filename)="" then

				ProcessCHFile(filename, file)

			else \


				printline("Unknown filetype: "~filename)

			end if

		end if

		end if

	end while

end function



function main2(args)

	marker files:=args

	marker file

	marker filename

	marker p

	marker q

	marker r


	prototypes:=""


	while files/="" do

		r:=anyof(files, " ")

		filename:=extent(files, start(r))

		files:=extent(finish(r), files)

		file:=copy(readfile(filename))

		printline("\\n### "~filename~" ###")

		if isreadonly(file) then

			printline("!!! READONLY !!!")

		else

		p:=search(filename, ".c")

		if p/="" and extent(finish(p), filename)="" then

			keepcomments:=newbase()

			keepconst:=newbase()

			firstfuncdecl:=""

			ProcessSourceFile(filename, file)

		else

			p:=search(filename, ".h")

			if p/="" and extent(finish(p), filename)="" then

				r:=search(file, "\\n")

				if(extent(start(file), start(r))=cplusplusmagic) then

					printline(filename~" ALREADY CONVERTED, using original")

					file:=readfile(filename~".orig")

				else

					system("/bin/rm -f "~filename~".orig")

					if writefile(filename~".orig", file)="" then

						printline("WARNING: couldn't write file!")

					end if

				end if			\


				ProcessHFile(filename, file)

			else \


				printline("Unknown filetype: "~filename)

			end if

		end if

		end if

	end while


	\


end function\
\enddata{text,537982208}
