/* Copyright 1993 Carnegie Mellon University All rights reserved.
  $Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef ATKOS_H
#define ATKOS_H 1

#include <stdio.h> /* needed so that we can declare Andrew_tmpfile. */
 
#ifdef NEED_ANSI_TMPFILES
extern char *Andrew_tmpnam();
extern FILE *Andrew_tmpfile();

#define tmpnam(buf) Andrew_tmpnam(buf)
#define tmpfile() Andrew_tmpfile()

/* the following #defines may be overridden in the system.h file */
#ifndef P_tmpdir
#define P_tmpdir "/tmp/"
#endif
#ifndef L_tmpnam
#define L_tmpnam (sizeof(P_tmpdir)+15)
#endif
#ifndef TMP_MAX
#define TMP_MAX 52 /* maybe this should be larger, this is a conservative guess. */
#endif
#endif /* NEED_ANSI_TMPFILES */

#ifdef NEED_LOCKF
#undef osi_ExclusiveLockNoBlock
#define osi_ExclusiveLockNoBlock(fid) Andrew_lockf(fid)
#undef osi_UnLock
#define osi_UnLock(fid) Andrew_unlockf(fid)
#endif

#endif /* ATKOS_H */
