/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/utils/nntp/lib/RCS/llist.c,v 1.8 1994/06/09 21:18:04 rr2b Exp $";
#endif

#include "llist.h"
#include <andrewos.h>

#if !POSIX_ENV
extern void	free();
extern caddr_t	malloc();
#endif

#define	align(x)	((x) + ((x) % sizeof(long)))

/*
** recursively free a linked list
*/
void
l_free(lp)
register struct llist *lp;
{
	if (lp->l_next == NULL)
		return;
	l_free(lp->l_next);
	free(lp->l_item);
}

/*
** allocate a new element in a linked list, along with enough space
** at the end of the item for the next list element header.
*/
struct llist *
l_alloc(lp, s, len)
register struct llist	*lp;
caddr_t	*s;
register unsigned len;
{
	if (s == NULL || lp == NULL)
		return(NULL);

	lp->l_len = len;
	len = align(len);

	if ((lp->l_item = malloc(len + sizeof(struct llist))) == NULL)
		return(NULL);

	bcopy(s, lp->l_item, len);
	lp->l_next = (struct llist *)(&lp->l_item[len]);

	/*
	** set up next list entry
	*/
	lp = lp->l_next;
	lp->l_next = NULL;
	lp->l_item = NULL;
	lp->l_len = 0;
	return(lp);
}
