/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/msclients/nns/RCS/gle.c,v 2.7 1992/12/15 21:22:34 rr2b R6tape $";
#endif

/* Methods for Group List Entries
*/

#include <big.h>

void            GLESetBefore(gle, val)
GListEntry_t   *gle;
int             val;
{
    gle->before = val;
}

void            GLESetAhead(gle, val)
GListEntry_t   *gle;
int             val;
{
    gle->ahead = val;
}

char           *GLEGetFilename(gle)
GListEntry_t   *gle;
{
    return (gle->filename);
}

void            GLESet(gle, filename, folder, ahead, before, ignore, time)
GListEntry_t   *gle;
char           *filename, *folder;
int             ahead, before, ignore;
long            time;
{
    gle->filename = filename;
    gle->folder = folder;
    gle->ahead = ahead;
    gle->before = before;
    gle->ignore = ignore;
    gle->time = time;
}

void            GLESetIgnore(gle, ignore)
GListEntry_t   *gle;
int             ignore;
{
    gle->ignore = ignore;
}

int             GLEGetIgnore(gle)
GListEntry_t   *gle;
{
    return (gle->ignore);
}

char           *GLEGetFolder(gle)
GListEntry_t   *gle;
{
    return (gle->folder);
}

int             GLEGetBefore(gle)
GListEntry_t   *gle;
{
    return (gle->before);
}

int             GLEGetAhead(gle)
GListEntry_t   *gle;
{
    return (gle->ahead);
}

int             GLECompare(gle1, gle2)
GListEntry_t   *gle1, *gle2;
{
    int             result = strcmp(gle1->folder, gle2->folder);

    if (!result)
	result = (int) (gle1->time - gle2->time);
    return (result);
}
