/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/storfile.c,v 2.8 1993/07/02 23:01:53 rr2b Exp $";
#endif

#include <stdio.h>
#include <ms.h>
#include <andrewos.h> /* sys/file.h */

MS_StorePartialFile(FileName, startpos, len, mode, Truncate, WhatToStore)
char *FileName, *WhatToStore;
int startpos, len, mode, Truncate;
{
    int fd, errsave;

    debug(1, ("MS_StorePartialFile %s pos %d len %d mode %d\n", FileName, startpos, len, mode));
    fd = open(FileName, O_RDWR | O_CREAT, mode);
    if (fd<0) {
	AMS_RETURN_ERRCODE(errno, EIN_OPEN, EVIA_STOREPARTIALFILE);
    }
    if (startpos>0 && lseek(fd, startpos, SEEK_SET) < 0) {
	errsave = errno;
	vclose(fd);
	if ((startpos == 0) && Truncate) unlink(FileName);
	AMS_RETURN_ERRCODE(errsave, EIN_LSEEK, EVIA_STOREPARTIALFILE);
    }
    if (writeall(fd, WhatToStore, len) < 0) {
	errsave = errno;
	vclose(fd); /* BOGUS -- should somehow ABORT the Vice store */
	if ((startpos == 0) && Truncate) unlink(FileName);
	AMS_RETURN_ERRCODE(errsave, EIN_WRITE, EVIA_STOREPARTIALFILE);
    }
    if (Truncate && ftruncate(fd, startpos + len)) {
	errsave = errno;
	vclose(fd); /* BOGUS -- should somehow ABORT the Vice store */
	if ((startpos == 0) && Truncate) unlink(FileName);
	AMS_RETURN_ERRCODE(errsave, EIN_FTRUNCATE, EVIA_STOREPARTIALFILE);
    }
    if (vclose(fd)) {
	errsave = errno;
	if ((startpos == 0) && Truncate) unlink(FileName);
	AMS_RETURN_ERRCODE(errsave, EIN_VCLOSE, EVIA_STOREPARTIALFILE);
    }
    return(0);
}
