/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/pfmsg.c,v 2.12 1992/12/15 21:20:00 rr2b R6tape $";
#endif


 

#include <andrewos.h>
#include <ms.h>
#ifdef AFS_ENV
#include <netinet/in.h>
#include <afs/param.h>
#include <sys/ioctl.h>
#include <afs/errors.h>
#include <afs/prs_fs.h>
#include <afs/venus.h>
#endif /* AFS_ENV */

MS_PrefetchMessage(DirName, id, GetNext) /* prefetch a vice file */
char *DirName, *id;
int GetNext;
{
#ifdef AFS_ENV
    struct MS_Directory *Dir;
    struct ViceIoctl blob;
    int msgnum;
    char SnapshotDum[AMS_SNAPSHOTSIZE+1], FileName[1+MAXPATHLEN];

    if (AMS_ViceIsRunning) {
    blob.out_size = 0;
    blob.in_size = 0;

    if (!id || !*id) {
	/* Just prefetch the folder */
	sprintf(FileName, "%s/%s", DirName, MS_DIRNAME);
    } else {
	if (ReadOrFindMSDir(DirName, &Dir, MD_READ) != 0) {
	    return(mserrcode);
	}
	if (GetSnapshotByID(Dir, id, &msgnum, SnapshotDum)) {
	    CloseMSDir(Dir, MD_READ);
	    return(mserrcode);
	}
	if (GetNext && GetSnapshotByNumber(Dir, ++msgnum, SnapshotDum)) {
	    CloseMSDir(Dir, MD_READ);
	    return(mserrcode);
	}
	CacheDirectoryForClosing(Dir, MD_READ);
	QuickGetBodyFileName(Dir->UNIXDir, AMS_ID(SnapshotDum), FileName);
    }
    if (pioctl(FileName, VIOCPREFETCH, &blob) &&
	(RetryBodyFileName(FileName) < 0
	 || pioctl(FileName, VIOCPREFETCH, &blob))) {
	AMS_RETURN_ERRCODE(errno, EIN_PIOCTL, EVIA_PREFETCHMSG);
    }
    }
#endif /* AFS_ENV */
    return(0);
}

