/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/hdlpref.c,v 2.8 1993/06/15 03:56:02 rr2b Exp $";
#endif

#include <ms.h>
#include <util.h>

MS_HandlePreference(prog, pref, InVal, OutVal, OutLim, opcode, resulti, defaulti)
char *prog, *pref, *InVal; /* Passed IN */
char *OutVal; /* Passed OUT */
int OutLim, opcode, defaulti; /* Passed IN */
int *resulti; /* Passed OUT */
{
    char *s, *key;

    key = malloc(2+strlen(prog) + strlen(pref));
    if (!key) {
	AMS_RETURN_ERRCODE(ENOMEM, EIN_MALLOC, EVIA_HANDLEPREFERENCE);
    }
    sprintf(key, "%s.%s", prog, pref);
    switch(opcode) {
	case AMS_GETPROFILESTRING:
	    s = getprofile(key);
	    if (s) {
		strncpy(OutVal, s, OutLim);
	    } else {
		OutVal[0] = '\0';
	    }
	    break;
	case AMS_GETPROFILEINT:
	    *resulti = getprofileint(key, defaulti);
	    break;
	case AMS_GETPROFILESWITCH:
	    *resulti = getprofileswitch(key, defaulti);
	    break;
	case AMS_SETPROFILESTRING:
	    if (setprofilestring(prog, pref, InVal)) {
		free(key);
		AMS_RETURN_ERRCODE(errno, EIN_SETPROF, EVIA_HANDLEPREFERENCE);
	    }
	    break;
	default:
	    free(key);
	    AMS_RETURN_ERRCODE(EINVAL, EIN_PARAMCHECK, EVIA_HANDLEPREFERENCE);
    }
    free(key);
    return(0);
}
