/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/getfmt.c,v 2.8 1992/12/15 21:19:11 rr2b R6tape $";
#endif


 

#include <ms.h>
#include <hdrparse.h>

GetFormatFromMessage(Msg, ThisFormat, bufsize, IsBE2)
struct MS_Message *Msg;
char *ThisFormat;
int bufsize, *IsBE2;
{
    char HeadBuf[2000], fmttype[25], fmtvers[25], fmtresources[200];
    int len;

    ThisFormat[0] = '\0';
    len = Msg->ParsedStuff->HeadBodyLen[HP_CONTENTTYPE];
    if (len > 0) {
	if (len > (sizeof(HeadBuf) - 1)) len = sizeof(HeadBuf) - 1;
	strncpy(HeadBuf, Msg->ParsedStuff->HeadBody[HP_CONTENTTYPE], len);
	HeadBuf[len] = '\0';
	BreakDownContentTypeField(HeadBuf, fmttype, sizeof(fmttype), fmtvers, sizeof(fmtvers), fmtresources, sizeof(fmtresources));
	if (!lc2strncmp("x-be2", fmttype, strlen(fmttype))) {
	    strncpy(ThisFormat, fmtvers, bufsize);
	}
    } else {
	len = Msg->ParsedStuff->HeadBodyLen[HP_SCRIBEFORMAT];
	if (len > 0) {
	    if (len > (sizeof(HeadBuf) - 1)) len = sizeof(HeadBuf) - 1;
	    strncpy(HeadBuf, Msg->ParsedStuff->HeadBody[HP_SCRIBEFORMAT], len);
	    HeadBuf[len] = '\0';
	    strncpy(ThisFormat, StripWhiteEnds(HeadBuf), bufsize);
	}
    }
    *IsBE2 = (ThisFormat[0]) ? 1 : 0;
    return(0);
}

