/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/convmail.c,v 2.10 1993/06/15 03:56:02 rr2b Exp $";
#endif

#include <andrewos.h>
#include <ms.h>

extern char home[];

MS_ConvertOldMail(good, bad)
int *good, *bad;
{
    char OldName[1+MAXPATHLEN], NewName[1+MAXPATHLEN], DirName[1+MAXPATHLEN], NewDirName[1+MAXPATHLEN], ErrorText[256];
    DIR *dirp;
    int mybad = 0;
    DIRENT_TYPE *dirent;

    debug(1, ("MS_ConvertOldMail"));
    if (EnsureMailDirExists()) {
	return(mserrcode);
    }
    *good = *bad = 0;
    sprintf(DirName, "%s/Maillib", home);
    sprintf(NewDirName, "%s/.MESSAGES/%s", home, AMS_DEFAULTMAILDIR);
    mserrcode = MS_SetSubscriptionEntry(NewDirName, AMS_DEFAULTMAILDIR, AMS_ALWAYSSUBSCRIBED);
    if (mserrcode) {
	return(mserrcode);
    }
    if ((dirp = opendir(DirName)) == NULL) {
	if (errno == ENOENT) {
	    return(0); /* Nothing to convert, that's fine */
	}
	AMS_RETURN_ERRCODE(errno, EIN_OPENDIR, EVIA_CONVERTOLD);
    }
    while ((dirent = readdir(dirp)) != NULL) {
	if (!strcmp(dirent->d_name, ".")) continue;
	if (!strcmp(dirent->d_name, "..")) continue;
	sprintf(OldName, "%s/%s", DirName, dirent->d_name);
	sprintf(NewName, "%s/.MESSAGES/%s/%s", home, AMS_DEFAULTMAILDIR, dirent->d_name);
	if (!strcmp(dirent->d_name, "view.grt") || !strcmp(dirent->d_name, "messages.grt")) {
	    if (unlink(OldName)) {
		sprintf(ErrorText, "Could not unlink file %s", ap_Shorten(dirent->d_name));
		NonfatalBizarreError(ErrorText);
	    }
	} else {
	    if (RenameEvenInVice(OldName, NewName)) {
		++mybad;
		sprintf(ErrorText, "Could not convert old mail file %s", ap_Shorten(dirent->d_name));
		NonfatalBizarreError(ErrorText);
	    }
	}
    }
    closedir(dirp);
    if (rmdir(DirName)) {
	sprintf(ErrorText, "Could not remove old Maillib directory (%d)", errno);
	NonfatalBizarreError(ErrorText);
    }
    mserrcode = MS_ReconstructDirectory(NewDirName, good, bad, 1);
    *bad += mybad;
    return(mserrcode);
}
