/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/bldwide.c,v 2.13 1993/06/15 03:56:02 rr2b Exp $";
#endif

#include <ms.h>
#include <hdrparse.h>


BuildWideReply(Msg, IncludeFrom)
struct MS_Message *Msg;
Boolean IncludeFrom;
{
    struct ParsedMsg *PStuff;
    char *NewWide;
    int WLen;

    debug(1, ("BuildWideReply\n"));
    PStuff = Msg->ParsedStuff;
    Msg->WideReply = malloc(WLen = 2000);
    if (Msg->WideReply == NULL) {
	AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
    }
    if (IncludeFrom && PStuff->HeadBody[HP_ALLREPLY]) {
	if ((Msg->ParsedStuff->HeadBodyLen[HP_ALLREPLY]+5) > WLen) {
	    WLen = Msg->ParsedStuff->HeadBodyLen[HP_ALLREPLY]+5;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* Use strncat when we could use strncpy, to guarantee null-termination */
	*Msg->WideReply = 0;
	strncat(Msg->WideReply, PStuff->HeadBody[HP_ALLREPLY], PStuff->HeadBodyLen[HP_ALLREPLY]);
	return(0);
    }
    if (PStuff->HeadBody[HP_WIDEREPLY]) {
	if ((Msg->ParsedStuff->HeadBodyLen[HP_WIDEREPLY]+5) > WLen) {
	    WLen = Msg->ParsedStuff->HeadBodyLen[HP_WIDEREPLY]+5+80;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* Use strncat when we could use strncpy, to guarantee null-termination */
	*Msg->WideReply = 0;
	strncat(Msg->WideReply, PStuff->HeadBody[HP_WIDEREPLY], PStuff->HeadBodyLen[HP_WIDEREPLY]);
	debug(16, ("Wide Reply field is <%s>\n", Msg->WideReply));
	if (IncludeFrom && Msg->ReplyTo && *Msg->ReplyTo) {
	    if ((strlen(Msg->ReplyTo)+strlen(Msg->WideReply)+5) > WLen) {
		WLen = strlen(Msg->ReplyTo)+strlen(Msg->WideReply)+5;
		Msg->WideReply = realloc(Msg->WideReply, WLen);
		if (Msg->WideReply == NULL) {
		    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
		}
	    }
	    strcat(Msg->WideReply, ", ");
	    strcat(Msg->WideReply, Msg->ReplyTo);
	}
	return(0);
    }
    *Msg->WideReply = 0;
    if (PStuff->HeadBody[HP_TO]) {
	if ((Msg->ParsedStuff->HeadBodyLen[HP_TO]+strlen(Msg->WideReply)+5) > WLen) {
	    WLen = Msg->ParsedStuff->HeadBodyLen[HP_TO]+strlen(Msg->WideReply)+5+80;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE(ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* Note that only the first one omits the comma addition */
	/* Use strncat when we could use strncpy, to guarantee null-termination */
	*Msg->WideReply = 0;
	strncat(Msg->WideReply, PStuff->HeadBody[HP_TO], PStuff->HeadBodyLen[HP_TO]);
    }
#ifdef NOTDEF
    if (PStuff->HeadBody[HP_CC]) {
	if ((PStuff->HeadBodyLen[HP_CC]+strlen(Msg->WideReply)+5) > WLen) {
	    WLen = PStuff->HeadBodyLen[HP_CC]+strlen(Msg->WideReply)+5+80;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE(ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* The aforementioned comma addition */
	if (*Msg->WideReply) strcat(Msg->WideReply, ", ");
	strncat(Msg->WideReply, PStuff->HeadBody[HP_CC], PStuff->HeadBodyLen[HP_CC]);
    }
#endif /* NOTDEF */
    if (PStuff->HeadBody[HP_RESENTTO]) {
	if ((PStuff->HeadBodyLen[HP_RESENTTO]+strlen(Msg->WideReply)+5) > WLen) {
	    WLen = PStuff->HeadBodyLen[HP_RESENTTO]+strlen(Msg->WideReply)+5+80;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* The aforementioned comma addition */
	if (*Msg->WideReply) strcat(Msg->WideReply, ", ");
	strncat(Msg->WideReply, PStuff->HeadBody[HP_RESENTTO], PStuff->HeadBodyLen[HP_RESENTTO]);
    }
    if (IncludeFrom && Msg->ReplyTo) {
	if ((strlen(Msg->ReplyTo)+strlen(Msg->WideReply)+5) > WLen) {
	    WLen = strlen(Msg->ReplyTo)+strlen(Msg->WideReply)+5+80;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	/* The aforementioned comma addition */
	if (*Msg->WideReply) strcat(Msg->WideReply, ", ");
	strcat(Msg->WideReply, Msg->ReplyTo);
    }
    if (PStuff->HeadBody[HP_BCC]) {
	if ((PStuff->HeadBodyLen[HP_BCC]+strlen(Msg->WideReply)+5) > WLen) {
	    WLen = PStuff->HeadBodyLen[HP_BCC]+strlen(Msg->WideReply)+5;
	    Msg->WideReply = realloc(Msg->WideReply, WLen);
	    if (Msg->WideReply == NULL) {
		AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDWIDEREPLY);
	    }
	}
	if (*Msg->WideReply) strcat(Msg->WideReply, ", ");
	strncat(Msg->WideReply, PStuff->HeadBody[HP_BCC], PStuff->HeadBodyLen[HP_BCC]);
    }
    if (!StripMyselfFromAddressList(Msg->WideReply, &NewWide)) {
	free(Msg->WideReply);
	Msg->WideReply = NewWide;
    }
    debug(16, ("Wide Reply field is <%s>\n", Msg->WideReply));
    return(0);
}
