/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/bldreply.c,v 2.11 1993/06/15 02:37:24 rr2b Exp $";
#endif

#include <ms.h>
#include <hdrparse.h>

BuildReplyField(Msg)
struct MS_Message *Msg;
{
    struct ParsedMsg *PStuff;

    debug(1, ("Building Reply field\n"));
    PStuff = Msg->ParsedStuff;
    if (PStuff->HeadBody[HP_REPLY_TO]) {
	if (Msg->ReplyTo)
	    free(Msg->ReplyTo);
	Msg->ReplyTo = malloc(1+PStuff->HeadBodyLen[HP_REPLY_TO]);
	if (Msg->ReplyTo == NULL) {
	    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDREPLY);
	}
	strncpy(Msg->ReplyTo, PStuff->HeadBody[HP_REPLY_TO], PStuff->HeadBodyLen[HP_REPLY_TO]);
	Msg->ReplyTo[PStuff->HeadBodyLen[HP_REPLY_TO]] = '\0';
    } else if (PStuff->HeadBody[HP_FROM]) {
	if (Msg->ReplyTo)
	    free(Msg->ReplyTo);
	Msg->ReplyTo = malloc(1+PStuff->HeadBodyLen[HP_FROM]);
	if (Msg->ReplyTo == NULL) {
	    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDREPLY);
	}
	strncpy(Msg->ReplyTo, PStuff->HeadBody[HP_FROM], PStuff->HeadBodyLen[HP_FROM]);
	Msg->ReplyTo[PStuff->HeadBodyLen[HP_FROM]] = '\0';
    } 
/* The following are commented out on cfe's advice: */
#ifdef UNDEFINEDGARBAGE
    else if (PStuff->HeadBody[HP_RESENTFROM]) {
	if (Msg->ReplyTo)
	    free(Msg->ReplyTo);
	Msg->ReplyTo = malloc(1+PStuff->HeadBodyLen[HP_RESENTFROM]);
	if (Msg->ReplyTo == NULL) {
	    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDREPLY);
	}
	strncpy(Msg->ReplyTo, PStuff->HeadBody[HP_RESENTFROM], PStuff->HeadBodyLen[HP_RESENTFROM]);
	Msg->ReplyTo[PStuff->HeadBodyLen[HP_RESENTFROM]] = '\0';
    } else if (PStuff->HeadBody[HP_SENDER]) {
	if (Msg->ReplyTo)
	    free(Msg->ReplyTo);
	Msg->ReplyTo = malloc(1+PStuff->HeadBodyLen[HP_SENDER]);
	if (Msg->ReplyTo == NULL) {
	    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDREPLY);
	}
	strncpy(Msg->ReplyTo, PStuff->HeadBody[HP_SENDER], PStuff->HeadBodyLen[HP_SENDER]);
	Msg->ReplyTo[PStuff->HeadBodyLen[HP_SENDER]] = '\0';
    } else if (PStuff->HeadBody[HP_RETURNPATH]) {
	if (Msg->ReplyTo)
	    free(Msg->ReplyTo);
	Msg->ReplyTo = malloc(1+PStuff->HeadBodyLen[HP_RETURNPATH]);
	if (Msg->ReplyTo == NULL) {
	    AMS_RETURN_ERRCODE( ENOMEM, EIN_MALLOC, EVIA_BUILDREPLY);
	}
	strncpy(Msg->ReplyTo, PStuff->HeadBody[HP_RETURNPATH], PStuff->HeadBodyLen[HP_RETURNPATH]);
	Msg->ReplyTo[PStuff->HeadBodyLen[HP_RETURNPATH]] = '\0';
    }
#endif /* UNDEFINEDGARBAGE */
    debug(16, ("Reply to field is <%s>\n", Msg->ReplyTo));
    return(0);
}
