/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/blddate.c,v 2.12 1993/06/10 21:01:44 rr2b Exp $";
#endif

#include <andrewos.h> /* sys/time.h */
#include <ms.h>
#include <hdrparse.h>

BuildDateField(Msg, datetype)
struct MS_Message *Msg;
int datetype;
{
    unsigned int when;
    char DateBuf[250];
    struct tm TmBuf;

    debug(1, ("Build date field\n"));
    switch(datetype) {
	case DATETYPE_FROMHEADER:
	    if (Msg->ParsedStuff->HeadBody[HP_DATE]) {
		when = Msg->ParsedStuff->HeadBodyLen[HP_DATE];
		if (when > (sizeof(DateBuf)-1)) when = (sizeof(DateBuf)-1);
		strncpy(DateBuf, Msg->ParsedStuff->HeadBody[HP_DATE], when);
		DateBuf[when] = '\0';
		if (!parsedateheader(DateBuf, &TmBuf, 1, 1, 1, 0 /* &when */)) {
		    when = (unsigned int) gtime(&TmBuf);
		    if (when <= ((unsigned int) time(0) + 7*24*60*60) && when <= (unsigned int) 0xc0000000) break;
		}
	    } /* drop through */
	case DATETYPE_FROMFILE:
	    when = (unsigned int) Msg->RawFileDate;
	    if (when <= ((unsigned int) time(0) + 7*24*60*60) && when <= (unsigned int) 0xc0000000) break;
	case DATETYPE_CURRENT:
	default:
	    when = (unsigned int) time(0);
	    if (when > ((unsigned int) time(0) + 7*24*60*60) || when > (unsigned int) 0xc0000000) {
		AMS_RETURN_ERRCODE(EMSCLOCKBOGUS, EIN_PARAMCHECK, EVIA_BUILDDATE);
	    }
	    break;
    }
    strcpy(AMS_DATE(Msg->Snapshot), convintto64(when, 0));
    return(0);
}
