/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 7.2 of the 
 * Andrew User Interface System and is the 
 * property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * members of the Andrew Consortium with 
 * memberships extending into calendar year 
 * 1994.  This source code is not to be distributed 
 * to non-members of the consortium nor beyond 
 * a fifty-mile radius from the membership address.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef NORCSID
#define NORCSID
static char rcsid[]="$Header: /usr/user/auis-7.2/ams/libs/ms/RCS/altsnap.c,v 2.7 1992/12/15 21:17:22 rr2b R6tape $";
#endif

#include <stdio.h>
#include <andrewos.h>
#include <ms.h>

MS_AlterSnapshot(dirname, id, NewSnapshot, Code) 
char *dirname, *id, *NewSnapshot;
int Code;
{
    struct MS_Directory *Dir;
    int msgnum, errsave, i;
    char SnapshotDum[AMS_SNAPSHOTSIZE], *s, *t, DateBuf[AMS_DATESIZE];

    if (MSDebugging & 1) { /* Debugging SHOULD go to stdout -- nsb 5/16/86 */
	printf("MS_AlterSnapshot %s %s code %d\n", dirname, id, Code);
	fputs("Snapshot: 0x", stdout);
	for (i=0; i<AMS_SNAPSHOTSIZE; i++) fprintf(stdout, "%02x", (unsigned char) NewSnapshot[i]);
	fputs(")\n", stdout);
    }

    if (ReadOrFindMSDir(dirname, &Dir, MD_WRITE) != 0) {
	return(mserrcode);
    }
    if (GetSnapshotByID(Dir, id, &msgnum, SnapshotDum)) {
	errsave = mserrcode; 
	CloseMSDir(Dir, MD_WRITE);
	return(errsave);
    }
    switch(Code) {
	case ASS_REPLACE_ALL:
	    strcpy(DateBuf, AMS_DATE(SnapshotDum));
	    bcopy(NewSnapshot, SnapshotDum, AMS_SNAPSHOTSIZE);
	    strcpy(AMS_DATE(SnapshotDum), DateBuf);
	    break;
	case ASS_REPLACE_ATT_CAPT:
	    bcopy(AMS_CAPTION(NewSnapshot), AMS_CAPTION(SnapshotDum), AMS_CAPTIONSIZE);
	    /* DROP THROUGH TO NEXT CLAUSE */
	case ASS_REPLACE_ATTRIBUTES:
	    bcopy(AMS_ATTRIBUTES(NewSnapshot), AMS_ATTRIBUTES(SnapshotDum), AMS_ATTRIBUTESIZE);
	    break;
	case ASS_OR_ATTRIBUTES:
	    for (i=0, s=AMS_ATTRIBUTES(NewSnapshot), t = AMS_ATTRIBUTES(SnapshotDum); i<AMS_ATTRIBUTESIZE; ++i, ++s, ++t) {
		*t |= *s;
	    }
	    break;
	case ASS_AND_ATTRIBUTES:
	    for (i=0, s=AMS_ATTRIBUTES(NewSnapshot), t = AMS_ATTRIBUTES(SnapshotDum); i<AMS_ATTRIBUTESIZE; ++i, ++s, ++t) {
		*t &= *s;
	    }
	    break;
    }
    debug(4, ("Altering snapshot of  message %d %s\n", msgnum, AMS_CAPTION(SnapshotDum)));
    if (RewriteSnapshotInDirectory(Dir, msgnum, SnapshotDum)) {
	errsave = mserrcode;
	CloseMSDir(Dir, MD_WRITE);
	return(errsave);
    }
    if (CacheDirectoryForClosing(Dir, MD_WRITE)) {
	return(mserrcode);
    }
    return(0);
}
