ATK_INTER
#ifndef _rm_H_
#define _rm_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 


#include <atomlist.H>

struct resourceList
{
  class atomlist * name;
  class atom * type;
  long data;
  short found;
};


#include <ATK.H>

	typedef short (*rm_fptr)(long data, long *converted);

class rm : public ATK 
{
public:
	virtual ATKregistryEntry *ATKregistry();
  
	static boolean InitializeClass();

  static void ContextualPostResource( class atomlist * context, class atomlist *path,
			 long data, class atom * type );
  static void PostResource( class atomlist * path, long data,
	       class atom * type );
  static void PostManyResources( struct resourceList * resources,
		    class atomlist * context );
  static short GetResource( class atomlist * name,
	      class atomlist * className,
	      class atom * type,
	      long * data )  ;
  static void GetManyResources( struct resourceList * resources,
		   class atomlist * name,
		   class atomlist * className );
  static void PostConverter( class atom * fromtype, class atom * totype, rm_fptr converter );
};


/* conversion routines are called Convert( fromrock, outputrock )
   they should return FALSE (0) if the conversion fails */

#endif /* _rm_H_ */
