ATK_INTER
#ifndef _toksym_H_
#define _toksym_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991, 1993 - All Rights Reserved      *
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
\* ********************************************************************** */

/* toksym.ch
 *
 * A toksym object is a subclass of sym.  Its adds four fields:
 *	toknum	-  the token number for compiler
 *	loc, len 	-  position of the token in the source stream
 *	info	-  type dependant information
 *
 */


#include "sym.H"	
/* This include generates an error message claiming that sym.ih is included twice.  
   The conflict is with the include generated by class as part of toksym.ih, but
   the automatically generated include does NOT define the routines. */


/* the following doesn't work !?!?!  (in the old class system.  Maybe it works in C++)*/
/*	typedef sym_scopeType  toksym_scopeType;   */

typedef  long   toksym_scopeType;

#define toksym_GLOBAL sym_GLOBAL


union infotype {
	long intval;
	double *realval;
	char *str;
	long (*proc)();
	struct object *obj;
	struct node *node;
};


class toksym : public  sym
{
public:
	virtual ATKregistryEntry *ATKregistry();

	virtual char *ToC(class text *t, char *buf, long maxlen);
		/* copies the token from the text to the buffer, up to maxlen bytes
			returns buf */



/* the initial T in each of these procedure names is to get around a bug in the class system */

	static inline toksym_scopeType TNewScope(toksym_scopeType enclosingScope) {
		return ((toksym_scopeType)sym::NewScope(enclosingScope)); }

	static inline void TDestroyScope(toksym_scopeType scope) { 
		(sym::DestroyScope(scope)); }

	static inline toksym_scopeType TParentScope(toksym_scopeType scope) { 
		return ((toksym_scopeType)sym::ParentScope(scope)); }

	static inline class toksym * TDefine(char *name, 
				class toksym *proto, toksym_scopeType scope) { 
		return ((class toksym *)sym::Define(name, proto, scope)); }

	static inline boolean TUndefine(char *name, toksym_scopeType scope) { 
		return (sym::Undefine(name, scope)); }

	static inline class toksym *TFind(char *name, toksym_scopeType scope) { 
		return ((class toksym *)sym::Find(name, scope)); }

	static inline class toksym *TLocate(char *name, class toksym *proto,
 			toksym_scopeType scope, boolean *new_c) { 
		return ((class toksym *)sym::Locate(name, proto, scope, new_c)); }

	static inline long TFindAll(char *name, toksym_scopeType scope, 
			sym_findfptr proc, long rock) { 
		return (sym::FindAll(name, scope, proc, rock)); }


	inline char * TGetName()	{ return ((this)->name); }
	inline toksym_scopeType TGetScope()  {
		return ((toksym_scopeType)(this)->scope); }
	inline long GetLoc()		{ return ((this)->loc); }
	inline long GetLen()		{ return ((this)->len); }

	
	toksym();
	virtual ~toksym();


	short toknum;	/* token code for yacc */
	long loc, len;	/* position of token in source */
	union infotype info;	/* type dependent */

};


#endif /* _toksym_H_ */
