ATK_INTER
#ifndef _region_H_
#define _region_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 



#define region_PROGRAMMERVERSION 2

#include <ATK.H>

class region : public ATK  {
public:
	virtual ATKregistryEntry *ATKregistry();



    virtual void XorRegion(class region * RHS, class region * Result);
    virtual void UnionRegion(class region * RHS, class region * Result);
    virtual void IntersectRegion(class region * RHS, class region * Result);
    virtual void SubtractRegion(class region * RHS, class region * Result);
    virtual void ClearRegion();
    virtual void RectRegion(struct rectangle * NewRegnRect);
    virtual class region * DuplicateRegion()  ;
    virtual void OffsetRegion(long DeltaX, long DeltaY);
    virtual void InsetRegion(long DeltaX, long DeltaY);

    virtual boolean IsRegionEmpty()  ;
    virtual boolean IsPointInRegion(struct point * TestPt)  ;
    virtual boolean IsRectInRegion(struct rectangle * TestRect)  ;
    virtual boolean AreRegionsEqual(class region * TestRegion)  ;

    virtual struct rectangle * GetBoundingBox(struct rectangle *rect)  ;


    inline struct _XRegion * GetRegionData() { return ((this)->regionData)    /* Only used in the X code.  probably should subclass region to do this */; }


    static class region * CreateEmptyRegion()  ;
    static class region * CreateRectRegion(struct rectangle * RegionShape)  ;
    static class region * CreateOvalRegion(struct rectangle * RegionShape)  ;
    static class region * CreatePolyRegion(struct point * PointArray, short PointCount)  ;
    static void CopyRegion(class region * Destination, class region * Source);
    
	virtual ~region();
    
	region();

    struct _XRegion * regionData; /* really XRegion, but I don't want to include all of X just to get the typedef */
};


#endif /* _region_H_ */
