ATK_INTER
#ifndef _completion_H_
#define _completion_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/* complete.H
 * Class header for message line completion support module.
 */

#include <message.H>

struct result {
    char *partial;
    int partialLen; /* Length in chars not including terminating NUL */
    char *best;
    int max;
    int bestLen; /* Length in chars not including terminating NUL */
    enum message_CompletionCode code;
};

#include <ATK.H>

class completion : public ATK  {
public:
	virtual ATKregistryEntry *ATKregistry();

    
        static void CompletionWork(char *string, struct result *data);
        static int GetFilename(class view *view, char *prompt, char *startPath, char *buffer, long bufsiz, boolean directoryP, boolean mustMatch)  ;
        static long FindCommon(char *string1, char *string2)  ;
        
	static boolean InitializeClass();

	static void FileHelp(char *partialPath, long dummyData, message_workfptr helpTextFunction, long helpTextRock);
        static enum message_CompletionCode FileComplete(char *pathname, boolean directory, char *buffer, int bufferSize)  ;
};

#endif /* _completion_H_ */
