ATK_INTER
#ifndef _chart_H_
#define _chart_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


/**  SPECIFICATION -- External Facility Suite  *********************************

TITLE	The Chart Data-object

MODULE	chart.ch

VERSION	0.0

AUTHOR	TC Peters
	Information Technology Center, Carnegie-Mellon University 

DESCRIPTION
	This is the suite of Methods that suport the Chart Data-object.

    NB: The comment-symbol "===" indicates areas which are:
	    1 - Questionable
	    OR
	    2 - Arbitrary
	    OR
	    3 - Temporary Hacks
    Such curiosities need be resolved prior to Project Completion...


HISTORY
  02/23/89	Created (TCP)
  05/23/89	Add EnclosureModified notification-code (TCP)
  09/01/89	Upgrade to V1.0

END-SPECIFICATION  ************************************************************/


#define  chart_VERSION    1

#include <apt.H>

typedef struct chart_specification  chart_Specification;
struct  chart_specification
  {
  char	attribute;
  long	value;
  };

typedef struct chart_item	     *chart_type_item;
struct  chart_item
  {
  struct chart_item		     *next;
  char				     *name;
  long				      datum;
  long				      position;
  long				      value;
  char				      shade; /* 0 => None, 1 => White ... 255 = Black */
  };

typedef struct chart_monikers	     *chart_type_monikers;
struct  chart_monikers
  {
  char				     *chart_moniker;
  char				     *chart_module_name;
  };

typedef long (*chart_applyfptr)(long ca, class chart *self, struct chart_item *i, long datum);
typedef int (*chart_sortfptr) (struct chart_item  **a, struct chart_item  **b);

class chart : public  apt
  {
public:
	virtual ATKregistryEntry *ATKregistry();




   long Read( FILE *file, long id )				 ;
   long Write( FILE *file, long id, int level )		 ;
   char * ViewName()						 ;



  /**  Methods Dealing with Chart as a Whole  **/

  virtual long SetChartAttribute( long attribute, long value )			 ;
  virtual long ChartAttribute( long attribute_code )			 ;

  virtual void Apply( chart_applyfptr proc, long anchor, long datum );
  virtual void Reset( long mode );
  virtual void Sort( long mode, chart_sortfptr handler );
  virtual struct chart_monikers * Monikers()						 ;
  virtual char * ModuleName( char *moniker )				 ;
  virtual void SetDebug( boolean state );

  /**  Methods Dealing with Individual Items  **/

  virtual long SetItemAttribute( struct chart_item *item, long attribute, long value )
							 ;
  virtual long ItemAttribute( struct chart_item *item, long attribute_code )
							 ;
  virtual struct chart_item * CreateItem( char *item_name, long datum )		 ;
  virtual void DestroyItem( struct chart_item *item );
  virtual struct chart_item * ItemOfName( char *item_name )				 ;



  inline struct chart_item * ItemAnchor()			      { return (this->item_anchor); }
  inline long ItemCount()			      { return (this->item_count); }

  inline long ItemValueGreatest()		      { return (this->item_value_greatest); }
  inline long ItemValueLeast()		      { return (this->item_value_least); }
  inline long ItemValueRangeHigh()		      { return (this->item_value_range_high); }
  inline long ItemValueRangeInterval()	      { return (this->item_value_range_interval); }
  inline long ItemValueRangeLow()		      { return (this->item_value_range_low); }
  inline long ItemValueSpan()		      { return (this->item_value_span); }
  inline char * ItemFontName()		      { return (this->item_font_name); }

  inline struct chart_item * NextItem( struct chart_item *item)		      { return ((item)->next); }



  
	chart();
  
	virtual ~chart();
  static class chart * Create( chart_Specification *chart_Spec, char *anchor )		 ;



  char				     *chart_moniker, *chart_title,
				     *chart_title_data_object_name, *chart_title_view_object_name;
  class dataobject		     *client_anchor;
  long				      client_datum, item_count;
  struct chart_item		     *item_anchor;
  long				      id;
  char				     *chart_file_name, *item_font_name;
  long				      item_value_greatest, item_value_least,
				      item_value_range_low, item_value_range_high,
				      item_value_range_interval, item_value_span;
  struct chart_monikers		     *chart_monikers;
  long				      exception_code;
  struct chart_item		     *exception_item;
  };

/***  Exception Codes  ***/
#define  chart_NonExistentItem			1
#define  chart_UnknownChartAttribute		2
#define  chart_UnknownItemAttribute		3

/***  Notification Codes  ***/
#define  chart_ItemCreated			1
#define  chart_ItemDestroyed			2
#define  chart_ItemValueChanged			3
#define  chart_ItemNameChanged			4
#define  chart_ItemCaptionChanged		5
#define  chart_ItemsSorted			6
#define  chart_EnclosureModified		7


/***  Chart Attribute Values  ***/

/***  Chart Sort Fields  ***/
#define  chart_ByValue			    (1<<0)
#define  chart_ByLabel			    (1<<1)
#define  chart_ByPosition		    (1<<2)

/***  Chart Sort Order	***/
#define  chart_Ascend			    (1<<8)
#define  chart_Descend			    (1<<9)

/***  Attribute Macros  ***/

#define  chart_Datum(x)			    chart_datum,	    (long) x
#define  chart_FileName(x)		    chart_filename,	    (long) x
#define  chart_ItemDatum(x)		    chart_itemdatum,	    (long) x
#define  chart_ItemName(x)		    chart_itemname,	    (long) x
#define  chart_ItemPosition(x)		    chart_itemposition,	    (long) x
#define  chart_ItemValue(x)		    chart_itemvalue,	    (long) x
#define  chart_TitleCaption(x)		    chart_titlecaption,	    (long) x
#define  chart_TitleDataObjectName(x)	    chart_titledataobjectname,	(long) x
#define  chart_TitleViewObjectName(x)	    chart_titleviewobjectname,	(long) x
#define  chart_Type(x)			    chart_type,		    (long) x

/***  Attribute Codes  ***/

#define  chart_datum	    		    5
#define  chart_filename			    6

#define  chart_itemdatum		    12
#define  chart_itemname			    14
#define  chart_itemposition		    15
#define  chart_itemvalue		    16

#define  chart_titlecaption		    33
#define  chart_titledataobjectname	    35
#define  chart_titleviewobjectname	    38

#define  chart_type			    40


/**  SPECIFICATION -- External Facility Suite  *********************************

TITLE	The Chart View Internal Symbolics

MODULE	chart.h

VERSION	0.0

AUTHOR	TC Peters
	Information Technology Center, Carnegie-Mellon University 

DESCRIPTION
	Symbolics for Chart View & Palette

    NB: The comment-symbol "===" indicates areas which are:
	    1 - Questionable
	    OR
	    2 - Arbitrary
	    OR
	    3 - Temporary Hacks
    Such curiosities need be resolved prior to Project Completion...


HISTORY
  08/28/89	Created (TCP)

END-SPECIFICATION  ************************************************************/

#define  menu_default		  (1<<0)
#define  menu_application	  (1<<1)
#define  menu_applicationlayer	  (1<<2)
#define  menu_palette_hidden	  (1<<3)
#define  menu_palette_exposed	  (1<<4)

struct chartv_instance
  {
  struct chart		     *data_object;
  struct chartobj	     *data_viewer;
  struct suite	/*===*/	     *form_object, *sort_palette_object;
  struct suite		     *control_suite_object, *sort_position_suite_object,
			     *sort_value_suite_object, *sort_label_suite_object,
			     *type_suite_object, *title_suite_object;
  struct im		     *im_view_object;
  struct frame		     *frame_view_object;
  struct text		     *description_text;
  struct textview	     *description_textview;
  struct view		     *description_textview_scroll;
  struct lpair		     *pair_view;
  struct view		     *client_anchor;
  struct fontdesc	     *title_font, *item_font, *label_font, *scale_font;
  struct keystate	     *keystate;
  struct rectangle	      bounds, control_bounds, pair_bounds;
  struct menulist	     *menu;
  struct view		    *(*hit_handler)(), (*title_hit_handler)(),
			     (*title_data_object_handler)(),
			     (*title_view_object_handler)();
  struct chart_item	     *current_item;
  long			      client_datum, last_modified, description_last_modified;
  char			      arrangement, background_shade, chart_cursor_byte,
			     *title_font_name, *label_font_name, *scale_font_name,
  			     *chart_cursor_font_name, *item_font_name,
			      item_border_style, item_border_size, item_highlight_style,
			      border_style, border_size,
			      title_border_style, title_border_size,
			      title_highlight_style, title_placement, title_alignment,
			      visual_orientation;
  boolean		      initialized, form_initialized,
			      expose_form, form_exposed,
			      input_focus, description_exposed,
			      read_only, ignore_fullupdate, ignore_loseinputfocus,
			      application, application_layer;
  };

#define  DeletePhrase		"Delete"
#define  SavePhrase		"Save"
#define  AscendPhrase		"Ascend"
#define  DescendPhrase		"Descend"
#define  PrintPhrase		"Print"
#define  TopPhrase		"Top"
#define  BottomPhrase		"Bottom"
#define  LeftPhrase		"Left"
#define  RightPhrase		"Right"
#define  TitlesPhrase		"Titles"

#define  TitleFontNamePhrase	"andysans12b"
#define  ItemCaptionFontNamePhrase "andysans10b"

#define  Menu			  (self->instance->menu)

#define  Keystate		  (self->instance->keystate)
#define  BOUNDS			  (&self->instance->bounds)
#define  Left			  (self->instance->bounds.left)
#define  Top			  (self->instance->bounds.top)
#define  Width			  (self->instance->bounds.width)
#define  Height			  (self->instance->bounds.height)

#define  PairBounds		  (&self->instance->pair_bounds)
#define  ControlBounds		  (&self->instance->control_bounds)

#define  Chart			  (self->instance->data_object)
#define  ChartViewer		  (self->instance->data_viewer)
#define  PairView		  (self->instance->pair_view)

#define  Arrangement		  (self->instance->arrangement)
#define  BorderStyle		  (self->instance->border_style)
#define  BorderSize		  (self->instance->border_size)
#define  TitleBorderStyle	  (self->instance->title_border_style)
#define  TitleBorderSize	  (self->instance->title_border_size)
#define  TitleFontName		  (self->instance->title_font_name)
#define  TitleHighlightStyle	  (self->instance->title_highlight_style)
#define  TitlePlacement		  (self->instance->title_placement)
#define  TitleAlignment		  (self->instance->title_alignment)
#define  TitleHitHandler	  (self->instance->title_hit_handler)
#define  TitleDataObjectHandler	  (self->instance->title_data_object_handler)
#define  TitleViewObjectHandler	  (self->instance->title_view_object_handler)
#define  ClientAnchor		  (self->instance->client_anchor)
#define  ClientDatum		  (self->instance->client_datum)
#define  HitHandler		  (self->instance->hit_handler)
#define  ItemBorderStyle	  (self->instance->item_border_style)
#define  ItemBorderSize		  (self->instance->item_border_size)
#define  ItemHighlightStyle	  (self->instance->item_highlight_style)
#define  ITEMFONTNAME		  (self->instance->item_font_name)
#define  ItemFont		  (self->instance->item_font)
#define  CURRENTITEM		  (self->instance->current_item)
#define  LabelFontName		  (self->instance->label_font_name)
#define  ScaleFontName		  (self->instance->scale_font_name)

#define  ChartCursor		  (self->instance->chart_cursor)
#define  ChartCursorByte	  (self->instance->chart_cursor_byte)
#define  ChartCursorFont	  (self->instance->chart_cursor_font)
#define  ChartCursorFontName	  (self->instance->chart_cursor_font_name)

#define  VisualOrientation	(self->instance->visual_orientation)
#define  VisualOrientationBU	(0)
#define  VisualOrientationTD	(1)
#define  VisualOrientationLR	(2)
#define  VisualOrientationRL	(3)

#define  BackgroundShade	  (self->instance->background_shade)
#define  BackgroundPattern	  (self->instance->background_pattern)
#define  BackgroundWhite	  (self->instance->background_shade == 1)
#define  BackgroundNonWhite	  (self->instance->background_shade != 1)

#define  Initialized		  (self->instance->initialized)
#define  PaletteInitialized	  (self->instance->form_initialized)
#define  IgnoreFullUpdate	  (self->instance->ignore_fullupdate)
#define  IgnoreLoseInputFocus	  (self->instance->ignore_loseinputfocus)

#define  InputFocus		  (self->instance->input_focus)
#define  ExposePalette		  (self->instance->expose_form)
#define  PaletteExposed		  (self->instance->form_exposed)
#define  ControlSuite		  (self->instance->control_suite_object)
#define  SortValueSuite		  (self->instance->sort_value_suite_object)
#define  SortLabelSuite		  (self->instance->sort_label_suite_object)
#define  SortPositionSuite	  (self->instance->sort_position_suite_object)
#define  TypeSuite		  (self->instance->type_suite_object)
#define  TitleSuite		  (self->instance->title_suite_object)
#define  Palette		  (self->instance->form_object)/*===*/
#define  SortForm		  (self->instance->sort_palette_object)/*===*/
#define  PaletteIm		  (self->instance->im_view_object)
#define  PaletteFrame		  (self->instance->frame_view_object)
#define  Application		  (self->instance->application)
#define  ApplicationLayer	  (self->instance->application_layer)
#define  Description		  (self->instance->description_text)
#define  DescriptionView	  (self->instance->description_textview)
#define  DescriptionViewScroll	  (self->instance->description_textview_scroll)
#define  DescriptionExposed	  (self->instance->description_exposed)

#define  ReadOnly		  (self->instance->read_only)
#define  LastModified		  (self->instance->last_modified)
#define  DescriptionLastModified  (self->instance->description_last_modified)

static char			  temp_name[] = "/tmp/org_temp";

#endif /* _chart_H_ */
