/* Copyright 1993 Carnegie Mellon University All rights reserved.
  $Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/
#ifndef ATKOS_H
#define ATKOS_H 1

#include <stdio.h> /* needed so that we can declare Andrew_tmpfile. */

#ifdef ATK_IN_RELATIVIZE
extern void ATKUseExportsFiles(char *arg, char *dot, char *slash);
extern void ATKMinimizeLibs(char *arg, char *dot, char *slash);
#endif

BEGINCPLUSPLUSPROTOS
#ifdef NEED_SCANDIR
int scandir(const char *dir, struct dirent ***namelist,
              int (*select)(const struct dirent *),
              int (*compar)(const struct dirent **, const struct dirent **));
int alphasort(const struct dirent **a, const struct dirent **b);
#endif

#ifdef NEED_ATKINIFINI
extern void ATK_DoIniFini();
#endif

#ifdef NEED_ANSI_TMPFILES
extern char *Andrew_tmpnam();
extern FILE *Andrew_tmpfile();

#define tmpnam(buf) Andrew_tmpnam(buf)
#define tmpfile() Andrew_tmpfile()

/* the following #defines may be overridden in the system.h file */
#ifndef P_tmpdir
#define P_tmpdir "/tmp/"
#endif
#ifndef L_tmpnam
#define L_tmpnam (sizeof(P_tmpdir)+15)
#endif
#ifndef TMP_MAX
#define TMP_MAX 52 /* maybe this should be larger, this is a conservative guess. */
#endif
#endif /* NEED_ANSI_TMPFILES */

#ifdef NEED_LOCKF
extern int Andrew_lockf(int fid);
extern int Andrew_unlockf(int fid);
#undef osi_ExclusiveLockNoBlock
#define osi_ExclusiveLockNoBlock(fid) Andrew_lockf(fid)
#undef osi_UnLock
#define osi_UnLock(fid) Andrew_unlockf(fid)
#endif
ENDCPLUSPLUSPROTOS
#endif /* ATKOS_H */
