ATK_INTER
#ifndef _view_H_
#define _view_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 


#define view_VERSION 1

enum view_UpdateType  {
    view_FullRedraw,
    view_PartialRedraw,
    view_LastPartialRedraw,
    view_MoveNoRedraw,
    view_Remove
};

enum view_MouseAction  {
    view_NoMouseEvent,
    view_LeftDown,
    view_LeftUp,
    view_LeftMovement,
    view_RightDown,
    view_RightUp,
    view_RightMovement,
    /* File drop actions are only available for DRAGDROP_ENV */
    view_LeftFileDrop,
    view_MiddleFileDrop,
    view_RightFileDrop
};

enum view_DSpass {
    view_NoSet,
    view_WidthSet,
    view_HeightSet
};

enum view_Traversal {
    view_NextView,
    view_PrevView,
    view_NextGroup,
    view_PrevGroup
};



typedef int view_DSattributes;

#define view_Fixed 0
#define view_WidthLarger 1
#define view_WidthSmaller 2
#define view_WidthFlexible 3
#define view_HeightLarger 4
#define view_HeightSmaller 8
#define view_HeightFlexible 12

#define view_NOMOVEMENT			    0
#define view_ATLEFT			    1
#define view_ATRIGHT			    2
#define view_BETWEENLEFTANDRIGHT	    4
#define view_ATTOP			  010
#define view_ATBOTTOM			  020
#define view_ATBASELINE			  040
#define view_BETWEENTOPANDBOTTOM	 0100
#define view_BETWEENTOPANDBASELINE	 0200

/* Error codes for the description procedure */
enum view_DescriberErrs {
    view_NoDescribeError,
    view_NoDescriptionAvailable,
    view_NoDescribeString,
    view_NoDescribeObject,
    view_WrongSubclassDescription
};

#include <atom.H>
#include <graphic.H>
#include <observable.H>
#include <color.H>

struct view_printopt {
    class atom *name, *type;
    char *label;
};
struct view_printoptlist {
    struct view_printopt *list; /* array of structures */
    int numoptions; /* size of list */
    struct view_printoptlist *parent; 
};
// Sigh, ScrollInterface isn't actually defined until supportviews...
class ScrollInterface;
class view : public  observable {
public:
	virtual ATKregistryEntry *ATKregistry();


     void ObservedChanged (class observable *changed, long value);

    virtual void SetName( class atomlist * name );
    virtual class atomlist * GetName()  ;
    virtual class atomlist * GetClass()  ;
    virtual short GetParameter( class atomlist * name, class atom * type, long * datum )
       ;
    virtual short GetResource( class atomlist * name, class atomlist * class_c,
		class atom * type, long * datum )  ;
    virtual void GetManyParameters( struct resourceList * resources,
		      class atomlist * name,
		      class atomlist * class_c );		      
    virtual void PostResource( class atomlist * path, class atom * type,
		 long datum );
    virtual void InsertViewRegion(class view *parent, class region *region);
    virtual void InsertView(class view * parent, struct rectangle * enclosingRect);
    virtual void InsertViewSize(class view * EnclosingView, long xOriginInParent, long yOriginInParent, long width, long height);
    virtual void SetDataObject(class dataobject *dataobject);
    virtual class view * GetApplicationLayer()  ;
    virtual void DeleteApplicationLayer(class view *applicationLayer);
    virtual char * DescriptionObject(char * format, long rock)  ;
    virtual enum view_DescriberErrs Describe(char * format, FILE * file, long rock)  ;
    virtual void FullUpdate(enum view_UpdateType type, long left, long top, long width, long right);
    virtual void Update();
    virtual void Print(FILE *file, char *processor, char *finalFormat, boolean topLevel);
    virtual class view * Hit (enum view_MouseAction action, long x, long y, long numberOfClicks)  ;
    virtual view_DSattributes DesiredSize(long width, long height, enum view_DSpass pass, long *dWidth, long *dheight)  ;
    virtual void GetOrigin(long width, long height, long *originX, long *originY);
    virtual void ReceiveInputFocus();
    virtual void LoseInputFocus();
    virtual void ReceiveColormap(class colormap *cmap);
    virtual void LoseColormap(class colormap *cmap);
    virtual void WantUpdate(class view *requestor);
    virtual void WantInputFocus(class view *requestor);
    virtual void WantColormap(class view *requestor, class colormap **cmap);
    virtual void WantNewSize(class view *requestor);
    virtual ATK  * WantHandler(char *handlerName)  ;
    virtual char * WantInformation(char *key)  ;
    virtual void PostKeyState(class keystate *keystate);
    virtual void PostMenus(class menulist *menulist);
    virtual void PostCursor(struct rectangle *rec,class cursor *cursor) ;
    virtual void RetractCursor(class cursor *cursor) ;
    virtual void RetractViewCursors(class view *requestor);
    virtual void PostDefaultHandler(char *handlerName, ATK  *handler);
    virtual char * GetInterface(char *type);
/* View linking/unlinking functions. */
    virtual void LinkTree(class view *parent);
    virtual void UnlinkTree();
    virtual boolean IsAncestor(class view *possibleAncestor);
    virtual void UnlinkNotification(class view *unlinkedTree);
    virtual void ExposeSelf(boolean recurse);
    virtual void ExposeChild(class view *v);

    virtual char * GetWindowManagerType()  ;
    virtual long GetDevice()  ;
    virtual void InitChildren();
    virtual boolean CanView(char *TypeName)  ;

/* Support for selections ala X */
    virtual void LoseSelectionOwnership();
    virtual long WriteSelection(FILE *out);

    virtual boolean RecSearch(struct SearchPattern *pat, boolean toplevel);
    virtual boolean RecSrchResume(struct SearchPattern *pat);
    virtual boolean RecSrchReplace(class dataobject *text, long pos, long len);
    virtual void RecSrchExpose(const struct rectangle &logical, struct rectangle &hit);
    
    virtual void PrintPSDoc(FILE *outfile, long pagew, long pageh);
    virtual void *GetPSPrintInterface(char *printtype);
    virtual void DesiredPrintSize(long width, long height, enum view_DSpass pass, long *desiredwidth, long *desiredheight);
    virtual void PrintPSRect(FILE *outfile, long logwidth, long logheight, struct rectangle *visrect);

    virtual struct view_printoptlist *PrintOptions();
    virtual long GetPrintOption(class atom *popt);
    virtual void SetPrintOption(struct view_printopt *vopt, long value);
    virtual boolean AcceptingFocus();
    virtual void ChildLosingInputFocus();
    virtual void ChildReceivingInputFocus();
    virtual void Traverse(enum view_Traversal trav);
    virtual void WantExposure(class view *requestor, struct rectangle *childrect);
    // GetScrollInterface will create an appropriate object of
    // a class derived from ScrollInterface.  The caller is responsible
    // for destroying the interface.  NULL is returned if there
    // is no appropriate interface.
    virtual class ScrollInterface *GetScrollInterface();
    
    inline void MoveToPt(struct point * Pt) { (((this)->drawable)->MoveToPt((Pt))); }
    inline void MoveTo(long NewX,long NewY) { (((this)->drawable)->MoveTo((NewX),(NewY))); }
    inline void Move(long DeltaX, long DeltaY) { (((this)->drawable)->Move((DeltaX),(DeltaY))); }

    inline void GetLogicalBounds(struct rectangle * Rect) { (((this)->drawable)->GetLogicalBounds((Rect))); }
    inline long GetLogicalRight() { return (((this)->drawable)->GetLogicalRight()); }
    inline long GetLogicalBottom() { return (((this)->drawable)->GetLogicalBottom()); }
    inline long GetLogicalLeft() { return (((this)->drawable)->GetLogicalLeft()); }
    inline long GetLogicalHeight() { return ((((this)->drawable))->GetLogicalHeight()); }
    inline long GetLogicalWidth() { return ((((this)->drawable))->GetLogicalWidth()); }
    inline long GetLogicalTop() { return ((((this)->drawable))->GetLogicalTop()); }

    inline void SetVisualRegion(class region * region) { (((this)->drawable)->SetVisualRegion( (region))); }
    inline class region * GetVisualRegion(/* MAYBE MISSING */ class region * region) { return (((this)->drawable)->GetVisualRegion( (region))); }
    inline void GetVisualBounds(struct rectangle * Rect) { (((this)->drawable)->GetVisualBounds((Rect))); }
    inline long GetVisualRight() { return (((this)->drawable)->GetVisualRight()); }
    inline long GetVisualBottom() { return (((this)->drawable)->GetVisualBottom()); }
    inline long GetVisualWidth() { return ((((this)->drawable))->GetVisualWidth()); }
    inline long GetVisualHeight() { return ((((this)->drawable))->GetVisualHeight()); }
    inline long GetVisualLeft() { return ((((this)->drawable))->GetVisualLeft()); }
    inline long GetVisualTop() { return ((((this)->drawable))->GetVisualTop()); }


    inline void GetEnclosedBounds(struct rectangle * Rect) { (((this)->drawable)->GetEnclosedBounds( (Rect))); }
    inline long GetEnclosedRight() { return (((this)->drawable)->GetEnclosedRight()); }
    inline long GetEnclosedBottom() { return (((this)->drawable)->GetEnclosedBottom()); }
    inline long GetEnclosedLeft() { return ((((this)->drawable))->GetEnclosedLeft()); }
    inline long GetEnclosedTop() { return ((((this)->drawable))->GetEnclosedTop()); }
    inline long GetEnclosedWidth() { return ((((this)->drawable))->GetEnclosedWidth()); }
    inline long GetEnclosedHeight() { return ((((this)->drawable))->GetEnclosedHeight()); }

    inline void GetCurrentPt(struct point * Pt) { (((this)->drawable)->GetCurrentPt((Pt))); }

    inline void DrawLineToPt(struct point * LineEnd) { (((this)->drawable)->DrawLineToPt((LineEnd))); }
    inline void DrawLineTo(long XEnd, long YEnd) { (((this)->drawable)->DrawLineTo((XEnd), (YEnd))); }
    inline void DrawLine(long DeltaX, long DeltaY) { (((this)->drawable)->DrawLine( (DeltaX), (DeltaY))); }

    inline void DrawString(char * Text, short Operation) { (((this)->drawable)->DrawString( (Text), (Operation))); }
    inline void DrawText(char * Text, long TextLength, short Operation) { (((this)->drawable)->DrawText( (Text), (TextLength), (Operation))); }
    inline void SetSpaceShim(short Amount) { (((this)->drawable)->SetSpaceShim((Amount))); }
    inline short GetSpaceShim() { return (((this)->drawable)->GetSpaceShim()); }
    inline void SetFont(class fontdesc * ChosenFont) { (((this)->drawable)->SetFont( (ChosenFont))); }
    inline class fontdesc * GetFont() { return (((this)->drawable)->GetFont()); }

    inline void DrawRect(struct rectangle * Rect) { (((this)->drawable)->DrawRect((Rect))); }
    inline void DrawRectSize(long x,long y,long width,long height) { (((this)->drawable)->DrawRectSize((x),(y),(width),(height))); }
    inline void DrawTrapezoid(long topX, long topY, long topWidth, long bottomX, long bottomY, long bottomWidth) { (((this)->drawable)->DrawTrapezoid((topX),(topY),(topWidth),(bottomX),(bottomY),(bottomWidth))); }
    inline void DrawPolygon(struct point * PointArray, short PointCount) { (((this)->drawable)->DrawPolygon((PointArray), (PointCount))); }
    inline void DrawPath(struct point * PointArray, short PointCount) { (((this)->drawable)->DrawPath((PointArray), (PointCount))); }
    inline void DrawOval(struct rectangle * Rect) { (((this)->drawable)->DrawOval((Rect))); }
    inline void DrawOvalSize(long x,long y,long width,long height) { (((this)->drawable)->DrawOvalSize( (x), (y), (width), (height))); }
    inline void DrawArc(struct rectangle * EnclRect, short StartAngle, short OffsetAngle) { (((this)->drawable)->DrawArc((EnclRect),(StartAngle),(OffsetAngle))); }
    inline void DrawArcSize(long x,long y,long width,long height, short StartAngle, short OffsetAngle) { (((this)->drawable)->DrawArcSize( (x), (y), (width), (height), (StartAngle), (OffsetAngle))); }
    inline void DrawRRect(struct rectangle * OuterBox, struct rectangle * InnerBox) { (((this)->drawable)->DrawRRect( (OuterBox), (InnerBox))); }
    inline void DrawRRectSize(long x,long y,long width,long height, long cornerWidth,long cornerHeight) { (((this)->drawable)->DrawRRectSize( (x), (y), (width), (height), (cornerWidth), (cornerHeight))); }
    inline void DrawRgn(class region * Rgn) { (((this)->drawable)->DrawRgn((Rgn))); }

    inline void FillRect(struct rectangle * Rect, class graphic * Tile) { (((this)->drawable)->FillRect( (Rect),(Tile))); }
    inline void FillRectSize(long x,long y,long width,long height, class graphic * Tile) { (((this)->drawable)->FillRectSize( (x), (y), (width), (height), (Tile))); }
    inline void FillTrapezoid(long topX, long topY, long topWidth, long bottomX, long bottomY, long bottomWidth, class graphic * Tile) { (((this)->drawable)->FillTrapezoid( (topX), (topY), (topWidth), (bottomX), (bottomY), (bottomWidth), (Tile))); }
    inline void FillPolygon(struct point * PointArray, short PointCount, class graphic * Tile) { (((this)->drawable)->FillPolygon( (PointArray), (PointCount), (Tile))); }
    inline void FillOval(struct rectangle * Rect, class graphic * Tile) { (((this)->drawable)->FillOval( (Rect), (Tile))); }
    inline void FillOvalSize(long x,long y,long width,long height, class graphic * Tile) { (((this)->drawable)->FillOvalSize( (x), (y), (width), (height), (Tile))); }
    inline void FillArc(struct rectangle * EnclRect, short StartAngle, short OffsetAngle, class graphic * Tile) { (((this)->drawable)->FillArc( (EnclRect), (StartAngle), (OffsetAngle),(Tile))); }
    inline void FillArcSize(long x,long y,long width,long height, short StartAngle, short OffsetAngle, class graphic * Tile) { (((this)->drawable)->FillArcSize( (x), (y), (width), (height), (StartAngle), (OffsetAngle), (Tile))); }
    inline void FillRRect(struct rectangle * OuterBox, struct rectangle * InnerBox, class graphic * Tile) { (((this)->drawable)->FillRRect( (OuterBox), (InnerBox), (Tile))); }
    inline void FillRRectSize(long x, long y, long width, long height, long cornerWidth, long cornerHeight, class graphic * Tile) { (((this)->drawable)->FillRRectSize( (x), (y), (width), (height), (cornerWidth), (cornerHeight), (Tile))); }
    inline void FillRgn(class region * Rgn, class graphic * Tile) { (((this)->drawable)->FillRgn( (Rgn), (Tile))); }

    inline void EraseRect(struct rectangle * Rect) { (((this)->drawable)->EraseRect( (Rect))); }
    inline void EraseRectSize(long x,long y,long width,long height) { (((this)->drawable)->EraseRectSize( (x), (y), (width), (height))); }
    inline void EraseVisualRect() { (((this)->drawable)->EraseVisualRect()); }

    inline void BitBlt(struct rectangle * SrcRect, /* MAYBE MISSING */ class view * DestView, struct point * DstOrigin, struct rectangle * ClipRectList) { (((this)->drawable)->BitBlt((SrcRect), (((class view *)(DestView))->drawable), (DstOrigin), (ClipRectList))); }
    inline void BitBltSize(long srcX, long srcY, long dstX, long dstY, long Width, long Height, /* MAYBE MISSING */ class view * DstView, long clipX, long clipY, long clipWidth, long clipHeight) { (((this)->drawable)->BitBltSize( (srcX), (srcY), (dstX), (dstY), (Width),(Height), (((class view*)(DstView))->drawable), (clipX),(clipY), (clipWidth), (clipHeight))); }
    inline void SetBitAtLoc(long XPos, long YPos, boolean NewValue) { (((this)->drawable)->SetBitAtLoc( (XPos), (YPos), (NewValue))); }

    inline void WritePixImage(long DestX, long DestY, 
			      class pixelimage *SrcPixels, long SrcX, long SrcY, 
			      long width, long height) {
	drawable->WritePixImage(DestX, DestY, SrcPixels, SrcX, SrcY, width, height);
    }
    inline void ReadPixImage(long SrcX, long SrcY, 
			     class pixelimage *DestPixels, long DestX, long DestY, 
			     long width, long height) {
	drawable->ReadPixImage(SrcX, SrcY, DestPixels, DestX, DestY, width, height);
    }
    inline void ReadImage(long SrcX, long SrcY, 
			  class image *DestImage, long DestX, long DestY, 
			  long width, long height) {
	drawable->ReadImage(SrcX, SrcY, DestImage, DestX, DestY, width, height);
    }
    inline void WriteImage(long DestX, long DestY, 
			   ddimage &SrcImage, long SrcX, long SrcY, 
			   long width, long height) {
	drawable->WriteImage(DestX, DestY, SrcImage, SrcX, SrcY, width, height);
    }

    inline void MoveLogicalOrigin(long DeltaX, long DeltaY) { (((this)->drawable)->MoveLogicalOrigin((DeltaX), (DeltaY))); }
    inline void SetLogicalOrigin(long NewX, long NewY) { (((this)->drawable)->SetLogicalOrigin((NewX), (NewY))); }
    inline void SetLogicalOriginPt(struct point * Pt) { (((this)->drawable)->SetLogicalOriginPt((Pt))); }


    inline void SetClippingRegion(class region * region) { (((this)->drawable)->SetClippingRegion( (region))); }
    inline class region * GetClippingRegion(/* MAYBE MISSING */ class region * region) { return (((this)->drawable)->GetClippingRegion( (region))); }
    inline void SetClippingRect(/* MAYBE MISSING */ struct rectangle * ClipRect) { (((this)->drawable)->SetClippingRect((ClipRect))); }
    inline void SetClippingRectSize(long x, long y, /* MAYBE MISSING */ long width, /* MAYBE MISSING */ long height) { (((this)->drawable)->SetClippingRectSize((x),(y),(width),(height))); }
    inline void ClearClippingRect() { (((this)->drawable)->ClearClippingRect()); }
    inline void GetClippingRect(struct rectangle * Rect) { (((this)->drawable)->GetClippingRect((Rect))); }
 /*  This doesn't actually exist in graphic... -rr2b GetClippingRectSize(retx, rety, retwidth, retheight) (graphic_GetClippingRectSize((self)->drawable,(retx), (rety), (retwidth), (retheight)))
*/
    inline void SetLineWidth(short NewLineWidth) { (((this)->drawable)->SetLineWidth( (NewLineWidth))); }
    inline short GetLineWidth() { return (((this)->drawable)->GetLineWidth()); }

    inline void SetLineDash( char * dashPattern, int dashOffset, short dashType) { (((this)->drawable)->SetLineDash( (dashPattern), (dashOffset), (dashType))); }
    inline void GetLineDash( char * * dashPattern, int * dashOffset, short * dashType) { (((this)->drawable)->GetLineDash( (dashPattern), (dashOffset), (dashType))); }

    inline void SetLineCap(short NewLineCap) { (((this)->drawable)->SetLineCap( (NewLineCap))); }
    inline short GetLineCap() { return (((this)->drawable)->GetLineCap()); }

    inline void SetLineJoin(short NewLineJoin) { (((this)->drawable)->SetLineJoin( (NewLineJoin))); }
    inline short GetLineJoin() { return (((this)->drawable)->GetLineJoin()); }

    inline void SetTransferMode(short NewTransferMode) { (((this)->drawable)->SetTransferMode( (NewTransferMode))); }
    inline short GetTransferMode() { return (((this)->drawable)->GetTransferMode()); }

    inline void FlushGraphics() { (((this)->drawable)->FlushGraphics()); }

    inline class graphic * WhitePattern() { return (((this)->drawable)->WhitePattern()); }
    inline class graphic * BlackPattern() { return (((this)->drawable)->BlackPattern()); }
    inline class graphic * GrayPattern(short IntensityNum, short IntensityDenom) { return (((this)->drawable)->GrayPattern( (IntensityNum), (IntensityDenom))); }
    inline void SetPatternOrigin(long xpos, long ypos)  {
	(((this)->drawable)->SetPatternOrigin( (xpos), (ypos))); }
    inline void GetPatternOrigin(long *xpos, long *ypos)  {
	(((this)->drawable)->GetPatternOrigin( (xpos), (ypos))); }
    inline void SetForegroundColor(color *c) { drawable->SetForegroundColor(c); }
    inline void SetBackgroundColor(color *c) {
	drawable->SetBackgroundColor(c); }
  inline void SetForegroundColor(char *colorName, long red, long green, long blue) { (((this)->drawable)->SetForegroundColor( (colorName), (red), (green), (blue))); }
  inline void GetForegroundColor(/* MAYBE MISSING */ char * * name, /* MAYBE MISSING */ long * retred, /* MAYBE MISSING */ long * retgreen, /* MAYBE MISSING */ long * retblue)     { (((this)->drawable)->GetForegroundColor( (name), (retred), (retgreen), (retblue))); }
 inline void SetBackgroundColor(char *colorName, long red, long green, long blue) { (((this)->drawable)->SetBackgroundColor( (colorName), (red),(green),(blue))); }
 inline void GetBackgroundColor(/* MAYBE MISSING */ char * * name, /* MAYBE MISSING */ long * retred, /* MAYBE MISSING */ long * retgreen, /* MAYBE MISSING */ long * retblue) { (((this)->drawable)->GetBackgroundColor( (name), (retred), (retgreen),(retblue))); }

    inline void SetFGColorCell(class color *color) {  (((this)->drawable)->SetFGColorCell( color)); }
    inline void SetBGColorCell(class color *color) {  (((this)->drawable)->SetBGColorCell( color)); }

    inline void SetFGColor(double red, double green, double blue) { (((this)->drawable)->SetFGColor((red),(green),(blue))); }
    inline void GetFGColor(double * red, double * green, double * blue) { (((this)->drawable)->GetFGColor((red),(green),(blue))); }
    inline void SetBGColor(double red, double green, double blue) { (((this)->drawable)->SetBGColor((red),(green),(blue))); }
    inline void GetBGColor(double * red, double * green, double * blue) { (((this)->drawable)->GetBGColor((red),(green),(blue))); }

    inline long GetHorizontalResolution() { return (((this)->drawable)->GetHorizontalResolution()); }
    inline long GetVerticalResolution() { return (((this)->drawable)->GetVerticalResolution()); }

    inline class im * GetIM() { return ((this)->imPtr); }
    inline class graphic * GetDrawable() { return ((this)->drawable); }

    inline class colormap **GetColormap() { return (((this)->drawable)->GetColormap()); }
    inline void SetColormap(class colormap **cmap) {
	(((this)->drawable)->SetColormap( cmap)); }
    inline class colormap **GetInheritedColormap() { return (((this)->drawable)->GetInheritedColormap()); }
    inline void SetInheritedColormap(class colormap **cmap) {(((this)->drawable)->SetInheritedColormap( cmap)); }
    inline void ClearInheritedColormap() {  (((this)->drawable)->ClearInheritedColormap()); }
    inline class colormap **CurrentColormap() { return (((this)->drawable)->CurrentColormap()); }

    inline long  EnclosedXToLocalX(long xvalue)   { return ((xvalue)-((this)->drawable)->GetEnclosedLeft()+((this)->drawable)->GetLogicalLeft()); }
    inline long  EnclosedYToLocalY(long yvalue)    { return ((yvalue)-((this)->drawable)->GetEnclosedTop()+((this)->drawable)->GetLogicalTop()); }

    inline class dataobject * GetDataObject() { return ((this)->dataobject); }
    inline long DisplayClass() { return (((this)->drawable )->DisplayClass()); }



    
	static boolean InitializeClass();

    
	virtual ~view();
    
	view();



    class atomlist * name;
    class atomlist * className;
    short  name_explicitly_set;
    class im *imPtr;
    class view *parent;
    class dataobject *dataobject;
    class graphic * drawable;
};

#endif /* _view_H_ */
