ATK_INTER
#ifndef _environ_H_
#define _environ_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/* environ.H
 * Class declarations for environment and preference maodule.
 *
 */

#include <ATK.H>
#define environ environclass
class environ : public ATK  {
public:
	virtual ATKregistryEntry *ATKregistry();

	static void PutPrinter(char *value);
	static char *GetPrinter();
	static void DeletePrinter();
        static void Put(char *variable, char *value);
        static void Delete(char *variable);
        static char * Get(char *variable)  ;
        static char * GetProfile(char *preference)  ;
        static boolean GetProfileSwitch(char *preference, boolean defaultValue)  ;
	static long GetProfileInt(char *preference, long defaultValue)  ;
	static boolean ProfileEntryExists(char *preference, boolean useDefault)  ;
	static char * GetConfiguration(char *key)  ;
	static char * AndrewDir(char *str)  ;
	static char * LocalDir(char *str)  ;
	static struct configurelist * ReadConfigureFile(char *filename)  ;
	static char * GetConfig(struct configurelist *cList, char *key, boolean usedefault)  ;
	static void FreeConfigureList(struct configurelist *cList);
	static char * GetHome(char *user)  ;  /* pass in NULL for current user */
	static void SetProgramName(char *string);	    /* for use by the GetProfile stuff */
	static char * GetFirstProfileFileName()  ;
	static char * GetProfileFileName()  ;
	static void AddStringProfile(const char *str);  /* Add a preference to the running environment. */
	static void ExpandEnvVars(char *to, const char *from, int maxsize);
};

#endif /* _environ_H_ */
