\begindata{text,4760576}
\textdsversion{12}
\template{default}
-- Ness test suite



-- simple function definition and call

-- passing string to builtin

--

void

function hello()

	print ("hello world \\n");

end function;



void 

function checkstring(where, expect, got)

	if expect /= got then

		printline("checkstring FAILURE in " ~ where

			~ ".  Expected " ~ expect ~ " and got " ~ got)

	end if

end function


void

function checkinteger(where, integer expect, integer got)

	if expect /= got then

		printline("checkinteger FAILURE in " ~ where

			~ ".  Expected " ~ textimage(expect) 

			~ " and got "  ~ textimage(got))

	end if

end function


void

function realfailure(subseq where, real expect, real got)

	printline("checkreal FAILURE in " ~ where 

		~ ".  Expected " ~ textimage(expect) 

		~ " and got "  ~ textimage(got))

end function

-- a value for expect of -999.0 means that the expected value is NaN

void

function checkreal(where, real expect, real got)

	real EPSILON := .0001

	-- for some reason, smaller values of EPSILON claim that

	-- some correct results are incorrect


	if expect = -999.0 or (realIEEE and isnan(got)) then

		if expect /= -999.0 or (realIEEE and not isnan(got)) then

			realfailure(where ~ ".NaN", expect, got)

		end if

	elif -EPSILON < got and got < EPSILON then

		if expect < - 1.5 * EPSILON or expect > 1.5 * EPSILON then

			realfailure(where ~ "~0", expect, got)

		end if

	else

		real ratio := expect / got

		if ratio < 1.0 - EPSILON  or  ratio > 1.0 + EPSILON then

			realfailure(where, expect, got)

		end if

	end if

end function


void

function checkboolean(where, boolean expect, boolean got)

	if expect /= got then

		printline("checkboolean FAILURE in " ~ where

			~ ".  Expected " ~ textimage(expect) 

			~ " and got "  ~ textimage(got))

	end if

end function


void

function checkstyles(where, expect, got)

	subseq e := start(copy(expect))

	subseq g := start(copy(got))

	while TRUE do

		e := nextstylesegment(e)

		g := nextstylesegment(g)

		if e /= g then

			printline ("checkstyles = FAILURE in " ~ where

				~ ".  Expected " ~ e ~ " and got " ~ g)

		elif not hasstyles(e, g) then

writefile("/tmp/e", e)

writefile("/tmp/g", g)


			printline ("checkstyles eg FAILURE in " ~ where

				~ ".  Expected " ~ e ~ " and got " ~ g)

		elif not hasstyles(g, e) then

			printline ("checkstyles ge FAILURE in " ~ where

				~ ".  Expected " ~ e ~ " and got " ~ g)

		end if

		if e = "" or g = "" then exit while end if

	end while

	if e /= "" or g /= "" then

		printline("checkstyles FAILURE remnant in " 

			~ where ~ ".  expected " ~ expect ~ " got " ~ got)

	end if

end function



-- integer arithmetic

-- function parameter and value as integer

integer function sq(integer x)

	return x*x;

end function;

void

function squaretable()

	integer a, sum

	sum := 0

	a := 0-3;

	while true and (a <= 10) do

--		printline("The square of " ~ textimage(a) 

--				~ " is " ~ textimage(sq(a)));

		sum := sum + sq(a)

		a := a + 1;

	end while;

	checkinteger("square", 961, sq(-31))

	checkinteger("squaretable", +11, a)

	-- sum of squares of -3 -2 -1 0 1 2 3 4 5 6 7 8 9 10

	checkinteger("sumsq", 399, sum)

end function;


void 

function testtextimage()

	checkstring("textimage(-3)", "-3", textimage(-3))

	checkstring("textimage(-305e-2)", "-3.05", textimage(-305e-2))

	checkstring("textimage(\\"perfect\\")", "perfect", textimage("perfect"))

	checkstring("textimage(True)", "True", textimage(True))

	marker m := textimage(class("text"))

	checkstring("testimage(text)", "0x", extent(m, second(m)))

	checkboolean("testimage(lt)", True, length(m) < 15)

end function



-- parsereal and parseint

-- nan

void

function testnums()

	real r;

	checkreal("parsereal", 3.1415926535, 

			parsereal("3.1415926535 asdasd"));

	checkinteger("parseint", 3, parseint("3.1415926535 asdasd"));

	checkinteger("parseinterror", 1024*1024*1024 *(-2), parseint("q  "));

	r := parsereal("q  ")

	checkinteger("parsereal", 0, length(WhereItWas()))

	if realIEEE and not isnan(sqrt(-1.0)) then  

		printline("nan FAILURE sqrt(-1.0) is "

			~ textimage(sqrt(-1.0)));  

	end if;

	if realIEEE and finite(3.0/0.0) then  

		printline("finite FAILURE 3.0/0.0 is "

			~ textimage(3.0/0.0));  

	end if;


end function



function checkfile(fnm)

	subseq f := system("cat " ~fnm)

	subseq expect :=  copy(

//

#3begindata{text,#1}

#3textdsversion{12}

#3template{default}

a#3

#3begindata{fad,#2}

$C 30

$T 30

$L andy12

$P 0,0,20000,256

$F

$$

#3enddata{fad,#2}

#3view{fadview,#2,4,0,0}d#3bold{de}f#3

#3enddata{text,#1}


\\\\ )

	subseq hash1 := token(f, "0123456789")

	subseq hash2

	hash2 := token(finish(hash1), "0123456789")

	hash2 := token(finish(hash2), "0123456789")

	expect := start(expect)

	while TRUE do

		expect := search(finish(expect), "#")

		if expect = "" then exit while end if

		if next(expect) = "1" then

			replace(extent(expect, next(expect)), hash1)

		elif next(expect) = "2" then

			replace(extent(expect, next(expect)), hash2)
		else

			replace(extent(expect, next(expect)), "\\\\")

		end if

	end while

	checkstring("fadfile", base(expect), f)

end function


-- class, new

-- replacewithobject

-- concatenation

-- addstyles

-- writefile

-- nextstylegroup

-- enclosingstylegroup

void function teststyles()

	marker s;

	marker m;

	subseq r

	object t;

	object c;

	c := class("fad")

	if c = NULL then c := class("text") end if

	t := new(c)


	m := "asd" ~ "def"

	replaceWithObject(second(m), t, "");

	m := nextn(start(base(m)), 4);

	m := extent(m, next(m));

	AddStyles(m, "\bold{bold}");

	writefile("/tmp/to", base(m));

	checkfile("/tmp/to")


	m := start(second(m));

	m := enclosingstylegroup(m);

	checkstring("enclosing1", "de", m)

	checkstring("enclosing2",
"a\
\begindata{fad,7077888}
$C 30
$T 30
$L andy12
$P 0,0,20000,256
$F
$V 50,255 50,255
$$
\enddata{fad,7077888}
\view{fadview,7077888,33,41,41}ddef", enclosingstylegroup(m));

	checkinteger("lenclosing1", 0, 

				length(allprevious(enclosingstylegroup(m))));


	m := nextn(finish(base(m)), -3);

	m := extent(nextn(m, -1), m);  

	checkstring("nextn", "dd", m)


	if c /= class(firstobject(base(m))) then

		printline("class FAILURE " ~ textimage(c) 

			~ " /= " ~ textimage(class(firstobject(base(m)))));

	end if;

	if t /= firstobject(base(m)) then

		printline("firstobject FAILURE " ~ textimage(t) 

			~ " /= " ~ textimage(firstobject(base(m))));

	end if;

	printline("Hex value that is address of an object: " 

		~ textimage(firstobject(base(m))));

	s := 

//

T\italic{his\underline{ is t\underline{ex}\bigger{\bigger{\underline{t 
w}\bold{\bigger{\bigger{i}}t}}}\bold{h n}este}d styles.}

\\\\ ;

	writefile("/tmp/tp", s);


	m := enclosingstylegroup(finish(nextn(start(s), 14)));

	checkboolean("hasstyles", TRUE, hasstyles(m, "\bold{\italic{bolditalic}}"));

	checkboolean("hasstyles2", FALSE, HasStyles("\bold{abc}", "\deleteme{def}"))


	r := newbase()

	while m /= "" do

		r ~:= m ~ ":"

		m := enclosingStyleGroup(m);

	end while;

	checkstring("enclosingstylegroup", 

		"i:it:t wit: is text with neste:his is text with nested styles.:This is text with nested styles.:",

		r)


	r := newbase()

	subseq styles := "T\italic{h\underline{ 
\underline{e}\bigger{\bigger{\underline{tt}}}\bold{\bigger{\bigger{ii}}h}}}"

	m := nextstylegroup(start(s));

	integer cnt := 0

	while m /= "" do

		r ~:= m ~ ":"

		cnt := cnt + 1

		checkstyles("nextstyles1." ~ textimage(cnt),

			first(styles), first(m))

		styles := rest(styles)

		m := NextStyleGroup(m);

	end while;

writefile("/tmp/nextstylegroup1", r)

	checkstyles("nextstylegroup1", 

"T\italic{his\underline{ is t\underline{ex}\bigger{\bigger{\underline{t 
w}\bold{\bigger{\bigger{i}}t}}}\bold{h n}este}d styles.}:"

~ "\italic{his\underline{ is t\underline{ex}\bigger{\bigger{\underline{t 
w}\bold{\bigger{\bigger{i}}t}}}\bold{h n}este}d styles.}:"

~ "\italic{\underline{ is t\underline{ex}\bigger{\bigger{\underline{t 
w}\bold{\bigger{\bigger{i}}t}}}\bold{h n}este}}:"

~ "\italic{\underline{\underline{ex}}}:"

~ "\italic{\underline{\bigger{\bigger{\underline{t w}}}}}:"

~ "\italic{\underline{\bigger{\bigger{\underline{t w}\bold{\bigger{\bigger{i}}t}}}}}:"

~ "\italic{\underline{\bigger{\bigger{\bold{\bigger{\bigger{i}}}}}}}:"

~ "\italic{\underline{\bigger{\bigger{\bold{\bigger{\bigger{i}}t}}}}}:"

~ "\italic{\underline{\bold{h n}}}:",

		r)


	r := newbase()

	subseq segstyles := "T\italic{h\underline{ 
\underline{e}\bigger{\bigger{\underline{t}\bold{\bigger{\bigger{i}}t}}}\bold{h}e}d}"

	m := start(s);

	cnt := 0

	while True do

		m := NextStyleSegment(m);

		if m = "" then exit while; end if;

		r ~:= m ~ ":"

		cnt := cnt + 1

		checkstyles("nextseg." ~ textimage(cnt),

			first(segstyles), first(m))

		segstyles := rest(segstyles)

	end while;

	checkstring("nextstylesegment", 

		"T:his: is t:ex:t w:i:t:h n:este:d styles.:", r)


	s := search(s, "xt wi")

	clearstyles(s)

	s := base(s)

	r := newbase()

	subseq stylekeys := "T\italic{h\underline{ \underline{e}}}\italic{\underline{\bigger{\bigger{\bold{ttt}}}\bold{h}}}"

	m := nextstylegroup(start(s));

	cnt := 0

	while m /= "" do

		r ~:= m ~ ":"

		cnt := cnt + 1

		checkstyles("nextstyles2." ~ textimage(cnt), 

			first(m), first(stylekeys))

		stylekeys := rest(stylekeys)

		m := NextStyleGroup(m);

	end while;

writefile("/tmp/nextstylegroup2", r)

	checkstyles("nextstylegroup2", 

		"T\italic{his\underline{ is t\underline{e}}}xt 
wi\italic{\underline{\bigger{\bigger{\bold{t}}}\bold{h n}este}d styles.}:"

		~ "\italic{his\underline{ is t\underline{e}}}:"

		~ "\italic{\underline{ is t\underline{e}}}:"

		~ "\italic{\underline{\underline{e}}}:"

		~ "\italic{\underline{\bigger{\bigger{\bold{t}}}}}:"

		~ "\italic{\underline{\bigger{\bigger{\bold{t}}}\bold{h n}este}}:"

		~ "\italic{\underline{\bigger{\bigger{\bold{t}}}\bold{h n}este}d styles.}:"

		~ "\italic{\underline{\bold{h n}}}:"  ,

		r)

end function;



-- call external function

void function testtokens()

	subseq expected := start(" void function hello ( ) print ( \\"hello world\\\\n\\"")


	marker m;

	m := tokens_GetNess(start(

//

-- passing string to builtin

--

void

function hello()

	print ("hello world\\n");

end function;

\\\\
	));

	while TRUE do

		expected := finish(next(expected))

		if next(expected) = "\\"" then

			expected := allnext(expected)

		else

			expected := extent(expected, 

				start(search(expected, " ")))

		end if;

		if expected = "" then exit while end if

		checkstring("tokens_getness", expected, m)

		m := tokens_GetNess(m);

	end while;

end function;




-- ~:=

-- currentselection

void

function testcats()

	marker a;

	marker b;

	a := "asdfghjklzxcvbnm";

	b := copy("QWE")

	checkstring("concat", "asdfghjklzxcvbnmQWE", a ~ b)

	b ~:= a ~ "234";

	checkstring("append", "QWEasdfghjklzxcvbnm234", b)

	setcurrentselection(defaulttext, 

		replace (currentselection(), base(b)));

	checkstring("appendcs", "QWEasdfghjklzxcvbnm234", currentselection())

end function;



void

function testsimplesearch()

	marker v, args

	args := "id,v,"

	v := ",id,v,"

	checkstring("search", "i", search(v, "i"))

	checkstring("search", "id", search(v, "id"))

	checkstring("search", "id,", search(v, "id,"))

	checkstring("search", ",i", search(v, ",i"))

	checkstring("search", ",id", search(v, ",id"))

	checkstring("search", "v,", search(v, "v,"))

	v := copy(v)

	checkstring("replace", "XXX", replace(search(v, rest(args)), "XXX"))

	checkstring("replace2", ",iXXX", v)

	checkstring("replace3", "def", replace(("abc"~""), "def"));

end function




boolean function boolident(boolean x)

	return (x);

end function;


void

function testbool()

	boolean b;

	b := true;

	boolean a;

	a := false;

	checkboolean("boolasgn", False, a)

	a := "a" < ("b");

	checkboolean("strcomp", True, a)

	b := boolident(a);

	checkboolean("boolfunc", True, b)

	checkboolean("and", True, a and b)

	b := a and FALSE;

	checkboolean("and", False, b)

	checkboolean("or", True, b or TRUE)

	checkboolean("not", True, not b)

	checkboolean("nand", True, not (a and b))

	checkboolean("nor", False, not (a or b))

	checkboolean("orand", True, a or b and a)

	checkboolean("orand", False, b or a and b)

	checkboolean("andor", True, a and b or a)

	checkboolean("andor", False, b and a or b)

	checkboolean("norand", False, not(a or b and a))

	checkboolean("norand", True, not(b or a and b))

	checkboolean("nandor", False, not(a and b or a))

	checkboolean("nandor", True, not(b and a or b))

	checkboolean("boolall", False, 
			a and not (boolident(b) or boolident(a) and TRUE))

end function;




void

function boolzoo(args, results)

	boolean a := first(args) = "T"

	boolean b := second(args) = "T"

	boolean c := last(args) = "T"

	if not a or b or not c or a and b and c or a and not b and c then 

		checkboolean("bzoo1", first(results) = "T", TRUE)

	else

		checkboolean("bzoo1", first(results) = "T", FALSE)

	end if;

	-- use SAME results value, but reverse the test

	if not(not a or b or not c or a and b and c or a and not b and c) then

		checkboolean("bzoo2", first(results) = "F", TRUE)

	else

		checkboolean("bzoo2", first(results) = "F", FALSE)

	end if;

	results := rest(results)



	if a and b or c and a or b then

		checkboolean("bzoo3", first(results) = "T", TRUE)

	else

		checkboolean("bzoo3", first(results) = "T", FALSE)

	end if;




	if not (a and b or c and a or b) then

		checkboolean("bzoo3f", first(results) = "F", TRUE)

	else

		checkboolean("bzoo3f", first(results) = "F", FALSE)

	end if;

	results := rest(results)



	if	 (	a 

			or b and not (a and c or b and c) 

			or c 

			or 	not (a and b and c or a and b and c) 

				and c 

				and a) then 

		checkboolean("bzoo4." ~ args, first(results) = "T", TRUE)

	else

		checkboolean("bzoo4." ~ args, first(results) = "T", FALSE)

	end if;


	-- use SAME results value, but reverse the test

	if   not (	a 

			or b and not (a and c or b and c) 

			or c 

			or 	not (a and b and c or a and b and c) 

				and c 

				and a) then 

		checkboolean("bzoo5." ~ args, first(results) = "F", TRUE)

	else

		checkboolean("bzoo5." ~ args, first(results) = "F", FALSE)

	end if;


end function;


void

function testboolfun()

	boolzoo("TTT", "TTT")

	boolzoo("TTF", "TTT")

	boolzoo("TFT", "TTT")

	boolzoo("TFF", "TFT")

	boolzoo("FTT", "TTT")

	boolzoo("FTF", "TTT")

	boolzoo("FFT", "TFT")

	boolzoo("FFF", "TFF")

end function




marker a;

extend "hello"

marker b;

void

function testhello(c)

	b := a;

	printline("hello");

	h2();

end function;

void

function h2()

	h3();

end function;

on mouse "left up"

	a := b;

end mouse;

end extend;

void

function testextend()

	a := "hi";

--	testhello();	-- fails

	h3();

end function;

void

function h3()

	checkstring("extend", "hi", a)

end function;



void

function fun(a)

	marker b := "best";

	if a = b  and b < "max" then 

		replace (next(start(a)), "x");

		checkstring("fun1", "xest", a)

	else

		b := newbase() ~ "a";

		checkstring("fun2", "a", b)

	end if;

end function;



subseq

function st(x, subseq res)

	marker source;

	source := "ascvweiopnmfqwmfdqwdopmsdv fred asdaqwdf";

	while TRUE do 

		source := search(source, x);

		if source = "" then exit while end if

		if source /= "" then 

			source := next(source);

			checkstring("stloop", first(res), source)

			res := rest(res)

			source := finish(source)

		end if;

	end while;

	return allnext(source);

end function;



void

function teststrings()

	fun(copy("best"))

	fun(copy("worst"))

	checkstring("teststr", "wdf", st("a", "ssq"));

end function;



marker glets

boolean has377

-- init glets in function init at end of file


function gltest(fieldnames, val)

	checkboolean("gltest", val = "T",  has377)

end function

function testglobals()

	checkstring("glcat", "qwerQWER.", glets ~ ".")

	has377 := false

	gltest("a", "F")

	has377 := true

	gltest("a", "T")

end function




-- statements without semicolons

-- multiple decls with commas

-- multiple global decls

-- initialization in globals.

integer intd, inte, intf

function func1(integer inte)

	integer intf := 0

	checkinteger("func1", 12, intd+inte)

	while inte > 1 do		-- 7 ... 4

		intf := intf + inte

		inte := inte - 1

		if inte < 4 then exit while end if

	end while

	checkinteger("func1int", 3, inte);

	checkinteger("func1sum", 22, intf);

end function


marker mg

marker mh,mi;

boolean bp := False  boolean bq := not bp


function testi1()

	real a,b ,c 

	a := 0.0  

	b := a + 1.

	c := a * b

	checkreal("i1real", 0.0, c)

	intd := 5   inte:= 6  intf := 7

	func1(intf)

	mg := "abd"   mh := mg ~ "h"   mi := mh ~ mg

	checkstring("testi1", "abdhabd", mi)

	checkboolean("testi1b", True, bq)

end function



function food(a)

	return "3" ~ a ~ "5" 

end function


extend "bell" 

	on keys "a"

		checkstring("bell", "3b5", food("b"))

	end keys

end extend


marker mc  := "This is mc";

marker md

marker me :=  mc ~ food("2")

marker mb := "12345678"

-- init md in function init at end of file


function testfood()

	marker mc := "This isn't mc";

	checkstring("efood", "This is mc325", me)

	checkstring("cfood", "312345678This isn't mc5", food(mb ~ mc))

	checkstring("dfood", "rty12345678", md)

end function




function chkr(real x, real racosh, real rlgamma, real rasinh, 

		real ratanh, real rcbrt, real rexpm1, real rlog1p)


	checkreal("acosh", racosh, acosh(x));

	checkreal("lgamma", rlgamma, lgamma(x));

	checkreal("asinh", rasinh, asinh(x));

	checkreal("atanh", ratanh, atanh(x));

	checkreal("cbrt", rcbrt, cbrt(x));

	checkreal("expm1", rexpm1, expm1(x));

	checkreal("log1p", rlog1p, log1p(x));

end function


function testrealops()

	checkreal("rop1", 3.0, 1.25 + 1.75)

	checkreal("rop2", 0., 1.0 -1.)

	checkreal("rop3", .0, -.5 + 0.5)

	checkreal("rop4", 370000000000000., (37e13))

	checkreal("rop5", 3e-12, .00000003 / 10000.)

	checkreal("rop6", .3e23, 30000000000000000000000.)

	checkreal("rop7", 3.2235671e13, 32235671456789.12345678903)


	real x := 3.7

	real y := 0.

	if realIEEE then

		checkboolean("rop8", FALSE, finite(x/y))

		checkboolean("rop9", TRUE, finite(y/x))

		checkboolean("rop10", FALSE, isnan(x/y))

	end if

	chkr(0.707, 

		-999.0, 0.25240, 0.65839, 0.88116, 0.89085, 1.0279, 0.53474)

	chkr(0.99, 

		-999.0, 0.0058548, 0.87428, 2.6467, 0.99666, 1.6912, 0.68813)

	chkr(1.00001, 

		0.0044721, -5.7721e-06, 0.88138, -999.0, 1., 1.7183, 0.69315)

	chkr(1e-05, 

		-999.0, 11.513, 1e-05, 1e-05, 0.021544, 1e-05, 1e-05)

end function




-- this test program attempts to test the effect of replace() on other marks 
on the same base

--	There are eighteen cases when the text replaced is non-null 

--	and a further eight cases when the text replaced is null




function doTest(old, test, expected)

	marker b;

	b := base(old);

--	print("    Test marker " ~

--		allprevious(test) ~ "/" ~ test ~ "/" ~ allnext(test));

	replace(old, "xyz");

--	printline(" becomes " ~

--		allprevious(test) ~ "/" ~ test ~ "/" ~ allnext(test));

--	if extent(test, next(test)) /= expected then

--		printline ("	Failure.  Expected /" ~ 

--			 extent(expected, start(last(expected))) ~ 

--			"/ but got / " ~ test ~ " / ");

--	end if;

	checkstring("replace", expected, extent(test, next(test)))

end function;




-- testNonEmpty(m, expected)

--	Tests the effect on the marker described by m.  Result is described by 
'expected'

--

-- the base string for the replacement is "abcdefghijkl"

-- the replaced text is "efgh" and the replacement is "xyz"

--

-- The arguments m and 'expected' describe marks 

-- by listing the contents PLUS THE FOLLOWING LETTER.

--

function testNonEmpty(m, expected)

	marker b;

	marker old;

	marker test;


	b := "abcd" ~ "e";

	old := last(b);

	b ~:= "fghi";

	old := extent(old, previous(last(b)));

	b ~:= "jkl";


	test := search(b, m);

	test := extent(test, start(last(test)));


	doTest(old, test, expected);

end function


-- testEmpty(m, expected)

--	Test replacement of an empty string

--

-- The base text is abcdef and the insertion of "xyz" is made between c and d.

-- M and expected describe marks as in testNonEmpty

--

function testEmpty(m, expected)

	marker b;

	marker old;

	marker test;


	b := "abc" ~ "d";

	old := start(last(b));

	b ~:= "ef";


	test := search(b, m);

	test := extent(test, start(last(test)));


	doTest(old, test, expected);

end function;



function testreplace()


--	printline("\\n Replace slashed part of abcd/efgh/ijkl with \\"xyz\\"\\n");


-- cases beginning before the replaced text (six cases)

	testNonEmpty("b", "b");

	testNonEmpty("bc", "bc");

	testNonEmpty("bcd", "bcd");	-- same as previous case

	testNonEmpty("bcde", "bcdx");

	testNonEmpty("bcdef", "bcdx");

	testNonEmpty("bcdefg", "bcdx");	-- same as previous case

	testNonEmpty("bcdefgh", "bcdx");	-- same as previous case

	testNonEmpty("bcdefghi", "bcdxyzi");

	testNonEmpty("bcdefghij", "bcdxyzij");

	testNonEmpty("bcdefghijk", "bcdxyzijk");	-- same as previous case


-- cases beginning at the start of the replaced text (four cases)

	testNonEmpty("e", "x");

	testNonEmpty("ef", "x");

	testNonEmpty("efg", "x");	-- same as previous case

	testNonEmpty("efgh", "x");	-- same as previous case

	testNonEmpty("efghi", "xyzi");

	testNonEmpty("efghij", "xyzij");


-- cases beginning in the middle of the replaced text (four cases)

	testNonEmpty("f", "x");

	testNonEmpty("fg", "x");

	testNonEmpty("fgh", "x");	-- same as previous case

	testNonEmpty("fghi", "xyzi");

	testNonEmpty("fghij", "xyzij");


-- cases beginning at or after end of replaced string (four cases)

	testNonEmpty("i", "i");

	testNonEmpty("ij", "ij");

	testNonEmpty("ijk", "ijk");	-- same as previous case


	testNonEmpty("j", "j");

	testNonEmpty("jk", "jk");



--	printline("\\n Replace slashed part of abc//def with \\"xyz\\"\\n");


-- Replacement of initially null mark (eight cases)

	testEmpty("b", "b");

	testEmpty("bc", "bc");

	testEmpty("bcd", "bcx");

	testEmpty("bcde", "bcxyzde");

	testEmpty("bcdef", "bcxyzdef");	-- same as previous case

	testEmpty("d", "x");

	testEmpty("de", "de");

	testEmpty("def", "def");	-- same as previous case

	testEmpty("e", "e");

	testEmpty("ef", "ef");

end function;



marker sorttext := 

//

this is a test

-

record 1

-

record 0

contents of record 0

-


\\\\

marker sortresult := 

//

this is a test

-

record 0

contents of record 0

-

record 1

-


\\\\


function testsort()

	checkstring("sort", sortresult, sort_records("", sorttext))

end function



marker idletters := "qwertyuioplkjhgfdsazxcvbnm"


function somesearch()

	marker m := "struct ness *ness"

	checkstring("ss1", "struct", span(start(m), idletters))

	m := search(m, "*")

	checkstring("ss2", "ness", allnext(m))

	checkstring("ss3", "ness", span(finish(m), idletters))

end function


integer function recur(integer n)

	if n <= 2 then return 1

	else return recur(n-1) + recur(n-2)

	end if

end function

void function testrecur()

	checkinteger("recur", 144, recur(12));

end function




function main(args)

	printline("test hello")

	hello()

	printline("test squaretable")

	squaretable()

	printline("test textimage")

	testtextimage()

	printline("test nums")

	testnums()

	printline("test styles")

	teststyles()

	printline("test tokens")

	testtokens()

	printline("test cats")

	testcats()

	printline("test simplesearch")

	testsimplesearch()

	printline("test bool")

	testbool()

	printline("test boolfun")

	testboolfun()

	printline("test extend")

	testextend()

	printline("test strings")

	teststrings()

	printline("test globals")

	testglobals()

	printline("test i1")

	testi1()

	printline("test food")

	testfood()

	printline("test realops")

	testrealops()

	printline("test replace")

	testreplace()

	printline("test sort")

	testsort()

	printline("test somesearch")

	somesearch()

	printline("test recur")

	testrecur()

end function



function init()

	glets := "qwer" ~ "QWER"

	md := "rty"~mb;

end function\
\enddata{text,4760576}
