ATK_INTER
#ifndef _figogrp_H_
#define _figogrp_H_
/* figogrp.ch - fig element object: group */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $

  $Header: /afs/cs/user/rr2b/7.4/src/RCS/figogrp.H,v 3.3 1994/11/30 20:42:06 rr2b Stab74 $
*/

#include <rect.h>

#define figogrp_Range (2048)

#include <figobj.H>

class figogrp : public  figobj {
public:
	virtual ATKregistryEntry *ATKregistry();


    
      
	figogrp();
      
	virtual ~figogrp();
      
	static boolean InitializeClass();

      
    
       void WriteBody(FILE *fp);
       long ReadBody(FILE *file, boolean recompute)  ;
       char * ToolName(class figtoolview *v, long rock)  ;
       void Draw(class figview *v); 
       void Sketch(class figview *v);
       void Select(class figview *v); 
       enum figobj_Status Build( class figview *v, enum view_MouseAction action, long x, long y, long clicks)  ;
       boolean Reshape(enum view_MouseAction action, class figview *v, long x, long y, boolean handle, long ptref)  ;
       void MoveHandle(long x, long y, long ptref);
       enum figobj_HandleType GetHandleType(long num)  ;
       long * GetCanonicalHandles()  ;
       void StabilizeAttachments(boolean keepproport);

       void Reposition(long xd, long yd);
       void RecomputeBounds();
       struct rectangle * GetBounds(class figview *vv)  ;
       struct rectangle * GetSelectedBounds(class figview *vv)  ;
       void InheritVAttributes(class figattr *attr, unsigned long mask);
       unsigned long UpdateVAttributes(class figattr *attr, unsigned long mask)  ;
       void SetParent(long parentref,class figure *fig_ancestor);

    
      virtual void SetConstraintsActive(boolean val);
      virtual void Reconfigure();
      
    
      inline long   GetRoot()       { return ((this)->root); }
      inline long *GetRootPtr()  { return (&((this)->root)); }
      inline void SetChildBoundMod()  { ((this)->bboxdirty = TRUE); }

    
      long root;
      boolean bboxdirty;
      boolean doconstraints;
      struct rectangle handlebox;
};

#endif /* _figogrp_H_ */
