\begindata{text,538268692}
\textdsversion{12}
\template{default}
-- format.ness

--

--	Convert the current selection from ASCII to ATK by

--	removing newlines that are not the ends of paragraphs



-- The main routine

--	We process each newline in turn.

--	If it is preceded by a backslash, 

--		replace it and the backslash with one space

--	otherwise, it stays as is if

--		it is followed by white space or a newline

--		it is preceded by a newline

--		there is a tab or triple space before the next newline

--	otherwise, delete all preceding spaces and

--		if it is after the end of a sentence,

--			replace it with two spaces,

--		otherwise replace it with one space

--

--	The end of a sentence is one of  .  :  ;  ?  ! or one of these characters

--	followed by one of  '  "  \}  ]  )


function wraplines(m)

	marker tab, triple, newline, nextnewline, p


	tab := start(m)

	triple := start(m)

	newline := search(m, "\\n")


	while extent(newline, m) /= "" do

		if extent(newline, tab) = "" then

			tab := search(extent(newline, m), "\\t")

		end if

		if extent(newline, triple) = "" then

			triple := search(extent(newline, m), "   ")  -- three spaces

		end if

		nextnewline := search(extent(next(newline), m), "\\n")

		-- at this point, newline refers to a \\n within m

		-- nextnewline, tab, and triple refer to the earlier of finish(m)

		-- or the next, respectively, \\n, \\t, or three spaces.


		if previous(newline) = "\\\\" then

			replace(extent(previous(newline), newline), " ")

		elif 

			previous(newline) = "\\n"

			or next(newline) = " "

			or next(newline) = "\\t"

			or next(newline) = "\\n"

			or extent(tab, nextnewline) /= ""

			or extent(triple, nextnewline) /= ""

		then

			-- leave the newline as is

		else

			p := previous(newline)

			while p = " " and extent(m, p) /= "" do

				-- delete preceding spaces

				replace (p, "")

				p := previous(newline)

			end while


--		if it is after the end of a sentence,

--			replace it with two spaces,

--		otherwise replace it with one space

--

--	The end of a sentence is one of  .  :  ;  ?  ! or one of these characters

--	followed by one of  '  "  \}  ]  )


			if search("'\\"\}])", p) /= "" then

				p := previous(p)

			end if		-- \{we may go before start(m)\}

			if search(".:;?!", p) /= "" then

				replace(newline, "  ")   -- two spaces

			else

				replace(newline, " ")   -- one space

			end if

		end if


		newline := nextnewline

	end while

end function



function format_wrap()

	wraplines(currentselection(currentinset))

end function



extend "view:textview"

	on menu "Search/Spell,Wrap lines"

		wraplines(currentselection(currentinset))

	end menu

end extend



function main(args)

	marker filename, outname, text


	filename := token(args, "qwertyuiopasdfghjklzxcvbnm"

			~ "QWERTYUIOPASDFGHJKLZXCVBNM"

			~ "./0123456789")

	outname := search(filename, ".")

	text := search(finish(outname), ".")

	while text /= "" do

		outname := text

		text := search(finish(outname), ".")		

	end while

	if outname = "" or search(outname, "/") /= ""

			or extent(next(outname), filename) = "d" then

		outname := filename ~ ".d"

	else 

		outname := extent(filename, outname) ~ "d"

	end if



	printline("wc: " ~ filename ~ " -> " ~ outname)

	text := readfile(filename)

	system("mv " ~ outname ~ " " ~ outname ~ ".BAK")

	wraplines(text)

	writefile(outname, text)

end function


-- 
\begindata{bp,537558784}
\enddata{bp,537558784}
\view{bpv,537558784,13,0,0}

-- Copyright 1992 Carnegie Mellon University and IBM.  All rights reserved.

\smaller{\smaller{-- $Disclaimer: Andrew User Interface System - Binary Distribution 7.5

-- 

-- Permission to use, copy, modify, and distribute this software for any 

-- purpose is hereby granted, provided (a) that no fee is charged for the 

-- software, for the medium on which it is distributed, for the 

-- distribution process, or for effort involved in making the distribution;  

-- (b) that all copyright notices, this permission notice, and the 

-- following disclaimer remain in these files and appear in supporting 

-- documentation;  (c) that you do not translate, reverse engineer, 

-- decompile, or disassemble the software; and (d) that the names of 

-- IBM, Carnegie Mellon University, and other copyright holders not 

-- be used in advertising or publicity pertaining to distribution of the 

-- software.

-- 

-- CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 

-- COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 

-- WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 

-- IMPLIED WARRANTIES OF MERCHANTABILITY AND 

-- FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 

-- UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 

-- BE LIABLE FOR ANY SPECIAL, INDIRECT OR 

-- CONSEQUENTIAL DAMAGES OR ANY DAMAGES 

-- WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 

-- PROFITS, WHETHER IN AN ACTION OF CONTRACT, 

-- NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 

-- OUT OF OR IN CONNECTION WITH THE USE OR 

-- PERFORMANCE OF THIS SOFTWARE.

--  $

}}\enddata{text,538268692}
