#ifndef _xddimage_H_
#define _xddimage_H_
ATK_INTER
/* Copyright 1995 Carnegie Mellon University All rights reserved.
  $Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
 */


#include <ddimage.H>
class graphic;
class xgraphic;
class colormap;
class XCMapImageHist;
class event;
#include <image.H>
#include <xcolor.H>
#include <xim.H>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

class WorkProc;
DEFINE_MFLEX_CLASS(xcolors,xcolor *, 10);
class xddimage : public iddimage {
  public:
    virtual ATKregistryEntry *ATKregistry();

    xddimage();
    xddimage(image *src, colormap **map=NULL);
    virtual ~xddimage();
   
    virtual void ObservedChanged(observable *changed, long change);
    // When the source image changes outdated will be set to TRUE.
    // If a ddimage with outdated set to TRUE is used (by calling Draw) the image will
    // be re-processed by calling Process.
    
    virtual void Release(boolean delayok=FALSE);
    // When an image is no longer onscreen Release will free any
    // resources used in displaying the image.  (such as colors.)
    // outdated will be set to TRUE indicating that the image
    // needs to be re-processed if it is displayed again. Any portion
    // of the image which remains on screen may be corrupted.
    // If appropriate Release will also call ReleaseData.
    
    virtual void ReleaseData(boolean delayok=FALSE);
    // If display update speed is not important, but memory is then
    // ReleaseData can be used to release any memory used to
    // cache the results of processing.  No resource will be freed
    // if doing so would corrupt the on-screen image.

    virtual void ReleaseResources(boolean delayok=FALSE);
    
    virtual boolean Process(graphic *dest);
    // Process will process the image in whatever manner is needed
    // for display on the particular device the image will be displayed
    // upon.  The processing may include allocating display device
    // resources such as colors.  oudated will be set to FALSE.
    // Process will be called automatically if needed, but may be called
    // manually to perform the potentially lengthly processing
    // at a more convenient time.  If the processing fails FALSE
    // will be returned, otherwise TRUE will be returned.

    virtual void Draw(graphic *dest, long left, long top, long width, long height, long destLeft, long destTop);
    //  Draws the image area enclosed by the rectangle width x height @ (left,top) with
    // the upper left at (destLeft, destTop) in the dest graphic.
    
    virtual void Draw(graphic *dest, const struct rectangle *src, long destLeft, long destTop);
    //  Draws the image area enclosed by the rectangle src with
    // the upper left at (destLeft, destTop) in the dest graphic.

    XImage *ximage;
    xcolors allocated;
    boolean released;
    size_t maxcolors;
    image *tsrc;
    boolean waiting;
    XCMapImageHist *histogram;
    event *delayedrelease;
    event *delayedeval;
    WorkProc *draw;
    
    void ProcessTrueOrDirectColor(graphic *dest);

    void ProcessWithStaticColors(graphic *dest);

    void ProcessWithColorCube(graphic *dest);

    void ProcessWithExactColors(graphic *dest);

    void ProcessWithColorManager(graphic *dest);

    void ReProcess();
    
    xgraphic *xgd;
    Pixmap pixmap;
    boolean pixok;
};

 
#endif /* _xddimage_H_ */
