#ifndef _ness_H_
#define _ness_H_
/* ********************************************************************** *\
	Copyright IBM Corporation 1988,1991 - All Rights Reserved
	Copyright Carnegie Mellon University 1992, 1993 - All Rights Reserved
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
# 
# Permission to use, copy, modify, and distribute this software for any 
# purpose is hereby granted, provided (a) that no fee is charged for the 
# software, for the medium on which it is distributed, for the 
# distribution process, or for effort involved in making the distribution;  
# (b) that all copyright notices, this permission notice, and the 
# following disclaimer remain in these files and appear in supporting 
# documentation;  (c) that you do not translate, reverse engineer, 
# decompile, or disassemble the software; and (d) that the names of 
# IBM, Carnegie Mellon University, and other copyright holders not 
# be used in advertising or publicity pertaining to distribution of the 
# software.
# 
# CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
# COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND 
# FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
# UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
# PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR 
# PERFORMANCE OF THIS SOFTWARE.
#  $
*/

/*
ness.H		ness data object

	Provides for the source and object of one script.  
	Has methods for compilation and execution.

	THIS FILE IS PROCESSED BY nodeclass TO PRODUCE ness.H
	DO NOT EDIT ness.H

	This file combines ness.H, nesssym.H, and all include files
	from the original C version.

*/
#include <atom.H>
#include <proctable.H>
#include <text.H>
#include <nessmark.H>
#include <toksym.H>


#define CURRENTSYNTAXLEVEL			2
/* 	Will get compile error if syntax level of program exceeds
	CURRENTSYNTAXLEVEL because that means we have
	a new program and an old compiler. 
*/
#define CURRENTMODIFICATIONLEVEL		0

/* nessrun generates the VERSION NUMBER as 
 *
 *	<CURRENTSYNTAXLEVEL>.<CURRENTMODIFICATIONLEVEL>
 *
 */

#define UNSPECIFIEDSYNTAXLEVEL -1
/* this value is assumed if the syntax level is otherwise unspecified */


#define ness_access long
#define ness_codeInfrared	-1 	/* was tampered with.  
						Don't compile unless changed */
#define ness_codeRed		0	/* do not compile */
#define ness_codeOrange		3	/* record compile errors 
						for modification operators */
#define ness_codeYellow		6	/* record compilation errors 
						for file system operators */
#define ness_codeGreen		10	/* prompt before compiling */
#define ness_codeBlue		11	/* compile without prompting */
#define ness_codeUV		13	/* no warning notice; no dialog box */


inline char *freeze(char *msg) {
	return ((char *)strcpy((char *)malloc(strlen(msg)+1), msg));
}

typedef unsigned long Texpr;	/* expression types within compilation
			also used at runtime in checking function calls */

inline long ExtendShortSign(long x) {return (((x) ^ 0x8000) - 0x8000);}


/* nodeclass.h - global definition for the nodeclass system 
	 static to avoid global namespace pollution. */
static struct node *QTnode;


/* error.h  --  declarations for error handling routines */

struct errornode {
	class mark *where;  /* location in source */
	long execloc;	/* object code location of error */
	char *msg;	/* the error message */
	boolean ownmsg;	/* TRUE if this node is the only ptr to the msg */
	struct errornode *next;
};


/* nesssym.H
 *
 * A nesssym object is a subclass of toksym.  Its adds these fields:
 *	
 *	next	- for linking syms in a list
 *	parent  - where is it defined
 *	type	- TType value
 *	flags	- see compdefs.hn
 */

typedef long nesssym_scopeType;
#define nesssym_GLOBAL toksym_GLOBAL

union parenttype {
	class ness *ness;  
	class nesssym *nesssym;
	struct node *node; 
};

class nesssym : public  toksym {
public:
	virtual ATKregistryEntry *ATKregistry();

	static inline nesssym_scopeType NNewScope(nesssym_scopeType 
				enclosingScope) {
		return ((nesssym_scopeType)
				toksym::TNewScope((toksym_scopeType)enclosingScope)); }

	static inline void NDestroyScope(nesssym_scopeType scope) { 
		(toksym::TDestroyScope((toksym_scopeType)scope)); }

	static inline nesssym_scopeType NParentScope(nesssym_scopeType scope) { 
		return ((nesssym_scopeType)
			toksym::TParentScope((toksym_scopeType)(scope))); }

	static inline class nesssym * NDefine(char *name, 
				class nesssym *proto, nesssym_scopeType scope) { 
		return ((class nesssym *)
			toksym::TDefine(name, proto, (toksym_scopeType)scope)); }

	static inline boolean NUndefine(char *name, nesssym_scopeType scope) { 
		return (toksym::TUndefine(name, (toksym_scopeType)scope)); }

	static inline class nesssym *NFind(char *name, nesssym_scopeType scope) { 
		return ((class nesssym *)
			toksym::TFind(name, (toksym_scopeType)scope)); }

	static inline class nesssym *NLocate(char *name, class nesssym *proto,
 			nesssym_scopeType scope, boolean *new_c) { 
		return ((class nesssym *)
			toksym::TLocate(name, proto, (toksym_scopeType)scope, new_c)); }

	static inline long NFindAll(char *name, nesssym_scopeType scope, 
			sym_findfptr proc, long rock) { 
		return (toksym::TFindAll(name, (toksym_scopeType)scope, proc, rock)); }

	inline char * NGetName()	{ return ((char *)(this)->name); }

	inline nesssym_scopeType NGetScope()	{
		return ((nesssym_scopeType)(this)->scope); }

/* #define NGetINode(class nesssym *nsym, type) \ */
#define nesssym_NGetINode(nsym, type) \
			((class type *)((nsym)->info.node))
/* #define NGetInfo(class nesssym *nsym, type) \ */
#define nesssym_NGetInfo(nsym, type) \
			((type)((nsym)->info.intval))
/* #define NSetINode(class nesssym *nsym, type, val)  \ */
#define nesssym_NSetINode(nsym, type, val)  \
			((nsym)->info.node = (struct node *)(struct type *)(val))
/* #define NSetInfo(class nesssym *nsym, type, val)  \ */
#define nesssym_NSetInfo(nsym, type, val)  \
			((nsym)->info.intval = (long)(type)(val))

	nesssym();
	virtual ~nesssym();

	class nesssym *next;
	union parenttype parent;
	Texpr type;
	long flags;	/* see compdefs.hn */
};


/* envt.h  -  runtime environment

The Ness run-time environment has these components:
	object code: a string containing the compilation of all functions
	execution stack: arguments, locals, and temporaries for execution
	system mark list: constant strings and goto targets
	some global pointers accessing the above

*/


/* each of the following are initialized (in interp.c) 
	to point to the value needed for IsType() */

extern struct ATKregistryEntry *celClass;
extern struct ATKregistryEntry *textClass;
extern struct ATKregistryEntry *textviewClass;
extern struct ATKregistryEntry *dataobjectClass;
extern struct ATKregistryEntry *lpairClass;
extern struct ATKregistryEntry *viewClass;
extern struct ATKregistryEntry *celviewClass;
extern struct ATKregistryEntry *valueviewClass;
extern struct ATKregistryEntry *imClass;

extern class simpletext *ObjectCode;	
	/* the compiled bytecode for the functions */

typedef unsigned char TStackRef;	/* pointer into stack */
typedef unsigned short TGlobRef;	/* index into ness_Globals */
typedef unsigned long TCodeRef;		/* index into ObjectCode */
typedef long TType;			/* type code within Ness values */

#define longHdr	 ((TType) 9101 )
#define boolHdr	 ((TType) 9102 )
#define dblHdr	 ((TType) 9103 )
#define ptrHdr	 ((TType) 9104 )
#define seqHdr	 ((TType) 9105 )
#define funcHdr  ((TType) 9106 )
#define frameHdr ((TType) 9107 )
#define idleHdr  ((TType) 9108 )


/* STACK

	A stack frame has this structure:
 		temporary variables	top end (lower address)
		struct frameelt
		local variables
		arguments		bottom end (higher address)

	FramePtr points to the frameelt for the top (current) frame.
	Arguments and locals are addressed with positive offsets from FramePtr.
	FramePtr->prevframe points to the frameelt of the next earlier frame.

	When a function returns, the return value is moved from the top of
	the stack to the beginning of the stack frame.  (Thus it is at the 
	top of the stack on returning to the calling frame.)

	The initial stack contents are a dummy frameelt record.

	Each stack element begins with a pointer called a "objhdr".  
	Eventually it may point to an array of methods for dealing with 
	this type of value on the stack.  For now it is a simple integer.

	The stack grows downward.  The objhdr of each element is thus at the 
	lower end of the stack.  Thus the word at the top of the stack  
		{*(long *)NSP}  
	is a objhdr.  (Got that straight?) 
*/

/* elements that may appear on stack */

struct frameelt {			/* stack frame */
	TType hdr;			/* frameHdr */
	unsigned char *returnaddress;	/* (position in ObjectCode) */
	struct frameelt *prevframe;
};

struct longstkelt {		/* LONG or INT or INTEGER or FIXED */
	TType hdr;		/* longHdr */
	long v;
};

struct boolstkelt {		/* BOOLEAN or LOGICAL */
	TType hdr;		/* boolHdr */
	unsigned long v;
};

struct dblstkelt {		/* FLOAT or REAL */
	TType hdr;		/* dblHdr */
	double v;
};

struct ptrstkelt {		/* object ptr */
	TType hdr;		/* ptrHdr */
	ATK *v;
};

struct seqstkelt {		/* subseq ptr */
	TType hdr;		/* seqHdr */
	struct nessmark *v;
};

struct funcstkelt {		/* funcval */
	TType hdr;		/* funcHdr */
	struct callnode *call;
};

struct idleelt {
	TType hdr;		/* idleHdr */
};

union stackelement {
	struct longstkelt  l;
	struct boolstkelt  b;
	struct dblstkelt   d;
	struct ptrstkelt   p;
	struct funcstkelt  c;	/* contains a ptr to a callnode */
	struct seqstkelt   s;
	struct frameelt    f;
	struct idleelt	   i;	/* only in ness_Globals */
};

/*
	 NSPstore points to topmost stackelement in use; 
			initially it equals NSHiEnd
	 NSPbase has the value of NSP after the initial frame is on it.
	 NSLowEnd points to the bottom most word in the stack.
	 NSHiEnd points one past the topmost word in the stack
*/
extern union stackelement *NSPstore, *NSPbase, *NSLowEnd, *NSHiEnd;
extern long NSSize;		/* the number of words in the stack. */
#define InitialNSSize 5000  /* initial size allocated to stack */
extern struct frameelt *FramePtr;	/* points to current stack frame */


/* ness_Globals
	one entry for each constant, global variable, function
	For each function there is a mark entry in the ness_Globals array.  
	The length field within this mark gives the length of the code 
	compiled for the function.

	Simple values are stored directly in the array.
	Subseq values are pointers to a nessmark.

	ness_Globals points to the array.
	ness_GlobSize is the number of elements.
	ness_GlobFree indicates the first of the list of unallocated globals;
		these use idleelt structs.  The last has next=0
	The 0'th elt of ness_Globals is permanently allocated, so
		next=0 can indicate end of free list.

	next is also used in active elements:  It chains together
	all elements used by any one ness
*/

struct globelt {
	TGlobRef next;
	union stackelement e;
};
    
extern struct globelt *ness_Globals;
extern TGlobRef ness_GlobFree;
extern long ness_GlobSize;

#define NSPushSpace(type) (NSPstore=NSP=(union stackelement *)(((unsigned long)NSP) - sizeof(struct type)))
#define NSPopSpace(type) (NSPstore=NSP=(union stackelement *)(((unsigned long)NSP) + sizeof(struct type)))


/* compdefs.hn  -  definitions for ness.gra compilations */

typedef union {
	class nesssym *s;
	long i;
	struct varnode *varnode;
	struct exprnode *exprnode;
	struct predstatenode *predstatenode;
} YYSTYPE;

typedef unsigned long Texpr;


/* a struct compilation is used for each compilation.  
	Old ones are saved for reuse */
struct compilation {
	struct compilation *next;
	class tlex *tlex;
	class rules *parser;
	class ness *ness;
	int idtok;		/* token number for setID */
	class nesssym *proto;  /* prototype for symbols */

	long scopex;		/* index of current entry in 'scopes' */
	nesssym_scopeType scopes[5];   /* nesting scopes */
	nesssym_scopeType constscope;

	class nessmark *curfuncmark;	/* marker for object code 
				of function currently being generated */
	Texpr curfunctype;	/* type to be returned by return stmts */
	boolean predcond;	/* condition under which to branch to target */
	struct gotonode *predtargetlist;    /* branchlist of gotos 
					when predcond is met */
	struct gotonode *preddropthrulist;  /* branchlist of gotos 
					that are supposed to drop thru */
	struct fixupstackrefnode *varfixups;
	struct fixupstackrefnode *freefixups;
	class nessmark *savedCurfuncmark;
	struct fixupstackrefnode *savedVarFixups;
	boolean Locating;	/* TRUE if searching for obj loc */
	long Sought;		/* what object offset are we seeking */
	long CurrOffset;	/* where we are in object code */
	boolean LocationAdvancing;  /* toggles depending on whether
					in InitFunc */
	long StmtStart;		/* where the most 
					recent statement starts in source */
};

extern struct compilation *curComp;

/* definitions of various flavors of nodes */

/* a varnode would more properly be called a varinstance node
	it is used to record the occurrence of a var and exists only
	until that instance is absorbed in a higher level syntactic entity */
struct varnode {
	long loc, len;
	class nesssym *sym;
};

#define varnode_New() ((struct varnode *)malloc(sizeof(struct varnode)))
#define varnode_Destroy(n) (free(n))
#define varnode_Create(QZloc, QZlen, QZsym) \
	(QTnode = (struct node *)malloc(sizeof(struct varnode)), \
		((struct varnode *)QTnode)->loc = QZloc, \
		((struct varnode *)QTnode)->len = QZlen, \
		((struct varnode *)QTnode)->sym = QZsym, \
	(struct varnode *)QTnode)


/* a vardefnode exists for each variable: global, local, or parameter
	it stores the information needed to access it
	and also the information needed if it is a funcval 
*/
struct vardefnode {
	long addr;	/* global: TGlobRef;  local/parm: TStackRef */
	struct callnode *sig;  /* signature for calls to funcval */
};

#define vardefnode_New() ((struct vardefnode *)malloc(sizeof(struct vardefnode)))
#define vardefnode_Destroy(n) (free(n))
#define vardefnode_Create(QZaddr, QZsig) \
	(QTnode = (struct node *)malloc(sizeof(struct vardefnode)), \
		((struct vardefnode *)QTnode)->addr = QZaddr, \
		((struct vardefnode *)QTnode)->sig = QZsig, \
	(struct vardefnode *)QTnode)



/* (KLUDGE: first five fields are same as in a struct eventnode) */
struct funcnode {
	TGlobRef SysGlobOffset;
	nesssym_scopeType outerscope, ownscope;
	class mark *where;
	class nesssym *locallist;
	class nesssym *parmlist;
	Texpr functype;
	struct callnode *call; /* used only if this function 
			is loaded as a funcval */
	proctable_Entry *pe; 
	/* pe is non-NULL only if this function is placed in the proctable. */
	callnode *oldcall;
	/* oldcall is non-NULL only if this function overrides a function already
	in the proctable. oldcall is a callnode suitable for invoking the original
	function. */
	char *procname;
	/* procname is non-NULL only if the function is in the proctable and the
	name of the function had to be allocated. */
};

#define funcnode_New() ((struct funcnode *)malloc(sizeof(struct funcnode)))
#define funcnode_Destroy(n) (free(n))
#define funcnode_Create(QZSysGlobOffset, QZouterscope, QZownscope, QZwhere, QZlocallist, QZparmlist, QZfunctype, QZcall, QZpe, QZoldcall, QZprocname) \
	(QTnode = (struct node *)malloc(sizeof(struct funcnode)), \
		((struct funcnode *)QTnode)->SysGlobOffset = QZSysGlobOffset, \
		((struct funcnode *)QTnode)->outerscope = QZouterscope, \
		((struct funcnode *)QTnode)->ownscope = QZownscope, \
		((struct funcnode *)QTnode)->where = QZwhere, \
		((struct funcnode *)QTnode)->locallist = QZlocallist, \
		((struct funcnode *)QTnode)->parmlist = QZparmlist, \
		((struct funcnode *)QTnode)->functype = QZfunctype, \
		((struct funcnode *)QTnode)->call = QZcall, \
		((struct funcnode *)QTnode)->pe = QZpe, \
		((struct funcnode *)QTnode)->oldcall = QZoldcall, \
		((struct funcnode *)QTnode)->procname = QZprocname, \
	(struct funcnode *)QTnode)


struct exprnode {
	Texpr type;
	struct exprnode *next;
	boolean IsCat;		/* TRUE if is the result of catenation */
	long loc, len;
};

#define exprnode_New() ((struct exprnode *)malloc(sizeof(struct exprnode)))
#define exprnode_Destroy(n) (free(n))
#define exprnode_Create(QZtype, QZnext, QZIsCat, QZloc, QZlen) \
	(QTnode = (struct node *)malloc(sizeof(struct exprnode)), \
		((struct exprnode *)QTnode)->type = QZtype, \
		((struct exprnode *)QTnode)->next = QZnext, \
		((struct exprnode *)QTnode)->IsCat = QZIsCat, \
		((struct exprnode *)QTnode)->loc = QZloc, \
		((struct exprnode *)QTnode)->len = QZlen, \
	(struct exprnode *)QTnode)

#define exprnode_Combine(r,x,y,newtype) { \
		x->len = y->loc+y->len-x->loc; \
		x->IsCat = FALSE; \
		x->type = newtype; \
		exprnode_Destroy(y); \
		r=x; }

struct predstatenode {
	long fixuploc;	/* for ELIF */
	long objloc;	/* location at start of predicate (for WHILE) */
	long loc;		/* start of expr */
	struct gotonode *targetlist, *dropthrulist;
	boolean cond;
	char construct;	/* 'I'-if  'W'-while  'L'-function  'X'-expr  
				'A'-arg  'E'-extend  'V'-event  */
};

#define predstatenode_New() ((struct predstatenode *)malloc(sizeof(struct predstatenode)))
#define predstatenode_Destroy(n) (free(n))
#define predstatenode_Create(QZfixuploc, QZobjloc, QZloc, QZtargetlist, QZdropthrulist, QZcond, QZconstruct) \
	(QTnode = (struct node *)malloc(sizeof(struct predstatenode)), \
		((struct predstatenode *)QTnode)->fixuploc = QZfixuploc, \
		((struct predstatenode *)QTnode)->objloc = QZobjloc, \
		((struct predstatenode *)QTnode)->loc = QZloc, \
		((struct predstatenode *)QTnode)->targetlist = QZtargetlist, \
		((struct predstatenode *)QTnode)->dropthrulist = QZdropthrulist, \
		((struct predstatenode *)QTnode)->cond = QZcond, \
		((struct predstatenode *)QTnode)->construct = QZconstruct, \
	(struct predstatenode *)QTnode)


struct gotonode {
	long gotoloc;		/* the obj code location of the branch opcode */
	struct gotonode *next;
};

#define gotonode_New() ((struct gotonode *)malloc(sizeof(struct gotonode)))
#define gotonode_Destroy(n) (free(n))
#define gotonode_Create(QZgotoloc, QZnext) \
	(QTnode = (struct node *)malloc(sizeof(struct gotonode)), \
		((struct gotonode *)QTnode)->gotoloc = QZgotoloc, \
		((struct gotonode *)QTnode)->next = QZnext, \
	(struct gotonode *)QTnode)



/* these flags are in the flags field of a nesssym */

#define  flag_globalvar	(1<<0)
#define  flag_function	(1<<1)
#define  flag_parmvar	(1<<2)
#define  flag_localvar	(1<<3)
#define  flag_const		(1<<4)
#define  flag_builtin	(1<<5)
#define  flag_proctable	(1<<6)
#define  flag_classdefn	(1<<7)
#define  flag_var		(1<<8)
#define  flag_undef		(1<<9)
#define  flag_xobj		(1<<10)
#define  flag_event		(1<<11)
#define  flag_xfunc		(1<<12)
#define  flag_ness		(1<<13)
#define  flag_forward	(1<<14)
#define  flag_library	(1<<15)

/* valid options:

flag_function | flag_ness		top level function in a script	funcnode
flag_function | flag_ness | flag_forward  function declared FORWARD funcnode
flag_function | flag_ness | flag_xfunc	function within an 'extend'	funcnode
flag_function | flag_ness | flag_forward | flag_xfunc  fcn decl'd FORWARD  funcnode
flag_function | flag_builtin		a builtin function	  	builtindef	
flag_function | flag_proctable	  	function from proctable	callnode
flag_function | flag_classdefn  	function from class 	callnode
flag_function | flag_undef		undefined function		NULL or 1
		(the value 1 indicates that it is a for-sure undefined func)
flag_function | flag_forward		possibly a forward func call	callnode
flag_const			a constant		TGlobRef
flag_var	 			as yet undifferentiated var	none
flag_var | flag_parmvar		parameter of a function	vardefnode
flag_var | flag_parmvar | flag_forward	parm in FORWARD function  vardefnode
flag_var | flag_localvar		local within a function	vardefnode
flag_var | flag_globalvar		global to a script	vardefnode
flag_var | flag_builtin		predefined variable	  	builtindef
flag_var | flag_undef	(not used)	undefined variable	callnode
flag_undef  			raw, newly initialized symbol	none
flag_xobj				an extended object   	objnode
flag_event			an event			eventnode
flag_library			file in a directory on nesspath   libnode

*/

/* enum exprType {
 *	Tunk, Tlong, Tbool, Tdbl, Tstr, Tptr, Tfunc
 * }; 
 */
/* defn of Texpr is in nesssym.ch as
 *	typedef unsigned long Texpr;  
 */
#define Tend	((Texpr) 0)   /* end of list of types */
#define Tlong	((Texpr) 1)   /* integer */
#define Tbool	((Texpr) 2)   /* boolean (unsigned long) */
#define Tbra	((Texpr) 3)   /* d.o. via branch predicates */
#define Tdbl	((Texpr) 4)   /* float */
#define Tstr	((Texpr) 5)   /* marker */
#define Tptr	((Texpr) 6)   /* pointer to object */
#define Tfunc	((Texpr) 7)   /* function */
#define Tvoid	((Texpr) 8)   /* function with no value */
#define Tunk	((Texpr) 9)   /* unknown type */

/* types in C code (w/ corresponding Ness type) */
#define Tcstr	((Texpr) 10)	/* char *  	(Tstr)  */
#define Tshrt	((Texpr) 11)	/* short  	(Tlong) */
#define Tchr	((Texpr) 12)	/* char   	(Tlong) */

extern char *TypeName[];  /* see gen.c */


/* call.hn -  definitions for nesscomp function call routines */

struct builtindef {
	char *name, *defn;
	Texpr types[8];	/* the first in this list is the return type,
				the rest is args in REVERSE ORDER
				the end of list indicator is Tend
				Tunk is special for an optional textview arg 
			   if the list has only one type, the name is a predefined
				identifier */
	ness_access minok;	/* will be allowed when accesslevel 
				is this level or higher */
	struct callnode *call;	/* in case used as a funcval constant */
};

enum callvariety {callC, callPE, callSym, callNess, callBuiltin, 
		callMethod, callClProc, callGet, callSet, callNone};
extern char *callvarietyname[];
extern nesssym_scopeType LibScope;

#define MAXARGS  12
struct callnode {
	enum callvariety variety;
	class nesssym *Sym;	/* callSym (and all others) */
	union {
		int  (*Cproc)();		/* callC */
		TGlobRef Nproc;		/* callNess */
		struct proctable_Entry *pe;	/* callPE */
		struct builtindef *bid;		/* callBuiltin */
		long offset;	/* callMethod, callClProc, callGet, callSet */
	} where;
	struct ATKregistryEntry *requiredclass;  /* if 1st arg must be obj */
	Texpr rettype;		/* callMethod, callClProc, callGet, callSet  */
	long nargs;		/* number of arguments supplied 
					if (nargs==MAXARGS && argtype[0]==Tptr && argtype[1]==Tunk), arg types are deferred */
	Texpr argtype[MAXARGS];	/* array with type of each argument 
		in NORMAL order (*left* to *right*) 
		that is, argtype[0] is the first argument */
};

enum libstate {NotRead, ReadFailed, NotCompiled, Compiling, 
		CompiledWithError, OK};

struct libnode {
	char *path;	/* dir name, slashes at both ends */
	char *filename;	/* name of file (ends in '.n') */
	class ness *ness;	/* a ness for this file (initially NULL) */
	enum libstate status;
	long useid;		/* note that it is used by current ness
				(avoid searches of libuseList) */
	struct libnode *next;
};

#define libnode_New() ((struct libnode *)malloc(sizeof(struct libnode)))
#define libnode_Destroy(n) (free(n))
#define libnode_Create(QZpath, QZfilename, QZness, QZstatus, QZuseid, QZnext) \
	(QTnode = (struct node *)malloc(sizeof(struct libnode)), \
		((struct libnode *)QTnode)->path = QZpath, \
		((struct libnode *)QTnode)->filename = QZfilename, \
		((struct libnode *)QTnode)->ness = QZness, \
		((struct libnode *)QTnode)->status = QZstatus, \
		((struct libnode *)QTnode)->useid = QZuseid, \
		((struct libnode *)QTnode)->next = QZnext, \
	(struct libnode *)QTnode)


struct libusenode {
	struct libnode *used;
	struct libusenode *next;
};

#define libusenode_New() ((struct libusenode *)malloc(sizeof(struct libusenode)))
#define libusenode_Destroy(n) (free(n))
#define libusenode_Create(QZused, QZnext) \
	(QTnode = (struct node *)malloc(sizeof(struct libusenode)), \
		((struct libusenode *)QTnode)->used = QZused, \
		((struct libusenode *)QTnode)->next = QZnext, \
	(struct libusenode *)QTnode)



/* gen.hn  -  definitions for nesscomp */

extern boolean predcond;
extern struct predstatenode *pssp;   /* (used in compile.c) */

#define predEQ	0
#define predNE	1
#define predLT	2
#define predLE	5
#define predGT	4
#define predGE	3
#define predT	6
#define predF	7
#define predOR	7
#define predAND	6

#define MAXEXPRDEPTH 500  /* the number of elts in predstatestack */

struct fixupstackrefnode {
	TCodeRef refloc;		/* offset from start of function */
	class nesssym *sym;
	struct fixupstackrefnode *next;	
};

#define fixupstackrefnode_New() ((struct fixupstackrefnode *)malloc(sizeof(struct fixupstackrefnode)))
#define fixupstackrefnode_Destroy(n) (free(n))
#define fixupstackrefnode_Create(QZrefloc, QZsym, QZnext) \
	(QTnode = (struct node *)malloc(sizeof(struct fixupstackrefnode)), \
		((struct fixupstackrefnode *)QTnode)->refloc = QZrefloc, \
		((struct fixupstackrefnode *)QTnode)->sym = QZsym, \
		((struct fixupstackrefnode *)QTnode)->next = QZnext, \
	(struct fixupstackrefnode *)QTnode)



/* nevent.hn  -  definitions for support of events: mouse, keys, menu */

struct objnode {
	class nesssym *attrs;
	nesssym_scopeType scope;
	long loc;
	long len;
	class celview* obj;  /* the object extended 
				(or ATKregistryEntry for view:xyz) */
	struct proctable_Entry *menupe, *keype;
	class keymap *keymap;
	class menulist *menulist;
	boolean MouseEnabled;
	boolean ExtendAView;
};

#define objnode_New() ((struct objnode *)malloc(sizeof(struct objnode)))
#define objnode_Destroy(n) (free(n))
#define objnode_Create(QZattrs, QZscope, QZloc, QZlen, QZobj, QZmenupe, QZkeype, QZkeymap, QZmenulist, QZMouseEnabled, QZExtendAView) \
	(QTnode = (struct node *)malloc(sizeof(struct objnode)), \
		((struct objnode *)QTnode)->attrs = QZattrs, \
		((struct objnode *)QTnode)->scope = QZscope, \
		((struct objnode *)QTnode)->loc = QZloc, \
		((struct objnode *)QTnode)->len = QZlen, \
		((struct objnode *)QTnode)->obj = QZobj, \
		((struct objnode *)QTnode)->menupe = QZmenupe, \
		((struct objnode *)QTnode)->keype = QZkeype, \
		((struct objnode *)QTnode)->keymap = QZkeymap, \
		((struct objnode *)QTnode)->menulist = QZmenulist, \
		((struct objnode *)QTnode)->MouseEnabled = QZMouseEnabled, \
		((struct objnode *)QTnode)->ExtendAView = QZExtendAView, \
	(struct objnode *)QTnode)


/* KLUDGE: note that first five fields are the same order and position
	as the fields in a struct funcnode */
struct eventnode {
	TGlobRef SysGlobOffset;
	nesssym_scopeType outerscope, ownscope;
	class mark *where;
	class nesssym *locallist;
	class nesssym *varsym;
	char *spec;
	class ness *parentness;
	class observable *TriggerHolder;
	boolean enabled;
	char *rock;
	struct eventnode *next, **meptr;
};

#define eventnode_New() ((struct eventnode *)malloc(sizeof(struct eventnode)))
#define eventnode_Destroy(n) (free(n))
#define eventnode_Create(QZSysGlobOffset, QZouterscope, QZownscope, QZwhere, QZlocallist, QZvarsym, QZspec, QZparentness, QZTriggerHolder, QZenabled, QZrock, QZnext, QZmeptr) \
	(QTnode = (struct node *)malloc(sizeof(struct eventnode)), \
		((struct eventnode *)QTnode)->SysGlobOffset = QZSysGlobOffset, \
		((struct eventnode *)QTnode)->outerscope = QZouterscope, \
		((struct eventnode *)QTnode)->ownscope = QZownscope, \
		((struct eventnode *)QTnode)->where = QZwhere, \
		((struct eventnode *)QTnode)->locallist = QZlocallist, \
		((struct eventnode *)QTnode)->varsym = QZvarsym, \
		((struct eventnode *)QTnode)->spec = QZspec, \
		((struct eventnode *)QTnode)->parentness = QZparentness, \
		((struct eventnode *)QTnode)->TriggerHolder = QZTriggerHolder, \
		((struct eventnode *)QTnode)->enabled = QZenabled, \
		((struct eventnode *)QTnode)->rock = QZrock, \
		((struct eventnode *)QTnode)->next = QZnext, \
		((struct eventnode *)QTnode)->meptr = QZmeptr, \
	(struct eventnode *)QTnode)



/* ness.H */

/* values for NotifyObservers */
#define ness_NEWERROR 2		/* to notify the nessview */
#define ness_WARNINGTEXTCHANGED 3	/* to notify the nessview */

class ness : public  text
{
public:
	virtual ATKregistryEntry *ATKregistry();

/* overrides */
	long Read(FILE *file, long id);
	long ReadTemplate(char *templateName, 
				boolean inserttemplatetext);
	long HandleKeyWord(long pos, char *keyword, FILE *file);
	long Write (FILE *file, long writeid, int level);
	void NotifyObservers(long status);
	void SetReadOnly(boolean readOnly);
	void SetAttributes(struct attributes *attributes);

/* methods */
	virtual long ReadNamedFile(char *name);
		/* read an object from file, checking that it is a ness */
	virtual void SetFilename(char *n);
	      /* sets the filename where the ness
		script came from, and should be
		saved to when operated on by the macro
		system. */
	virtual void EstablishViews(class view *child);
		/* set DefaultText and Arbiter using hueristics.  The 'child'
		 should be a child of the arbiter.  */

	virtual struct errornode * Compile();
		/* compile the source (no need to call, Execute will call it) 
		 should be called to establish any event handlers */

	virtual struct errornode * Execute(char *func);
		/* execute named function in the current script 
			using nessview as access to arbiter
			and using textview as subject for currentselection() */
		/* if Compile or Execute returns NULL, it succeeded
		    otherwise value is a  (struct errornode *)
		*/

	virtual void ClearErrors();	/* empty the error chain */
	virtual struct errornode * NextError(struct errornode *curr);
		/* finds err after 'curr'.  If curr is NULL, finds first err 
			returns NULL if 'curr' is the last */
	virtual struct errornode * PreviousError(struct errornode *curr);
		/* finds error before 'curr'.  If curr is NULL, finds first err
			returns NULL if 'curr' is the first */

	virtual void Expose();	/* show the ness and first error */

	virtual void SetAccessLevel(ness_access newlevel);
		/* set the access level for execution */
	virtual void AddWarningText();
		/* adds to the text the initial warning and final buttons.  
			make read/only  */
	virtual void RemoveWarningText();
		/* removes from the text the initial warning and final buttons
			restores r/w  */
	virtual char * GetOrigin()  ;
		/* returns the current origin string */
	virtual void GetOriginData(char **date, char **author);
		/* extracts origin data.  Caller must free it. */

	virtual void dumpattrs( FILE *file);
		/* print the attributes to 'file' */
	virtual long printerrors( FILE *file)  ;
		/* format and print error messages for 'self' to 'file' 
		    return number of errors */
	virtual union stackelement *GetVarAddr( char *var);
		/* returns the address of the value (as a stackelement) 
			for the global variable named 'var' 
			returns NULL if there is none */

/* macros */
	inline void SetName(char *n)	{ (this->name = (n)); }
	inline char * GetName()		{ return (this->name); }
	inline void SetArbiter(class arbiterview *v)
					{ (this->Arbiter = (v)); }
	inline class arbiterview * GetArbiter()		
					{ return (this->Arbiter); }
	inline void SetDefaultText(class textview *t)	
					{ (this->DefaultText = (t)); }
	inline class textview * GetDefaultText()	
					{ return (this->DefaultText); }
	inline void SupplyMarkerArg(class nessmark *a)
					{ (this->arg = (a)); }
	inline class ness * GetNext()	{ return (this->next); }
	inline struct errornode * GetErrors()
					{ return (this->ErrorList); }
	inline boolean HasWarning()	{ return (this->hasWarningText); }
	inline boolean NeedsDialogBox()	{ return (this->DisplayDialogBox); }
	inline void SetNeedsDialogBox(boolean v)
					{ (this->DisplayDialogBox = (v)); }
	inline char  * GetFilename()	{ return (this->filename); }

/* class procedures */	
	static boolean InitializeClass();
	static boolean atk_inited;

	ness();
	virtual ~ness();

	static void SetDebug(boolean d);
	static class ness * GetList()  ;
	static long PrintAllErrors(char *when)  ;
		/* formats error messages for all loaded Nesses 
		    and prints them to stderr.   'when' is printed in header
		    return number of errors found */

/* data */
	class ness *next;	/* list of all nesses for mapping errors */
	char *name;	/* reference name;  not owned by ness */

	/* management of this text */
	char *Origin;	/* syntax level \0 date file written \0 file writer */
	long syntaxlevel;		/* from the Origin value */
	long OriginalModValue;	/* used to test if the text has been modified*/
	long ScriptLoc, 		/* position of first char of script */
		AfterScriptLoc,	/* position of first char after script */
		DeauthButtonLoc,	/* warning text loc of Deauth button */
		ScanButtonLoc,	/*   "   "   "  of Scan  " */
		CompileButtonLoc, /*   "   "   "  of Compile  " */
		AuthorButtonLoc;	/*   "   "   "  of Author  " */
	ness_access accesslevel;	/* control what operations allowed */
	struct errornode *ErrorList;	/* list of errors */
	boolean IsNowOriginator;	/* set T when modify the Origin value*/
	boolean hasWarningText;		/* T if the warningtext is present */
	boolean DisplayDialogBox;	/* (for nessview) needs dialog box
						 before compile */
	boolean PromptBeforeCompile;	/* T if should prompt 
						before doing next compile */
	boolean ReadingTemplate;	/* just while in ReadTemplate */
	boolean ClassEnabled;	/* T if wants to access class methods, et al.*/
	/* compilation information */
	boolean compiled;		/* T: compiled okay & text unchanged */
	nesssym_scopeType outerScope;	/* symbol table in use */
	nesssym_scopeType constScope;	/* scope for constants */
		/* the first character of a name in constScope tells its type:
			"	short string.  name follows
			0	integer or real. 0x<hexvalue>
			'	one character constant. the char
			/	long string.  number
			&	object reference. the name
		*/
	class nesssym *globals;	/* list of symbols and functions*/
	struct libnode *libnode;  /* if this ness is for a library file */
	struct libusenode *libuseList;  /* list of libraries used */
	long compilationid;		/* value for useid in libusenodes */

	/* used during compilation */
	class nesssym **AttrDest;		/* where to store attributes */
	class nesssym **saveAttrDest;	/* AttrDest saved at start of EXTEND */
	class nesssym *CurrentObject;	/* the current EXTEND object */
	class nesssym *InitFunc;	/* func to call to do initialization */

	/* runtime information */
	boolean needsInit;	/* T: there is unexecuted function init */
	boolean ToldUser;	/* T: just displayed something in msgline */
	class textview *DefaultText;    /* value of defaulttext() function */
	class arbiterview *Arbiter;	/* access to name space */
	class view *CurrentInset;
	class nessmark *arg;	/* from SupplyMarkerArg */
	char *filename;
	long marks;
	boolean errorpending;
};


/* * * * * * * * * * * * * * * * * * * * * * * * *\
	 function prototypes 
\* * * * * * * * * * * * * * * * * * * * * * * * */

/* call.C */

void callInit(nesssym_scopeType  Gscope, int  idtok, class nesssym  *proto);  
	/* initialize for generating calls */
void callDirLibs();  /* load names of libraries on nesspath */
struct exprnode * callFunc(struct varnode *varnode, struct exprnode *argtypes);
void callUnknown(class nesssym  *sym);	/* make undefined function */
void callPredefId(class nesssym  *var);	/* generate code for predefined id */
struct callnode * callLoadFuncval(struct varnode  *var); 
		/* load reference to func */
struct errornode * callInitAll(class ness  *ness);  
		/* call init() for ness and libraries */
void callCheck (struct callnode  *call, unsigned char *iar, class ness  *ness);
			/* resolve reference and do a call at run-time */
void callCfunc(struct callnode  *call, unsigned char *iar, class ness  *ness); 
void callCheat(unsigned char op, unsigned char *iar, class ness  *ness);

enum libstate callCheckLib(char *fun, struct funcnode  **fnode);
				/* load library and find function 'fun` */
void callCompLib(struct libnode  *lnode);
		/* compile ness from library and set libnode->status */
long ReadTextFileStream(class text *text, char *name, FILE *f, boolean  objok);
	/* checks filetype and whatnot 
	returns dataobject_NOREADERROR or a dataobject error */

/* dump.C */
void dumpStack(FILE *f, union stackelement *NSP);
void dumpObjectCode(FILE *file, long  offset);
void dumpFuncDef(FILE *file, class nesssym *f);
void dumpEventDef(FILE *file, class nesssym *f);
void dumpAttrList(FILE *file, class nesssym *symlist);
void ds(union stackelement *NSP);
void da();
void dna(class nesssym *n);

/* interp.C */
boolean RunError(char  *msg, unsigned char *iar);
void initializeEnvt();
union stackelement * popValue(union stackelement  *NSP);
static struct callnode * fetchaddr(unsigned char *iar);
static void InterruptNess(class ness  *ness);
static void QueryReadOnly(class ness  *ness, class simpletext  *s, char  *msg, 
		unsigned char *iar);
extern struct errornode *
interpretNess(short  func, ATK  *arg, class ness  *ness);
extern	void ness_InitInterp(ness *) ;
extern atom_def ness_booleanatom;
extern boolean ness_StackArgs(const avalueflex &args) ;
extern size_t ness_InitArgMarks() ;
extern void ness_ClearArgMarks(size_t bottom);


/* search.C */
void SearchOp(unsigned char op, unsigned char *opiar  /* iar of the opcode */);

/* error.C */
struct errornode *errornode_New();
struct errornode *errornode_Create(class ness  *ness, long  loc, long  len, 
	long  execloc, char  *msg, boolean  ownmsg, struct errornode  *next);
void  errornode_Destroy(struct errornode  *enode);
class nesssym *codelocFind(long  loc);		/* find nesssym for loc */
void SaveError(char  *msg, long  loc , long  len);	/* add to error list */
void ReportError(char  *msg, long  index); 
		/* SaveError at the loc of 'index'th token */
void ExprError(char  *msg, struct exprnode  *expr); 
		/* SaveError at the loc of 'expr' */
void SetupErrorHandling(class ness  *ness);
		/* init compilation recovery */
void errorfromparse(int severity, char *msg);
		/* capture parser error */
boolean errorsynch(long  index);	/* "... restart with token" */
boolean isFuncStart(int  nexttok, long  ncheck);	
		/* test for 0 indent for this or next two tokens */

struct errornode *LocateErrorFunc(unsigned char *loc , unsigned char *base, 
	char  *msg, class ness  *ness);  /* see which ness has the error */
void MapRunError(class ness  *ness);


/* compile.C */
extern struct errornode * compile(class ness  *ness, long  pos , long  len);
extern boolean compileForLocation(class ness  *ness, long  pos , long  len, unsigned long  objloc, boolean  LocateInInitFunc, unsigned long  *Ploc , unsigned long  *Plen);
extern void compileStmtStart(long  tokeninx);
extern void compileLocate(long  bytes);
nesssym_scopeType compNewScope();	
		/* save current scope and make a new one */
void compPopScope();	/* restore prior scope */
void compPushScope(nesssym_scopeType  scope);  /* install a temporary scope */

/* gen.C */

void  deallocSysGlobs(TGlobRef  ind);
long BackSlashReduce(register class text  *text);
void fixRefSysGlob(class nessmark  *m, TCodeRef  loc, TGlobRef  val);
void setcurfuncmark(class nessmark  *m);
class nessmark * getcurfuncmark();
class nessmark * makeFunction(TGlobRef  *loc); 
		/*creates a marker for a new function */
TGlobRef makeConst(char  *s);  
		/*  return index of marker for const with s  */
TGlobRef makeStyledConst(class text  *text, long  pos , long  len, 
		boolean  bsReduce); 
		/*  return index of marker for const from text at pos,len */
TGlobRef makeGlobal();		
		/*  return index of marker for a global var  */
void addOp(class nessmark  *m, unsigned int op);	
		/* add operator to func def'n */
TCodeRef refStack(class nessmark  *m, unsigned int op, TStackRef  rand); 
		 /* add op w/ 1 byte rand */
void fixRefStack(class nessmark  *m, TCodeRef  loc, TStackRef  val);  
		/* fix a refStack */
TCodeRef refSysGlob(class nessmark  *m, char op, TGlobRef  rand);  
		/* op w/ 2 byte rand */
void refAddress(class nessmark  *m, char op, struct callnode *address);
		/* add op followed by four byte operand */

void genLinkGlobal(class nesssym  *sym);	/* attach sym to *AttrDest */
TGlobRef genEnter();	/* generate function entry */
boolean genExit(class nesssym  *parmlist , class nesssym  *locallist);  
		/* func exit */
void startfunc(class nesssym  *fname, Texpr  functype);
void genreturn(struct exprnode  *exp);
void finishfunc(class nesssym  *fname , class nesssym  *parmlist , 
		class nesssym  *locallist, boolean export);
void genchkforward();	/* check that FORWARDs are satisfied */
void abortfunc();	/* exit scope if in a func */
class nesssym * appendlists(register class nesssym  *list1 , 
		register class nesssym  *list2);

struct exprnode * genarith(char op, struct exprnode  *left , 
		struct exprnode  *right);
void gencomp(struct exprnode  *left , struct exprnode  *right, long  rop);
Texpr genvarref(struct varnode  *var);
void genvarstore(struct varnode  *varnode);
struct varnode * genvarnode(class nesssym  *sym);
void genconstref(class nesssym  *constant);
void genop(char op);

long genlabel();  /*returns loc of next opcode emitted */
long genbranch(char op, long  dest); 
		/* emits branch to target; returns its loc */
void fixbranch(long  loc); 
		/* fix branch at 'loc' to go to next op code emitted */

struct predstatenode * predpush(boolean  cond, long  loc, char  construct); 
		/* return predicate state and init to cond */
void predpop(); /* restore predicate state */
void predvalue(Texpr *Ptype);  /* emit code to get value from a predicate */
void predbranch(struct exprnode  *expr);
		/* emit code to convert value to branching */
void preddropthru(long rop); /* generate branch & put fixup on dropthru list */
void predtarget(long  rop); /* generate branch & put fixup on target list */
void predfixdropthru(); 
	/* make elts of dropthru list goto next opcode emitted;  empty list */
void predfixtarget(); 
	/* make elts of target list goto next opcode emitted; empty the list */
void predexit(char  construct);
void demandsymboltype(class nesssym  *sym, Texpr  type);
		/* error message if wrong type  */
void demandnodetype(struct exprnode  *node, Texpr  type);
		/* generate error if wrong type  */
struct varnode *varIsStorable(struct varnode  *var);
		/* checks that var is a variable */
struct varnode *varIsFunction(struct varnode  *var);
		/* checks that var is a function */
class nesssym *uniqueinscope(class nesssym * var, unsigned long  flags, 
		long  tokoff);  /* hide outer scope */
void ProcessDeclList(Texpr  type, class nesssym  *idlist, long  flags); 
class nesssym *genParmDecl(class nesssym  *sym  , Texpr  type);
void genCheckEndtag(class nesssym  *tag, long  desired);
		/* check token after END */
void genSaveFuncState();		/* save global initializer */
void genRestoreFuncState(class nesssym *func);  /* resume global initializer */

/* nevent.C */
/* code generation routines - compile time 
	these do initial and final processing for the EXTEND ... END
	and ON ... END constructs  */
class nesssym *neventStartExtend(class nesssym *currobj, class nesssym  *name);
class nesssym * neventFinishExtend(class nesssym *obj);
class nesssym * neventStartEvent(class nesssym  *currobj, class nesssym  *e, 
		class nesssym  *spec);
class nesssym * neventFinishEvent(class nesssym  *event , 
		class nesssym  *locals , class nesssym  *e);

/* post-time routines 
	these remove and post event handling to celviews */
void  neventPost (class ness  *ness, boolean  debug);
void neventUnpost (class ness  *ness, boolean  debug);

/* run time routines */
ATK  * ProperPtr(ATK   *ptr, struct ATKregistryEntry   *type);  
		/* finds descendent ptr of desired type */
void neventInfo(unsigned char op, unsigned char *iar, class ness  *ness);  
		/* dispatches for many event related routines */
void InterpretEvent(class view  *obj, struct eventnode  *enode);

/* nevent1.C */
ATK *ProperPtr(ATK *ptr, struct ATKregistryEntry *type);
class text *FrameMark(class ness *ness, class nessmark *m, char *title, 
	char *pgmnm, boolean enablecommands, long *pPos , long *pLen);

/* rexf.C */
void DoRex(unsigned char op);

/* real.C */
void realUnary(char  op, unsigned char *iar);
void realOther(char  op, unsigned char *iar);
#ifdef NESS_INTERNALS
	inline class nessmark *
FETCHMARK(union stackelement *addr) {
	if (addr->s.hdr != seqHdr)
		RunError(":Not a pointer to a mark (uninitialized variable?)",
						0);
	return addr->s.v;		
};

	inline class nessmark *
PushMark(class nessmark *src) {
	/* NSPushSpace(seqstkelt); */
	register union stackelement *NSP = 
		NSPstore=(union stackelement *)(((unsigned long)NSPstore) 
		- sizeof(struct seqstkelt));
	NSP->s.hdr = seqHdr;
	NSP->s.v = nessmark::getMark();
	if (src)
		(NSP->s.v)->SetFrom(src);
	return NSP->s.v;
}

#define PUSHMARK(m) (PushMark(m), NSP = NSPstore, NSP->s.v)
#endif
#endif /* _ness_H_ */
