ATK_INTER
#ifndef _ghash_H_
#define _ghash_H_
/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
// 
// Permission to use, copy, modify, and distribute this software for any 
// purpose is hereby granted, provided (a) that no fee is charged for the 
// software, for the medium on which it is distributed, for the 
// distribution process, or for effort involved in making the distribution;  
// (b) that all copyright notices, this permission notice, and the 
// following disclaimer remain in these files and appear in supporting 
// documentation;  (c) that you do not translate, reverse engineer, 
// decompile, or disassemble the software; and (d) that the names of 
// IBM, Carnegie Mellon University, and other copyright holders not 
// be used in advertising or publicity pertaining to distribution of the 
// software.
// 
// CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
// COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
// WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND 
// FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
// UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
// BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
// CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
// PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
// NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
// OUT OF OR IN CONNECTION WITH THE USE OR 
// PERFORMANCE OF THIS SOFTWARE.
//  $
*/


 

/* A hash table
 *
 */

#define ghash_BUCKETS 32

#include <ATK.H>


	typedef boolean (*ghash_efptr)(long rock, char *value, char *key, class ghash *self);
	typedef void (*ghash_freevalfptr)(char *value);
	typedef void (*ghash_freekeyfptr)(char *key);
	typedef char *(*ghash_copyvalfptr)(char *value);
	typedef char *(*ghash_copykeyfptr)(char *key);
	typedef int (*ghash_comparekeyfptr)(char *key1, char *key2);
	typedef int (*ghash_hashfptr)(char *key);

class ghash : public ATK  {
public:
	virtual ATKregistryEntry *ATKregistry();
	ghash();
    
	virtual ~ghash();
    
	static boolean InitializeClass();


    virtual char * Lookup(char *key)  ;
    virtual char * LookupKey(char *key)  ;
    virtual boolean Store(char *key, char *value)  ;
    virtual char * Delete(char *key)  ;
    virtual char * Rename(char *key, char *new_c)  ;
    virtual void Clear();
    virtual char * Enumerate(ghash_efptr proc, long rock)  ;
    virtual void Debug();

    inline void SetHash(ghash_hashfptr fn) { (this->hash = (fn)); }
    inline void SetFreeVal(ghash_freevalfptr fn) { (this->freeVal = (fn)); }
    inline void SetFreeKey(ghash_freekeyfptr fn) { (this->freeKey = (fn)); }
    inline void SetCopyKey(ghash_copykeyfptr fn) { (this->copyKey = (fn)); }
    inline void SetCopyVal(ghash_copyvalfptr fn) { (this->copyVal = (fn)); }
    inline void SetCompareKey(ghash_comparekeyfptr fn) { (this->compKey = (fn)); }
    inline ghash_freevalfptr   GetFreeVal() { return (this->freeVal); }
    inline ghash_freekeyfptr   GetFreeKey() { return (this->freeKey); }
    inline ghash_copykeyfptr   GetCopyKey() { return (this->copyKey); }
    inline ghash_copyvalfptr   GetCopyVal() { return (this->copyVal); }
    inline ghash_comparekeyfptr   GetCompareKey() { return (this->compKey); }


    class glist *buckets[ghash_BUCKETS];
    ghash_hashfptr hash;
    ghash_freevalfptr freeVal;
    ghash_freekeyfptr freeKey;
    ghash_copyvalfptr copyVal;
    ghash_copykeyfptr copyKey;
    ghash_comparekeyfptr compKey;
};

#endif /* _ghash_H_ */
