/* gentlex.h - declarations for file generated by gentlex */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: Andrew User Interface System - Binary Distribution 7.5
 * 
 * Permission to use, copy, modify, and distribute this software for any 
 * purpose is hereby granted, provided (a) that no fee is charged for the 
 * software, for the medium on which it is distributed, for the 
 * distribution process, or for effort involved in making the distribution;  
 * (b) that all copyright notices, this permission notice, and the 
 * following disclaimer remain in these files and appear in supporting 
 * documentation;  (c) that you do not translate, reverse engineer, 
 * decompile, or disassemble the software; and (d) that the names of 
 * IBM, Carnegie Mellon University, and other copyright holders not 
 * be used in advertising or publicity pertaining to distribution of the 
 * software.
 * 
 * CARNEGIE MELLON UNIVERSITY, IBM, AND THE OTHER 
 * COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES 
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS.  IN NO EVENT SHALL CARNEGIE MELLON 
 * UNIVERSITY, IBM, OR ANY OTHER COPYRIGHT HOLDER 
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR 
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
 * OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef _GENTLEX_H_
#define _GENTLEX_H_

#ifndef TRUE
#define boolean int
#define TRUE 1
#define FALSE 0
#endif

/* when subscripting by a char, use UNSIGN since some systems 
	will use a negative value for characters above 0x7F */
#define UNSIGN(c) ((unsigned char)(c))

/* macro to interrogate charset values.
	if parm->b is a Charset value, we can ask 
	whether the bit corresponding to character c is set by saying
		tlex_BITISSET(parm->b, c)
*/
typedef struct charsettype {
	char *vector;
	char mask;
}    Charset;
#define tlex_BITISSET(bs, c) ((((bs).vector)[UNSIGN(c)]) & ((bs).mask))


/* the following may appear in the action or thongact array */
#define tlex_ACTTHONG 0x100
	/* start thong table search at thongtbl[action&(~tlex_ACTTHONG)] */
#define tlex_ACTSCAN 0x200
	/* call recognizer described in rectbl[action&(~tlex_ACTSCAN)] */
#define tlex_ACTRESWD 0x400
	/* recognize the reserved word token action&(~tlex_ACTRESWD) */
#define tlex_ACTEOF 0x800
	/* end of file */

/* indices in internal table of the predefined recognizers 
  these values are of use in writing lexical analyzers, not client code */
 /* there is a table of names for these values in tlex/output.c */
#define tlex_ERROR 1
#define tlex_WHITESPACE 2
#define tlex_COMMENT 3
#define tlex_TOKEN 4
#define tlex_ID 5
#define tlex_NUMBER 6
#define tlex_STRING 7

/* an action value usually resolves into an index into tab->rectbl
	this provides a Recparm struct which specifies a recognizer,
	either predefined or user-defined, and provides parameters.
	the recognizer is called with two arguments:
		a pointer to the tlex
		a pointer to the Recparm struct
	the recognizer returns TRUE if it has found a token
	and FALSE if scanning is to resume
	arguments to recognizers and handlers are: tlex, parm
*/

/* the following Recparm declarations are used by the builtin recognizers 
	in the lexical analyzer.  They are not used in client code.  */

typedef int (*tlex_handlerfptr)(class tlex *self, void *rock);

struct tlex_Recparm {
	short tokennumber;
	int recognizerindex;	/* tlex_TOKEN */
	tlex_handlerfptr handler;
	boolean SaveText;
};
struct tlex_NumberRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_NUMBER */
	tlex_handlerfptr handler;
	boolean IsInt;
	long intval;
	double realval;
};
struct tlex_IDRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_ID */
	tlex_handlerfptr handler;
	boolean SaveText;
	Charset continueset;
};
struct tlex_WhitespaceRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_WHITESPACE */
	tlex_handlerfptr handler;
	boolean SaveText;
	Charset continueset;
};
struct tlex_CommentRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_COMMENT */
	tlex_handlerfptr handler;
	boolean SaveText;
	char *endseq;
};
struct tlex_StringRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_STRING */
	tlex_handlerfptr handler;
	boolean SaveText;
	char *endseq;
	char *escapechar;
	char *badchar;
};
struct tlex_ErrorRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_ERROR */
	tlex_handlerfptr handler;
	char *msg;
};


struct tlex_tables {
	struct tlex_Recparm **rectbl;
			/* array describing possible actions */
	short *action;	/* action for each initial character
			if value has tlex_ACTTHONG set,
				consult thongtbl using low bits as index
			if value has tlex_ACTSCAN bit set,
				call recognizer via rectbl
			otherwise treat as a standalone token
				with value as token number */
	int hichar;	/* action has elements for 0...hichar */
	int defaultaction;	/* action for characters above hichar */
	struct tlex_Recparm *reservedwordparm;
				/* points to a recparm struct for
				handling reserved words */
	char **thongtbl;	/* points to sorted array of thong strings
				If there are thongs beginning with the letter x,
				there is a one character entry for x as the
				first of the thongs for that letter.
				The last entry is followed by a zero length string. */
	char *thongsame;	/* thongsame[i] has as its value the number of
				leading characters which are the same between
				thongtbl[i-1] and thongtbl[i] */
	short *thongact;	/* array of action values for thongs */
	struct tlex_Recparm *global;	/* points to the global struct */
	struct tlex_ErrorRecparm *ErrorHandler; 
		/* ErrorHandler->handler is called by tlex_Error.
		If not specified, a dummy is created by gentlex;
		the dummy just prints the message.
		Clients should call tlex_Error instead of this handler. */
};

/* these values can be returned by C code handlers for token classes 
	in the .tlx file
   the value of a variable of type 'action' can also be returned
*/
#define tlex_ACCEPT (-1)
#define tlex_IGNORE (-2)

#endif

 
