;*******************************************************************************
;
; Graphical AI Tools Environment (GATE)
; Version 2.2
;
; ** Copyright (c) 1987 by Erik T. Mueller. All Rights Reserved.
;
;  2/23/87: First version written
;
;*******************************************************************************

;
; Testing for rules
;

(ty$create 'RULEOPER nil '(prop (obj) ()))
(ty$create 'RAND '(RULEOPER) nil)
(ty$create 'RSEQ '(RULEOPER) nil)
(ty$create 'ROR '(RULEOPER) nil)
(ty$create 'RNOT '(RULEOPER) nil)
(ty$create 'RTRUE '(RULEOPER) nil)
(ty$create 'RFALSE '(RULEOPER) nil)
(ty$create 'RCODE '(RULEOPER) nil)
(ty$create 'PERSON nil nil)
(ty$create 'FATHER-OF nil '(nil (actor obj) ()))
(ty$create 'MOTHER-OF nil '(nil (actor obj) ()))
(ty$create 'GRANDFATHER-OF nil '(nil (actor obj) ()))
(ty$create 'GRANDPARENT-OF nil '(nil (actor obj) ()))

(setq *prules* nil)

(ob$add-prule (ob$fcreate '(PRULE obname Grandfather-Rule
                                  subgoal (ROR obj (RAND obj (FATHER-OF actor ?Person1
                                                                        obj ?Person3)
                                                         obj (FATHER-OF actor ?Person3
                                                                        obj ?Person2))
                                               obj (RAND obj (FATHER-OF actor ?Person1
                                                                        obj ?Person3)
                                                         obj (MOTHER-OF actor ?Person3
                                                                        obj ?Person2)))
                                  goal (GRANDFATHER-OF actor ?Person1 obj ?Person2))))

(ob$add-prule (ob$fcreate '(PRULE obname Grandparent-Rule
                                  subgoal (GRANDFATHER-OF actor ?Person1 obj ?Person2)
                                  goal (GRANDPARENT-OF actor ?Person1 obj ?Person2))))
     
(setq *pfacts* (cx$create))

(ob$fcreate '(PERSON name "Roger" obname Schank))
(ob$fcreate '(PERSON name "Michael" obname Dyer))
(ob$fcreate '(PERSON name "Wendy" obname Lehnert))
(ob$fcreate '(PERSON name "Margot" obname Flowers))
(ob$fcreate '(PERSON name "Jack" obname Hodges))
(ob$fcreate '(PERSON name "Erik" obname Mueller))
(ob$fcreate '(PERSON name "Uri" obname Zernik))

(cx$assert *pfacts* (ob$fcreate '(FATHER-OF actor Schank
                                            obj Flowers)))

(cx$assert *pfacts* (ob$fcreate '(MOTHER-OF actor Flowers
                                            obj Hodges)))

(cx$assert *pfacts* (ob$fcreate '(FATHER-OF actor Dyer
                                            obj Mueller)))

(cx$assert *pfacts* (ob$fcreate '(FATHER-OF actor Dyer
                                            obj Zernik)))

(cx$assert *pfacts* (ob$fcreate '(MOTHER-OF actor Lehnert
                                            obj Dyer)))

(cx$assert *pfacts* (ob$fcreate '(FATHER-OF actor Schank
                                            obj Lehnert)))

(setq query (ob$fcreate '(GRANDFATHER-OF actor Schank obj Dyer)))

(setq x (ob$prove1 (ob$fcreate '(GRANDFATHER-OF actor Schank obj Dyer))
                  *empty-bd* 10 *prules* *pfacts* nil))

(setq x (ob$prove1 (ob$fcreate '(GRANDFATHER-OF actor Schank obj ?Person))
                  *empty-bd* 10 *prules* *pfacts* nil))

(setq x (ob$prove1 (ob$fcreate '(GRANDFATHER-OF actor Dyer obj Schank))
                  *empty-bd* 10 *prules* *pfacts* nil))

(ob$prove1 (ob$fcreate '(FATHER-OF actor Schank obj ?Person))
           *empty-bd* 10 *prules* *pfacts* nil)

(ob$prove1 (ob$fcreate '(GRANDFATHER-OF actor ?Person obj Dyer))
           *empty-bd* 10 *prules* *pfacts* nil)

(ob$prove1 (ob$fcreate '(GRANDFATHER-OF actor ?Person4 obj ?Person5))
           *empty-bd* 10 *prules* *pfacts* nil)

(ob$prove1 (ob$fcreate '(GRANDPARENT-OF actor ?Person4 obj ?Person5))
           *empty-bd* 10 *prules* *pfacts* nil)

(ob$prove1 (ob$fcreate '(FATHER-OF actor ?Person4 obj ?Person5))
           *empty-bd* 10 *prules* *pfacts* nil)
