;*******************************************************************************
;
; DAYDREAMER Version 3.4
;
; ** Copyright (c) 1986 by Erik T. Mueller. All Rights Reserved.
;
;*******************************************************************************

(progn
 (setq *dd-version* "DAYDREAMER 3.4, Common Lisp version of 19990506")
 (format t "=======================~%")
 (format t "Loading ~A...~%" *dd-version*)
 (format t "=======================~%")
 nil)

;*******************************************************************************
; GATE parameters
;*******************************************************************************

(setq *default-line-link?* t)
(setq *link-upper-case?* t)
(setq *refresh* nil)

(setq *unify-debugging?* t)
(setq *global-switches* nil)

(if (not (boundp '*typeset?*))
    (setq *typeset?* nil)
    nil)

(cond
 (*typeset?*
  (setq *ob-print-options* '(PARENS NEVER-PROP TYPESET))
  (setq *ob-sprint-options* '(no-newline short parens never-prop typeset)))
 (else
  (setq *ob-print-options* '(PARENS NEVER-PROP))
  (setq *ob-sprint-options* '(no-newline short parens never-prop))))
 
(defmacro with-no-dbg (&rest rest)
  `(unwind-protect
    (progn
     (do-interest #'disinterest)
     ,@rest)
    (do-interest #'interest)))

(defun do-interest (proc)
  (funcall proc 'rule 'all)
;  (funcall proc 'rule-long 'all) ; interleaved but not activated processes.
;  (funcall proc 'rule-xtra 'all)
  (funcall proc 'task 'all)
  (funcall proc 'ep-store 'all) (funcall proc 'remind 'all)
  (funcall proc 'desire 'all) (funcall proc 'simil 'all)
  (funcall proc 'analogy 'all)
  (funcall proc 'night 'all)
;  (funcall proc 'seren-long 'all)
;  (funcall proc 'ri 'all)
;  (funcall proc 'chain 'all)
;  (funcall proc 'inference 'all)
;  (funcall proc 'depend 'all)
;  (funcall proc 'show 'all)
)

(do-interest #'interest)

;*******************************************************************************
; Load DAYDREAMER code files
;*******************************************************************************

(defmacro self-type-ok? (rule self)
  `(or (null? (ob$gets ,rule 'self-type))
       (any? (lambda (x) (ty$instance-of? ,self x))
             (ob$gets ,rule 'self-type))))

(load "dd_utils.cl")
(load "dd_cntrl.cl")
(load "dd_rule1.cl")
(load "dd_rule2.cl")
(load "dd_epis.cl")
(load "dd_reversal.cl")
(load "dd_mutation.cl")
(load "dd_ri.cl")
(load "dd_night.cl")

;*******************************************************************************
; Decide what to load
;*******************************************************************************

(setq *subsets* *gate-load-options*)

(defun reset-input ()
  (if (memq? 'input-script *gate-load-options*)
      (setq *gate-input* (open "input.txt")))
  (if (memq? 'job-exp1-alone *gate-load-options*)
      (setq *gate-input* (open "inputjob.txt")))
  (if (memq? 'seren1-alone *gate-load-options*)
    (setq *gate-input* (open "inputser.txt")))
  (if (memq? 'lovers-alone *gate-load-options*)
    (setq *gate-input* (open "inputlov.txt"))))

(reset-input)

(if (memq? 'silent-gc *gate-load-options*)
  (setq (gc-noisily?) nil))

; Debugging variables for use in T3
(setq *x* nil)
(setq *y* nil)
(setq *z* nil)

(defun htlg ()
  (ob$set (car *top-level-goals*) 'status 'halted))

(defun hlt (gl)
  (ob$set gl 'status 'halted))

;*******************************************************************************
; Load DAYDREAMER representation file
;*******************************************************************************

(epmem-init)
(load "dd_rep.cl")

(defun open-dbg ()
   (setq *trc-file* (open (new-filename "trace") :direction :output))
   (if (memq? 'no-stdout *gate-load-options*)
       (setq *gate-dbg* *trc-file*)
       (setq *gate-dbg* (make-broadcast-stream *trc-file*
                         (standard-output))))
;   (setq *gen-stream* (make-gen-stream *gate-dbg*))
   (setq *gen-stream* *gate-dbg*)
)

(defun stdout-back ()
  (setq *gate-load-options* (delq! 'no-stdout *gate-load-options*))
  (close-dbg))

(load "dd_gen.cl")

; Set up streams
(open-dbg)

(defun quit ()
  (close-dbg)
  (exit))

(defun close-dbg ()
  (close *trc-file*)
  (setq *gate-dbg* (standard-output))
  (open-dbg))

; Use (interest 'unify ^rule) and (interest 'show ^rule)
; to get full debugging info for a rule. (And use disinterest
; to turn off).

(defun int ()
  (interest 'unify (ob$name->ob 'neg-att-inf))
  (interest 'show (ob$name->ob 'neg-att-inf)))

(defun dis ()
  (disinterest 'unify (ob$name->ob 'neg-att-inf))
  (disinterest 'show (ob$name->ob 'neg-att-inf)))

(format t "=======================~%")
(format t "Welcome to ~A~%" *dd-version*)
(format t "Bugs/problems/questions to erik@signiform.com~%")
(format t "=======================~%")
(format t "Type (daydreamer) to run...~%")

; End of file
