//======================================================================
//  samp_time.cpp   -   sample program using aipTime.h
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  08/02/18  [BRM] Began development
//
//----------------------------------------------------------------------
//  Building the executable
//
//  This is very generic, standard C++.  The files:
//      aipTime.h    aipTime.cpp   aipTime_samp.cpp
//  
//  On Linux, you can call the compiler gcc or g++ (although on
//  Fedora, use g++ because gcc finds the wrong libraries)...
//
//    gcc -osamp_time samp_time.cpp aipTime.cpp
//
//
//----------------------------------------------------------------------

#include <iostream>
#include "aipTime.h"

using namespace std;

int main () {

  // We know about argc and argv, but the Borland compiler
  // does not like them if they are not used.

  // This is really just a lot of simple examples to do
  // a moderate amount of testing.

//------------------------------------------------
//      Date and Time

  cout << "\n      Date and Time\n\n";

  long  num, tyear, tmon, tday, thour, tmin, tsec;
  char  smon[4], sweekday[4];

  aipTime t1(1995,7,06);
  if (!t1.is_valid()) cout << "Error 1\n";
  char st1[31];
  t1.dd_mon_yyyy(st1);

  aipTime t3(19960229);
  if (!t3.is_valid()) cout << "Error 3\n";
  char st3[31];
  t3.dd_mon_yyyy(st3);
  if (t1 < t3) {
    cout << st1 << " is less than " << st3 << "\n";
  } else {
    cout << "Error 3a\n";
  }

  aipTime t4(t3);
  if (!t4.is_valid()) cout << "Error 4\n";
  char st4[31];
  t4.dd_mon_yyyy(st4);
  long ldate = t4.yyyymmdd();
  aipTime t4a(ldate);
  if (t4 != t3) {
    cout << "Error 4a\n";
  } else if (t4 != t4a) {
    cout << "Error 4b\n";
  }
  char st4a[31];
  t4a.dd_mm_yy(st4a);
  char st4b[31];
  t4a.dd_mm_yyyy(st4b);
  aipTime t4c("1996-02-29");
  if (!t4c.is_valid()) cout << "Error 4c\n";
  char st4c[31];
  t4c.yyyy_mm_dd(st4c);
  
  cout << st4 << " = " << st4a << " = " << st4b << " = "
       << ldate << " = " << st4c << "\n";

  aipTime t5("29 Feb 2000 16:30");
  if (!t5.is_valid()) cout << "Error 5\n";
  char st5[31];
  t5.dd_mon_yyyy_hh_mm(st5);
  if (t5 > t4) {
    cout << st5 << " is greater than " << st4 << "\n";
  } else {
    cout << "Error 5a\n";
  } 

  aipTime t7("23/Aug/2007_16:30");
  if (!t7.is_valid()) cout << "Error 7\n";
  char st7[31];
  t7.dd_mon_yyyy_hh_mm(st7);

  aipTime t8("23-08-2007 4:30 pm");
  if (!t8.is_valid()) cout << "Error 8\n";
  char st8[31];
  t8.dd_mon_yyyy_hh_mm(st8);
  if (t8 == t7) {
    cout << st8 << " equals " << st7 << "\n";
  } else {
    cout << "Error 8a: " << st8 << " != " << st7 << "\n";
  }

  aipTime t9("23 Aug 07 4:30 am");
  if (!t9.is_valid()) cout << "Error 9\n";
  char st9[31];
  t9.dd_mon_yyyy_hh_mm(st9);
  if (t9 < t8) {
    cout << st9 << " is less than " << st8 << "\n";
  } else {
    cout << "Error 9a\n";
  }
  t9 = t8;
  t9.dd_mon_yyyy_hh_mm(st9);
  cout << "Assignment: " << st9 << " now equals " << st8 << "\n";
  if (t9 != t8) cout << "Error 9b\n";

  cout << "hhmm of " << st9 << " is " << t9.hhmm() << "\n";

  aipTime t10("11 jan 2008 18:30");
  if (!t10.is_valid()) cout << "Error 10\n";
  char st10[31];
  t10.dd_mon_yyyy_hh_mm(st10);
  t10.get(&tyear, &tmon, &tday, &thour, &tmin, &tsec,
          smon, sweekday);
  if (tmon != 1) cout << "Error 10a\n";
  cout << "11/Jan/2008_18:30 is "
       << st10 << " is " << sweekday << " " << tday << " " 
       << smon << " " << tyear << " " 
       << thour << ":";
  if (tmin < 10) cout << "0";
  cout << tmin << "\n";
  num = t10.days_since_sunday();
  cout << " which is " << num << " days since Sunday\n";
  num = t10.days_since_jan1();
  cout << " and " << num << " days since Jan 1\n";
  t10.add_hours(3);
  t10.dd_mon_yyyy_hh_mm(st10);
  cout << st10 << " is 3 hours later\n";

  aipTime t11(2008,12,27,23,55);
  if (!t11.is_valid()) cout << "Error 11\n";
  char st11[31];
  t11.dd_mon_yyyy_hh_mm(st11);

  aipTime t12 = t11;
  if (!t12.is_valid()) cout << "Error 12\n";
  t12.add_days(4);
  char st12[31];
  t12.dd_mon_yyyy_hh_mm(st12);
  long dday = t12.days_since(t11);
  cout << st12 << " is " << dday << " days since " << st11 << "\n";
  aipTime t12a = t12;
  t12a.add_seconds(600);
  char st12a[31];
  t12a.dd_mon_yyyy_hh_mm(st12a);
  long dmin = t12a.minutes_since(t12);
  long ahour = t12a.hours_after(t12);
  long aday = t12a.days_after(t12);
  cout << st12a << " is " << dmin 
       << " minutes since " << st12 << "\n";
  cout << "  (also " << ahour << " hour after"
       << "  and " << aday << " day after)\n";

  long yr1, yr2;
  yr1 = 1999;  yr2 = 2000;
  cout << yr1 << " is";
  if ( ! aip_is_leap_year(yr1) ) cout << " not";
  cout << " a leap year;   ";
  cout << yr2 << " is";
  if ( ! aip_is_leap_year(yr2) ) cout << " not";
  cout << " a leap year\n";
  yr1 = 2008;  yr2 = 2009;
  cout << yr1 << " is";
  if ( ! aip_is_leap_year(yr1) ) cout << " not";
  cout << " a leap year;   ";
  cout << yr2 << " is";
  if ( ! aip_is_leap_year(yr2) ) cout << " not";
  cout << " a leap year\n";

//------------------------------------------------

  cout << "\n      Time of Day\n\n";

  aipTimeOfDay tod1(16,30);    // 4:30 pm on a 24 hour clock
  char stod1[11];
  tod1.hh_mm (stod1);

  aipTimeOfDay tod2(tod1);
  char stod2[11];
  tod2.hh_mm (stod2);
  char stod2a[11];
  tod2.hh_mm_ss (stod2a);   // insert format

  aipTimeOfDay tod3("16:45");
  char stod3[11];
  tod3.hh_mm (stod3);

  aipTimeOfDay tod4("09:00 pm");
  char stod4[11];
  tod4.hh_mm_12 (stod4);

  aipTimeOfDay tod5("09:00 AM");
  char stod5[11];
  tod5.hh_mm_12 (stod5);

  aipTimeOfDay tod6("9:00 am");
  char stod6[11];
  tod6.hh_mm_12 (stod6);

  if (tod1 == tod2) {
    cout << stod1 << " == " << stod2 << " == " << stod2a << "\n";
  } else {
    cout << "ERROR with  == operator\n";
  }

  if (tod4 > tod3) {
    cout << stod4 << "  > " << stod3 << "\n";
  } else {
    cout << "ERROR with  > operator\n";
  }

  if (tod5 < tod3 &&
      tod6 < tod2) {
    cout << stod5 << "  < " << stod3 << " and "
         << stod6 << "  < " << stod2 << "\n";
  } else {
    cout << "ERROR with  < operator\n";
  }

  aipTimeOfDay tod7(0,0);
  tod7 = tod6;
  char stod7[11];
  tod7.hh_mm_12 (stod7);
  cout << "Assignment: " << stod7 << 
             " now equals " << stod6 << "\n";

  aipTimeOfDay tod8 = tod7;
  tod8.add_hours(4);
  char stod8[11];
  tod8.hh_mm (stod8);
  long dhour = tod8.hours_since(tod7);
  cout << stod8 << " is " 
       << dhour << " hours after " << stod7 << "\n";
  aipTimeOfDay tod8a = tod8;
  tod8a.add_minutes(15);
  tod8a.hh_mm (stod8);
  long dminute = tod8a.minutes_since(tod8);
  cout << stod8 << " is " <<
          dminute << " minutes after that" << "\n";

//------------------------------------------------

  cout << "\n";

//------------------------------------------------

  return 0;

}


//======================================================================
