//======================================================================
//  samp_good.cpp   -   sample program using aipGood.h
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  05/09/07  [BRM] removed importance and likelihood
//  05/07/31  [BRM] Reworked this sample program.
//
//----------------------------------------------------------------------
//  Building the executable
//
//  This is very generic, standard C++.  The files:
//      aipGood.h    aipGood.cpp   aipGood_samp.cpp
//  
//  On Linux, you can call the compiler gcc or g++ (although on
//  Fedora, use g++ because gcc finds the wrong libraries)...
//
//    gcc -osamp_good samp_good.cpp aipGood.cpp
//
//
//----------------------------------------------------------------------

#include <iostream>
#include "aipGood.h"

using namespace std;

int main () {

  // We know about argc and argv, but the Borland compiler
  // does not like them if they are not used.

  // There is nothing subtle about the way the following code is
  // written - it just illustrates different ways of doing things.

  // Note that aipG is a typedef for aipGoodness

//------------------------------------------------
//  Having to get up at 7:00 is Fairly-Bad, 
//    but being watch the News on tv is Fairly-Good,
//    and the being-late-for-work factor is Slightly-Bad
//    because it is very important, but highly-unlikely.

  aipGoodness g_sleep_to_700 = aipFairlyBad;
  aipG g_watch_news = aipFairlyGood;
  g_sleep_to_700 += g_watch_news;
  aipG g_700_late_for_work = aipSlightlyBad;
  g_sleep_to_700 = g_sleep_to_700 + g_700_late_for_work;

//------------------------------------------------
//  Having to get up at 7:30 is Slightly-Bad,
//    and there is radio news that is Somewhat-Good,
//    and the being-late-for-work factor is Somewhat-Bad
//    because being late is a little more likely.

  aipGoodness g_sleep_to_730 = aipSlightlyBad;
  aipG g_radio_news = aipSomewhatGood;
  g_sleep_to_730 += g_radio_news;
  aipG g_730_late_for_work = aipSomewhatBad;
  g_sleep_to_730 += g_730_late_for_work;

//------------------------------------------------
//  Having to get up at 8:00 is Good,
//    and the being-late-for-work factor is Quite-Bad,
//    because there is a greater chance of being late.

  aipGoodness g_sleep_to_800 = aipGood;
  g_sleep_to_800 += aipSomewhatGood;  // Radio news.
  g_sleep_to_800 += aipQuiteBad;  // Maybe late for work.

//------------------------------------------------
//  Compare the results.

  cout << "\n";

  cout << "Getting up at 7:00 is " 
       << g_sleep_to_700.description() << "\n";

  cout << "Getting up at 7:30 is " 
       << g_sleep_to_730.description() << "\n";

  cout << "Getting up at 8:00 is " 
       << g_sleep_to_800.description() << "\n";

  cout << "\n";

  cout << "Note that, individually, these values " 
         << "may not be meaningful - \n";
  cout << "  it is the difference between them "
         << "that is useful...\n";

  cout << "\n";

  if (g_sleep_to_700 > g_sleep_to_730 && 
      g_sleep_to_700 > g_sleep_to_800) {

      cout << "Geting up at 7:00 is best.\n";

  } else if (g_sleep_to_730 > g_sleep_to_700 && 
             g_sleep_to_730 > g_sleep_to_800) {

      cout << "Geting up at 7:30 is best.\n";

  } else {

      cout << "Geting up at 8:00 is best.\n";

  }

  cout << "\n";

  return 0;

}


//======================================================================
