//======================================================================
//  samp_deer_fear.cpp  -  function bodies for samp_deer_fear.h
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  05/09/17  [BRM] development begins
//
//----------------------------------------------------------------------

#include "samp_deer_fear.h"


//======================================================================
//  DeerDecision
//
//----------------------------------------------------------------------
//  add_deer_option

void DeerDecision::add_deer_option (DeerOption *x) {

  add_option(x);
  if (x->option_fear()) m_stay_fear_ptr = x->option_fear();

}

//======================================================================
//  StayOption
//
//----------------------------------------------------------------------
//  g_opt

aipG StayOption::g_opt() { 

  return m_fear ? m_fear->g() : aipNeutral; 

}

//======================================================================
//  FearSmellWolf
//
//----------------------------------------------------------------------
//  take_msg

void FearSmellWolf::take_msg (aipMsg *m) {

  if (!m || m->typ() != Info_Smell_Wolf) return;

  if (m->subtyp() == Info_Weak) {
    emotion()->strengthen(aipIntensity_A_Fair_Bit);
  } else if (m->subtyp() == Info_Medium) {
    emotion()->strengthen(aipIntensity_Quite_A_Bit);
  } else if (m->subtyp() == Info_Strong) {
    emotion()->strengthen(aipIntensity_A_Lot);
  }

}

//======================================================================
//  FearHearNoise
//
//----------------------------------------------------------------------
//  take_msg

void FearHearNoise::take_msg (aipMsg *m) {

  if (!m || m->typ() != Info_Hear_Noise) return;

  if (emotion()->g() < aipFairlyBad) {           //  jumpy

    if (m->subtyp() == Info_Weak) {
      emotion()->strengthen(aipIntensity_Somewhat);
    } else if (m->subtyp() == Info_Medium) {
      emotion()->strengthen(aipIntensity_A_Fair_Bit);
    } else if (m->subtyp() == Info_Strong) {
      emotion()->strengthen(aipIntensity_Quite_A_Bit);
    }

  } else if (emotion()->g() < aipSomewhatBad) {  // wary

    if (m->subtyp() == Info_Weak) {
      emotion()->strengthen(aipIntensity_A_Little);
    } else if (m->subtyp() == Info_Medium) {
      emotion()->strengthen(aipIntensity_Somewhat);
    } else if (m->subtyp() == Info_Strong) {
      emotion()->strengthen(aipIntensity_A_Fair_Bit);
    }

  } else {

    if (m->subtyp() == Info_Weak) {
      emotion()->strengthen(aipIntensity_Slightly);
    } else if (m->subtyp() == Info_Medium) {
      emotion()->strengthen(aipIntensity_A_Little);
    } else if (m->subtyp() == Info_Strong) {
      emotion()->strengthen(aipIntensity_Somewhat);
    }

  }

}


//======================================================================
//  FearSeemsSafe
//
//----------------------------------------------------------------------
//  take_msg

void FearSeemsSafe::take_msg (aipMsg *m) {

  if (!m || m->typ() != Info_Seems_Safe) return;

  emotion()->weaken(aipIntensity_A_Little);

}

//======================================================================
//  DeerMsg  -  message of/in a deer that is passed to the decision
//
//----------------------------------------------------------------------
//  typ_description

const char *  DeerMsg::typ_description () {

  if (typ() == Info_Seems_Safe) {
    return "Seems Safe";
  } else if (typ() == Info_Smell_Wolf) {
    return "Smell Wolf";
  } else if (typ() == Info_Hear_Noise) {
    return "Hear Noise";
  }

  return "<unknown> ";

}

//----------------------------------------------------------------------
//  description to log

const char * DeerMsg::subtyp_description () {

  if (typ() == Info_Seems_Safe) {
    return "        ";
  } else {
    if (subtyp() == Info_Weak) {
      return "(weak)  ";
    } else if (subtyp() == Info_Medium) {
      return "(medium)";
    } else if (subtyp() == Info_Strong) {
      return "(strong)";
    }
  }

  return "<unknown> ";

}

//======================================================================
