//**********************************************************************
//  rr_solve.cpp  -  function bodies for rr_solve.h
//
//  Copyright (c)  2008  Brian Marshall
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  08/01/21  [BRM] began development: split out layer from staffwhen
//
//----------------------------------------------------------------------

#include "rr_solve.h"

#include <string.h>
#include <iostream>
using namespace std;

//======================================================================
//  rrsReqImp  -  importance of a requirement
//
//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsReqImp::take_msg (aipMsg *mm) {

  aipHHImportance::take_msg(mm);

  rrsMsg *m = (rrsMsg *)mm;

  if (m->typ() == HH_Starting_New_Try) {
    m_left_bhnd = 0;
  }

}

//----------------------------------------------------------------------
//  Note that a decision for this requirement has been decided.

void rrsReqImp::note_rrs_decide (rrsDecision *d, rrsOption *o) {

  // o (ptr to an option) may be null

  if (d && o) {

    m_left_bhnd -= 1;

  }

}

//======================================================================
//  rrsProblem
//
//----------------------------------------------------------------------
//  Constructor

rrsProblem::rrsProblem () {

  m_requirements = new aipPandemonium;
  m_resources = new aipPandemonium;

  m_should_log_options = 0;

}

//----------------------------------------------------------------------
//  Destructor

rrsProblem::~rrsProblem () {

  if (m_requirements) delete m_requirements;
  if (m_resources) delete m_resources;

}

//----------------------------------------------------------------------
//  add_requirement

void rrsProblem::add_requirement (rrsRequirement *x) { 

  if (!x) return;

  m_requirements->add (x);

}

//----------------------------------------------------------------------
//  add_resource

void rrsProblem::add_resource (rrsResource *x) { 

  if (!x) return;

  m_resources->add (x);

}

//----------------------------------------------------------------------
//  add_decision

void rrsProblem::add_decision (rrsDecision *x) { 

  add_hh_decision(x); 

}

//----------------------------------------------------------------------
//  In a try, choose the next decision to decide.

aipHHDecision * rrsProblem::next_decision() {

  rrsReqDay *rd;

// <<<<< can make dcsn trivial (I think) but have to call hh decide function
//  rd = trivial_reqday();
//cout << "** found a trivial reqday - forced exit\n";  ?????
//exit(1);
//  if (rd) return rd->dcsn();

  rrsDecision * best_dcsn = 0;
  long          best_dcsn_imp = -999999999;

  rrsRequirementItr itr = requirement_iterator();
  for ( rrsRequirement * req = itr.first(); req; req = itr.next() ) {
    rd = req->first_unsatisfied_reqday();
    if (rd) {
      rrsDecision *dcsn = rd->dcsn();
      if (dcsn) {
        long dcsn_imp = dcsn->imp();
        if (!best_dcsn || dcsn_imp > best_dcsn_imp) {
          best_dcsn = dcsn;
          best_dcsn_imp = dcsn_imp;
        }
      }
    }
  }

  return best_dcsn;

}

//----------------------------------------------------------------------
//  requirement_iterator - return an iterator: requirements in the problem

rrsRequirementItr rrsProblem::requirement_iterator() const {

  rrsRequirementItr i(m_requirements);

  return i;

}

//----------------------------------------------------------------------
//  resource_iterator  - return an iterator: resources in the problem

rrsResourceItr rrsProblem::resource_iterator() const {

  rrsResourceItr i(m_resources);

  return i;

}

//----------------------------------------------------------------------
//  decision_iterator - return an iterator: decisions in the problem

rrsDecisionItr rrsProblem::decision_iterator() const {

  rrsDecisionItr i(decision_pandemonium());

  return i;

}

//----------------------------------------------------------------------
//  too_bad_to_go_on

aipG rrsProblem::too_bad_to_go_on() const {

//  aipHHSolveStat *ss = solve_stat();
//  return ss->g_cmp_bsf().calc_fraction(3,2);  from samp_a_to_b

  return aipForbidden;  // default from aipHHProblem

}

//----------------------------------------------------------------------
//  log_this_try  - to cout - for debugging or watching the thing work
//
//  This works best if decisions are stored in Req,Day order

void rrsProblem::log_this_try () {

  aipHHSolveStat *ss = solve_stat();

  cout << "\n===== Try " << ss->i_try()+1 << "...\n";

  rrsRequirement  *req_prev = 0;
  aipTime day_prev = aipTime(19010101);

  rrsDecisionItr itr = decision_iterator();
  for ( rrsDecision * dcsn = itr.first(); dcsn; dcsn = itr.next() ) {

    rrsReqDay   *reqday  = dcsn->reqday();
    rrsRequirement *req  = reqday->req();
    aipTime      day     = reqday->day();
    rrsOption   *opt     = dcsn->rrs_opt_cur();
    rrsResource *res     = opt ? opt->resday()->res() : 0;

    if (req != req_prev) {
      cout << "\nReq: " << req->id();
      req_prev = req;
    }

    if (day != day_prev) {
      char cday[21];
      day.dd_mon_yyyy(cday);
      cout << "  Day: " << cday;
      day_prev = day;
    }

    if (res) cout << " " << res->id();

  }
  cout << "\n";

  cout << "-- Goodness of this try: " 
       << ss->g_usr_cur().numeric_value() 
       << "    ";

  if (ss->try_result() == HH_Try_Has_Failed) {
    if (ss->is_too_bad()) cout << "(quit)";
  } else if (ss->try_result() == HH_Try_Is_New_Best) {
    cout << "(New Best)";
  } else if (ss->try_result() == HH_Try_Is_A_Best) {
    cout << "(a best)";
  } else if (ss->try_result() == HH_Try_Is_Improved) {
    cout << "(improved)";
  } else if (ss->try_result() == HH_Try_Is_Changed) {
    cout << "(changed)";
  }

  cout << "\n";

  if (ss->is_many_since_new_best()) {
    cout << "   ... many tries since new best ...\n";
  }

  if (ss->is_many_since_improve()) {
    cout << "   ... many tries since improve ...\n";
  }

  if (ss->is_many_since_change()) {
    cout << "   ... many tries since change ...\n";
  }

}

//----------------------------------------------------------------------
//  take_msg 

void rrsProblem::take_msg (aipMsg *mm) {

  aipHHProblem::take_msg(mm);  // pass message to parent class

  m_requirements->take_msg(mm);
  m_resources->take_msg(mm);

}

//----------------------------------------------------------------------
//  Note that a decision has been decided

void rrsProblem::note_decide (aipHHDecision *dd, aipHHOption *oo) {

  if (!dd) return;

  aipHHProblem::note_decide (dd, oo);

  rrsDecision *d = (rrsDecision*)dd;
  rrsOption   *o = (rrsOption*)oo;

  rrsReqDay *reqd = d->reqday();
  if (!reqd) return;

  rrsRequirement *req = reqd->req();
  if (!req) return;

  req->note_rrs_decide (d, o);
  reqd->note_rrs_decide (d, o);

  if (o) {   // if an option was chosen

    rrsResDay *resd = o->resday();
    if (!resd) return;

    rrsResource *res = resd->res();
    if (!res) return;

    res->note_rrs_decide (d, o);
    resd->note_rrs_decide (d, o);

  }

}


//----------------------------------------------------------------------
//  Return a requirement-day that has just enough options left, so we
//  can decide the decisions the remaining number of times and 
//  for each decide, take the first available option.

//rrsReqDay * rrsProblem::trivial_reqday () const {

//  rrsReqDay *rd;

//  rrsRequirementItr itr = requirement_iterator();
//  for ( rrsRequirement *req = itr.first(); req; req = itr.next() ) {
//    rd = req->trivial_reqday();
//    if (rd) return rd;
//  }

//  return 0;

//}


//----------------------------------------------------------------------
//  solve_rr_problem  - solve a staffwhen staff scheduling problem
//
//  return 1 (true) if a schedule is found, zero otherwise

int rrsProblem::solve_rr_problem () {

  aipG g = solve();                    // high-hope solve

  if (g.is_forbidden()) return 0;

  return 1;

}


//======================================================================
//  rrsDecision
//
//----------------------------------------------------------------------
//  Constructor

rrsDecision::rrsDecision (rrsReqDay *a_reqday, long num_to_decide) 
                                      : aipHHDecision(num_to_decide) {

  m_reqday = a_reqday;

}

//----------------------------------------------------------------------
//  Destructor

rrsDecision::~rrsDecision () {}

//----------------------------------------------------------------------
//  add_rrs_option

void rrsDecision::add_rrs_option (rrsOption *o) { 

  add_hh_option(o); 

  if ( o && o->resday() ) o->resday()->add_opt(o);


}

//----------------------------------------------------------------------
//  Return the importance of this decision

long rrsDecision::imp () const {

  if (!m_reqday) return -999999;

  rrsRequirement *req = m_reqday->req();
  if (!req) return -999999;

  return aipHHDecision::imp() + req->imp() + m_reqday->imp();

}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsDecision::take_msg (aipMsg *mm) {

  aipHHDecision::take_msg(mm);  // pass message to parent class

//  rrsMsg *m = (rrsMsg *)mm;

//  if (m->typ() == HH_Starting_New_Try) {
//    reset_is_trivial();
//  }

}

//======================================================================
//  rrsOption  -  an resource working a requirement on a day
//
//----------------------------------------------------------------------
//  Constructor

rrsOption::rrsOption(rrsResDay *a_resday, aipG g_static)
                                   : aipHHOption(g_static) {

  m_resday = a_resday;

  m_g_dynamic = aipNeutral;

}

//----------------------------------------------------------------------
//  Destructor

rrsOption::~rrsOption() {}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsOption::take_msg (aipMsg *mm) {

  aipHHOption::take_msg(mm);  // pass message to parent class

  rrsMsg *m = (rrsMsg *)mm;

  if (m->typ() == HH_Starting_New_Try) {
    m_g_dynamic = aipNeutral;
  }

}

//----------------------------------------------------------------------
//  set_g_dynamic

void rrsOption::set_g_dynamic (aipG x) { m_g_dynamic  = x; }

//----------------------------------------------------------------------
//  add_g_dynamic

void rrsOption::add_g_dynamic (aipG x) { m_g_dynamic += x; }

//----------------------------------------------------------------------
//  g_opt

aipG rrsOption::g_opt() {

  return aipHHOption::g_opt() + g_user_constant() + m_g_dynamic;

}

//----------------------------------------------------------------------
//  g_opt_cmp

aipG rrsOption::g_opt_cmp() { return g_user_constant() + m_g_dynamic; }

//----------------------------------------------------------------------
//  g_opt_usr

aipG rrsOption::g_opt_usr() { return g_user_constant() + m_g_dynamic; }

//======================================================================
//  rrsRequirement
//
//----------------------------------------------------------------------
//  Constructor

rrsRequirement::rrsRequirement (long a_id, rrsProblem *a_prob) {

  m_id = a_id;
  m_prob = a_prob;

  m_reqdays = new aipPandemonium;

  m_hope = new aipHHHope;

}

//----------------------------------------------------------------------
//  Destructor

rrsRequirement::~rrsRequirement () {

  if (m_reqdays) delete m_reqdays;

  if (m_hope) delete m_hope;

}

//----------------------------------------------------------------------
//  add_reqday

void rrsRequirement::add_reqday (rrsReqDay *x) {

  if (!x) return;

  m_reqdays->add (x);

}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsRequirement::take_msg (aipMsg *mm) {

  rrsMsg *m = (rrsMsg *)mm;

  m->set_is_in_cur_solution(1);
  m_hope->take_msg(mm);
  m_importance.take_msg(mm);

  m_reqdays->take_msg(mm);

}

//----------------------------------------------------------------------
//  Note that a decision for this requirement has been decided

void rrsRequirement::note_rrs_decide (rrsDecision *d, rrsOption *o) {

  // o (ptr to an option) may be null

  m_importance.note_rrs_decide(d, o);

}


//----------------------------------------------------------------------
//  Return true if all req-days are satisfied

int rrsRequirement::is_satisfied () const {

  rrsReqDay *rd = first_unsatisfied_reqday();

  return rd ? 0 : 1;

}


//----------------------------------------------------------------------
//  Return the first unsatisfied requirement-day

rrsReqDay * rrsRequirement::first_unsatisfied_reqday () const {

  rrsReqDayItr itr = reqday_iterator();

  for ( rrsReqDay *prd = itr.first(); prd; prd = itr.next() ) {
    if ( ! prd->is_satisfied() ) return prd;
  }

  return 0;

}

//----------------------------------------------------------------------
//  Return a requirement-day that has just enough options left, so we
//  can decide the decisions the remaining number of times and 
//  for each decide, take the first available option.

//rrsReqDay * rrsRequirement::trivial_reqday () const {

//  rrsReqDayItr itr = reqday_iterator();
//  for ( rrsReqDay *rd = itr.first(); rd; rd = itr.next() ) {
//    if ( !(rd->has_surplus_opts()) ) return rd;
//  }

//  return 0;

//}


//----------------------------------------------------------------------
//  return an iterator: requirement-days for the requirement

rrsReqDayItr  rrsRequirement::reqday_iterator() const {

  rrsReqDayItr i(m_reqdays);

  return i;

}

//======================================================================
//  rrsReqDay
//
//----------------------------------------------------------------------
//  Constructor
//
//  set_dcsn() must be called after the decision is created

rrsReqDay::rrsReqDay (rrsRequirement *a_req, long a_yyyymmdd) {

  m_req  = a_req;
  m_day  = aipTime(a_yyyymmdd);
  m_dcsn = 0;

  m_hope = new aipHHHope;

}

//----------------------------------------------------------------------
//  Destructor

rrsReqDay::~rrsReqDay () {

  if (m_hope) delete m_hope;

}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsReqDay::take_msg (aipMsg *mm) {

  rrsMsg *m = (rrsMsg *)mm;

  m->set_is_in_cur_solution(1);
  m_hope->take_msg(mm);
  m_importance.take_msg(mm);

}

//----------------------------------------------------------------------
//  Note that a decision for this requirement-day has been decided

void rrsReqDay::note_rrs_decide (rrsDecision *d, rrsOption *o) {

  // o (ptr to an option) may be null

  if (!d) {
    if (o) {
      log ("rrsReqDay d is null");
    } else {
      log ("rrsReqDay d,o are null");
    }
  }
    
}


//----------------------------------------------------------------------
//  Return true if the reqday has all the resourcess it needs

int rrsReqDay::is_satisfied () const {

  if ( m_dcsn && m_dcsn->is_decided() ) return 1;

  return 0;

}

//----------------------------------------------------------------------
//  Return true if the reqday has more than enough options

int rrsReqDay::has_surplus_opts () const {

  if (!m_dcsn) return 0;

  long remaining_to_decide = m_dcsn->num_to_decide() - 
                             m_dcsn->num_decided();

  if (m_dcsn->num_opt_remaining() > remaining_to_decide) return 1;

  return 0;

}

//======================================================================
//  rrsResource
//
//----------------------------------------------------------------------
//  Constructor

rrsResource::rrsResource (long a_id, rrsProblem *a_prob) {

  m_id = a_id;
  m_prob = a_prob;

  m_resdays = new aipPandemonium;

  m_hope = new aipHHHope;
  m_is_in_cur_solution = 0;

}

//----------------------------------------------------------------------
//  Destructor

rrsResource::~rrsResource () {

  if (m_resdays) delete m_resdays;

  if (m_hope) delete m_hope;

}

//----------------------------------------------------------------------
//  add_resday

void rrsResource::add_resday (rrsResDay *x) {

  if (!x) return;

  m_resdays->add (x);

}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsResource::take_msg (aipMsg *mm) {

  rrsMsg *m = (rrsMsg *)mm;

  if (m->typ() == HH_Starting_New_Try) {
    m_is_in_cur_solution = 0;
  }

  m->set_is_in_cur_solution(m_is_in_cur_solution);
  m_hope->take_msg(mm);

  m_resdays->take_msg(mm);

}

//----------------------------------------------------------------------
//  Note that a decision involving this resource has been decided

void rrsResource::note_rrs_decide (rrsDecision *d, rrsOption *o) {

  if (!d) log ("rrsReqDay d is null");

  // o (ptr to an option) may be null

  if (o) m_is_in_cur_solution = 1;

}


//----------------------------------------------------------------------
//  resday_iterator

rrsResDayItr  rrsResource::resday_iterator() const {

  rrsResDayItr i(m_resdays);

  return i;

}

//======================================================================
//  rrsResDay
//
//----------------------------------------------------------------------
//  Constructor

rrsResDay::rrsResDay (rrsResource *a_res, long a_yyyymmdd) {

  m_res = a_res;
  m_day = aipTime(a_yyyymmdd);

  m_opts = new aipPandemonium;

  m_hope = new aipHHHope;

}

//----------------------------------------------------------------------
//  Destructor

rrsResDay::~rrsResDay () {

  if (m_hope) delete m_hope;

  if (m_opts) delete m_opts;

}

//----------------------------------------------------------------------
//  take_msg  - take and react to a message

void rrsResDay::take_msg (aipMsg *mm) {

  rrsMsg *m = (rrsMsg *)mm;

  if (m->typ() == HH_Starting_New_Try) {
    m_is_in_cur_solution = 0;
  }

  m->set_is_in_cur_solution(m_is_in_cur_solution);
  m_hope->take_msg(mm);

}

//----------------------------------------------------------------------
//  Note that a decision involving this resday has been decided

void rrsResDay::note_rrs_decide (rrsDecision *d, rrsOption *o) {

  if (!d) log ("rrsReqDay d is null");

  // o (ptr to an option) may be null

  if (o) m_is_in_cur_solution = 1;

}


//======================================================================
