#  Create the sample programs on a Linux system

echo "  Setting up..."
touch aiParts.a
rm aiParts.a

echo "  Compiling aiParts software..."
g++ -c aipHighHope.cpp  aipProblem.cpp      aipDecision.cpp \
       aipEmotion.cpp   aipPandemonium.cpp  aipTime.cpp \
       aipBase.cpp      aipGood.cpp

echo "  Creating library..."
ar rcs aiParts.a  aipHighHope.o  aipProblem.o      aipDecision.o \
                  aipEmotion.o   aipPandemonium.o  aipTime.o \
                  aipBase.o      aipGood.o

rm aipHighHope.o  aipProblem.o      aipDecision.o \
   aipEmotion.o   aipPandemonium.o  aipTime.o \
   aipBase.o      aipGood.o

echo "  Compiling and linking samp_1_good..."
g++ -o samp_1_good samp_good.cpp aiParts.a

echo "  Compiling and linking samp_2_pandemonium..."
g++ -o samp_2_pandemonium samp_pandemonium.cpp aiParts.a

echo "  Compiling and linking samp_3_decision..."
g++ -o samp_3_decision samp_decision.cpp samp_deer_fear.cpp aiParts.a

echo "  Compiling and linking samp_4_a_to_b..."
g++ -o samp_4_a_to_b samp_a_to_b.cpp samp_a2b.cpp aiParts.a

echo "  Compiling and linking samp_5_time..."
g++ -o samp_5_time samp_time.cpp aiParts.a

echo "  Cleaning up..."
rm aiParts.a

echo "Done"

