//**********************************************************************
//  aipProblem.h   -   Problem -  a set of problems for which
//                                  decisions have to be chosen.
//
//  Provides: aipProblem  aipDecisionItr
//
//  An aipProblem problem:
//   - has a set of decisions
//   - takes a series of messages, which it passes to its decisions  
//   - has a solve() function choose options for he decisions
//
//  A pandemonium is a set of objects.
//  aipProblem is a set of aipDecision.
//
//  Copyright (c)  2005, 2008  Brian Marshall
//
//  See the license at end of this file.
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  08/01/01  [BRM] removed delete_decision()
//  05/09/20  [BRM] Development begins
//
//----------------------------------------------------------------------

#ifndef aipProblem_h_guard
#define aipProblem_h_guard

#include "aipDecision.h"

//----------------------------------------------------------------------
//  Classes.  Sub-classing is shown by indentation.

//  class  aipG  is a typedef for  aipGoodness

//  Hope is a compound emotion composed of Fear, Greed and Curiosity

// class aipBase;                        ( in aipBase.h )
     class aipProblem;             // set of decisions and solve() 
// class aipDemonItr;                    ( in aipPandemonium.h )
     class aipDecisionItr;         // decision iterator


//======================================================================
//  aipProblem
//
//  The heart of a problem is:
//    - a set of decisions
//    - a solve() function choose options for each decision
//
//  solve() is a pure virtual function in this class.
//  Applications will want to use a subclass that knows how to
//  solve itself, a class that provides solve().

class aipProblem : public aipBase {

  aipPandemonium * m_decisions;   // a set of decisions

protected:

  aipPandemonium * decision_pandemonium() const {     // for iterators
    return m_decisions; 
  }

public:

  aipProblem ();
  virtual ~aipProblem ();

  void add_decision (aipDecision *x) { m_decisions->add(x); }

  aipDecisionItr decision_iterator() const;

  virtual void take_msg (aipMsg *m);

  virtual aipG g() { return aipNeutral; }

  long num_decisions() const { return m_decisions->num(); }

  virtual aipG solve() =0;              // pure virtual function

};


//======================================================================
//  aipDecisionItr  -  Iterator for decisions in a problem

class aipDecisionItr : public aipDemonItr {

public:

  aipDecisionItr () : aipDemonItr() {}

  aipDecisionItr (aipPandemonium *p) {
    set_demon_itr (p,0);
  }

  aipDecisionItr (const aipDecisionItr& x) {
    set_demon_itr (x.pandemonium(), x.current());
  }

  virtual ~aipDecisionItr () {}

  aipDecisionItr& operator = (const aipDecisionItr& x) {
    set_demon_itr (x.pandemonium(), x.current());
    return *this;
  }

  aipDecision * first() { return (aipDecision*)aipDemonItr::first(); }
  aipDecision * next()  { return (aipDecision*)aipDemonItr::next();  }

};


//======================================================================

#endif

//======================================================================
//                           License
//
//   Permission is hereby granted, free of charge, to any 
//   person obtaining a copy of this software and associated 
//   documentation files (the "Software"), to deal in the Software 
//   without restriction, including without limitation the rights 
//   to use, copy, modify, merge, publish, distribute, sublicense, 
//   and/or sell copies of the Software, and to permit persons to 
//   whom the Software is furnished to do so, subject to the 
//   following conditions:
//
//   The copyright notice and this license shall be included in all 
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
//   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
//   NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
//   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
//   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
//   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
//   OTHER DEALINGS IN THE SOFTWARE.
//
//**********************************************************************

