//**********************************************************************
//  aipProblem.cpp  -  function bodies for aipProblem.h
//
//  Copyright (c)  1999, 2005  Brian Marshall
//
//  See the license at end of this file.
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  05/11/19  [BRM] problem take_msg() calls pandemonium take_msg()
//  05/09/26  [BRM] development began
//
//----------------------------------------------------------------------

#include "aipProblem.h"


//======================================================================
//  aipProblem
//
//----------------------------------------------------------------------
//  Constructor

aipProblem::aipProblem () {

  m_decisions = new aipPandemonium;

}

//----------------------------------------------------------------------
//  Destructor

aipProblem::~aipProblem () {

  if (m_decisions) delete m_decisions;

}

//----------------------------------------------------------------------
//  decision_iterator - return an iterator to the decisions of this problem.

aipDecisionItr aipProblem::decision_iterator() const {

  aipDecisionItr i(m_decisions);

  return i;

}

//----------------------------------------------------------------------
//  take_msg  - take a message and distribute to decisions
//
//  Overriding functions gemerally must call this function.

void aipProblem::take_msg (aipMsg *m) {

  m_decisions->take_msg(m);

}

//======================================================================
//  aipDecisionItr  -  Decision iterator
//
//    All function bodies are in the header file
//
//======================================================================
//                           License
//
//   Permission is hereby granted, free of charge, to any 
//   person obtaining a copy of this software and associated 
//   documentation files (the "Software"), to deal in the Software 
//   without restriction, including without limitation the rights 
//   to use, copy, modify, merge, publish, distribute, sublicense, 
//   and/or sell copies of the Software, and to permit persons to 
//   whom the Software is furnished to do so, subject to the 
//   following conditions:
//
//   The copyright notice and this license shall be included in all 
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
//   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
//   NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
//   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
//   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
//   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
//   OTHER DEALINGS IN THE SOFTWARE.
//
//
//**********************************************************************
