//**********************************************************************
//  aipImportance.h   -   Importance - a base class
//
//  Provides:  aipImportance
//
//  Importances derive from aipBase; they can take_msg().
//
//  Copyright (c)  2007  Brian Marshall
//
//  See the license at end of this file.
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  07/12/24  [BRM] development begun.
//
//----------------------------------------------------------------------
//  Implementation
//
//  Currently, a call to importance.val() recalculates the value each 
//  time it is called:  val() in a subclass returns val() in the parent
//  class plus one or more aspects.  These aspects change, mostly
//  in calls to importance.take_msg().
//
//----------------------------------------------------------------------

#ifndef aipImportance_h_guard
#define aipImportance_h_guard

#include "aipBase.h"

//----------------------------------------------------------------------
//  Classes.  Sub-classing is shown by indentation.

// class aipBase;              (in aipBase.h)
     class  aipImportance;     // Base class for importances


//======================================================================
//  aipImportance   -   Base class for importances

class aipImportance : public aipBase {

public:

  aipImportance () {}
  virtual ~aipImportance () {}

  virtual long val () const { return 0; }

  virtual void take_msg (aipMsg *m) {}

};


//======================================================================

#endif

//======================================================================
//                           License
//
//   Permission is hereby granted, free of charge, to any 
//   person obtaining a copy of this software and associated 
//   documentation files (the "Software"), to deal in the Software 
//   without restriction, including without limitation the rights 
//   to use, copy, modify, merge, publish, distribute, sublicense, 
//   and/or sell copies of the Software, and to permit persons to 
//   whom the Software is furnished to do so, subject to the 
//   following conditions:
//
//   The copyright notice and this license shall be included in all 
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
//   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
//   NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
//   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
//   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
//   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
//   OTHER DEALINGS IN THE SOFTWARE.
//
//**********************************************************************

